// draw_bases.js
// collision debug aid for Sphere 
// -- draw all obstruction bases

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// DrawBases() draws the outline of the obstruction base  
//  of every person on the map.

RequireScript("ui/screen_rect.js");
// also uses Layer

// flag parameter to enable the feature

ObstructionBasesFlag = PlayerFlag("ObstructionBases", false);

// colors

ObstructionBasesOutlineColor = CreateColor(255, 0, 0, 200);  // red

// rendering function (to be called via SetRenderScript())

function DrawBases() {
  if (!ObstructionBasesFlag) {
    return;
  }
  //DebugCall("DrawBases");
  
  // save clipping rectangle
  var old_clip = ScreenRect();
  
  MapWindow.clip();

  var person_names = GetPersonList();
  for (var i in person_names) {
    var name = person_names[i];
    DrawPersonObstructionBase(name);
  }
  
  // restore old clipping rectangle
  old_clip.clip();
}

function DrawPersonObstructionBase(name) {  
  //DebugCall("DrawPersonObstructionBase", [name]);
  
  var x = MapToScreenX(Layer, GetPersonX(name));
  var y = MapToScreenY(Layer, GetPersonY(name));
  var b = GetPersonBase(name);
    
  // find upper left corner of base
  x -= (b.x2 - b.x1)/2;
  y -= (b.y2 - b.y1)/2;
  var width = b.x2 - b.x1 + 1;
  var height = b.y2 - b.y1 + 1;
  OutlinedRectangle(x, y, width, height, ObstructionBasesOutlineColor);
}
