// debug.js
// debugging aids for Sphere

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
// uncomment the following line to use the debugging log:
//DebugLog = OpenLog("debug.log");//

// dump global variables to a file
function DumpGlobals(filename) {

  // comment out the following line to get a dump
  //return;
  
  var globals = GetGlobalObject();

  var names = [];
  for (var i in globals) {
    names.push(i);
  }
  names.sort();
  
  var str = ""; 
  for (var i in names) {
    var name = names[i];
    //str += name + " = " + globals[name] + "\n";
    str += name + "\n";
  }
  Dump(str, filename);
}

// return an array containing all global variables
var __global_object__ = this;
function GetGlobalObject() {
  return __global_object__;
}

function Dump(str, filename) {
  var file = OpenRawFile(filename, true);
  file.write(CreateByteArrayFromString(str));
  file.close();
}

DebugCallTime = GetTime();

// log a function call
function DebugCall(func, args, extra_text) {
  if (DebugLog == undefined) {
    return;
  }

  var call_time = GetTime();  
  
  var log_line = func; 
  if (args == undefined) {
    log_line += "()";
  } else {
    log_line += QuoteArgs(args);
  }
  
  if (extra_text != undefined) {
    log_line += " " + extra_text;
  }
  
  DebugLog.write(String(call_time - DebugCallTime) + " " + log_line);
  DebugCallTime = call_time;
}

// convert an argument list to a string
function QuoteArgs(args) {
  var separator = ", ";
 
  var tmp = new Array();
  for (var i in args) {
    tmp[i] = Quote(args[i]);
  }
  
  var str = "(" + tmp.join(separator) + ")";
   
  return str;
}

// convert an argument list to a string
function Quote(value) {
  var result;
  
  if (typeof(value) == "object") {
    if (value.quote != undefined) {
      return value.quote();
    } else if (value.red != undefined) {
      return FormatColor(value);
    }
    return value.toString();
    
  } else if (typeof(value) != "string") {
    return String(value);
    
  }

  // escape any double-quotes in string
  var result = "";
  for (var i = 0; i < value.length; i++) {
    var c = value.charAt(i);
    if (c == '"') {
      result += '\\';
    }
    result += c;
  }
      
  return '"' + result + '"';
}

function FormatColor(color) {

  if (color == undefined) {
    return "undefined";
  }

  var body;
  var alpha = color.alpha;
  if (alpha <= 0) {
    body = "alpha:" + Quote(alpha);
    
  } else if (alpha >= 255) {
    body = FormatRGB(color);

  } else {
    body = FormatRGB(color) + ", alpha:" + Quote(alpha);
  }
  
  return "Color{" + body + "}";
}

function FormatRGB(color) {

  if (color.red == 255 && color.green == 255 && color.blue == 255) {
    return "white";
    
  } else if (color.red == 0 && color.green == 0 && color.blue == 0) {
    return "black";
    
  }
  
  return   "red:" + Quote(color.red) 
       + ", green:" + Quote(color.green) 
       + ", blue:" + Quote(color.blue);
}

function QuoteList(list) {
  var separator = ", ";
  
  var tmp = new Array();
  for (var i in list) {
    tmp[i] = Quote(list[i]);
  }
  
  var str = "[" + tmp.join(separator) + "]";

  return str;
}

// convert a rectangle into a string
function FormatRect(r) {
  return "[x=" + Quote(r.x) + " y=" + Quote(r.y) + " w=" + Quote(r.width) + " h=" + Quote(r.height) + "]";
}

// convert an x,y coordinate pair into a string
function Location(x, y) {
  return "[x=" + Quote(x) + " y=" + Quote(y) + "]";
}