// add_parms.js
// scenario parameter types for Sphere

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
RequireScript("utilities/parameter.js");
RequireScript("utilities/scenario.js");

// These functions are syntactic "sugar" for convenience in
// adding parameters to the active scenario.
 
// add an enumerated parameter
function Enum(name, default_value, value_list) {
  //DebugCall("Enum", [name, default_value]);
  
  var value_type = typeof(default_value);
  if (value_type != "string" && value_type != "number") {
    Abort("Invalid default_value in Enum() type=" + value_type);
  }

  var eval = name;    
  ActiveScenario.addParameter(name, eval, default_value, value_list);

  return default_value;
}

// add an optional enumerated parameter
function OptionalEnum(name, default_value, value_list, enabler) {
  //DebugCall("OptionalEnum", [name, default_value, value_list, enabler]);
  
  var value_type = typeof(default_value);
  if (value_type != "string" && value_type != "number") {
    Abort("Invalid default_value in OptionalEnum() type=" + value_type);
  }

  var eval = name;    
  ActiveScenario.addParameter(name, eval, default_value, value_list, enabler);

  return default_value;
}

// add a player preference enumerated parameter
function PlayerEnum(name, default_value, value_list) {
  //DebugCall("PlayerEnum", [name, default_value]);
  
  var value_type = typeof(default_value);
  if (value_type != "string" && value_type != "number") {
    Abort("Invalid default_value in PlayerEnum() type=" + value_type);
  }

  var eval = name;
  var extended_value_list = [ "player preference" ];
  for (var i in value_list) {
    extended_value_list.push(value_list[i]);
  }
  
  ActiveScenario.addParameter(name, eval, 
    "player preference", extended_value_list);
  PlayerPreferences.addParameter(name, eval, 
    default_value, value_list);


  return "player preference";
}

// add a flag parameter
function Flag(name, default_value) {
  //DebugCall("Flag", [name, default_value]);

  var value_type = typeof(default_value);
  if (value_type != "boolean") {
    Abort("Invalid default_value in Flag() type=" + value_type);
  }
  
  var eval = name + "Flag";    
  var value_list = FlagValueList;  
  ActiveScenario.addParameter(name, eval, default_value, value_list);
  
  return default_value;
}

// add an optional flag parameter
function OptionalFlag(name, default_value, enabler) {
  //DebugCall("OptionalFlag", [name, default_value, enabler]);

  var value_type = typeof(default_value);
  if (value_type != "boolean") {
    Abort("Invalid default_value in OptionalFlag() type=" + value_type);
  }
  
  var eval = name + "Flag";    
  var value_list = FlagValueList;
  ActiveScenario.addParameter(name, eval, default_value, value_list, enabler);
  
  return default_value;
}

// add a debug-only flag parameter
function DebugOnlyFlag(name, default_value) {
  //DebugCall("DebugOnlyFlag", [name, default_value]);

  var value_type = typeof(default_value);
  if (value_type != "boolean") {
    Abort("Invalid default_value in DebugOnlyFlag() type=" + value_type);
  }

  return OptionalFlag(name, default_value, "DebugFlag");
}

// add a player preference flag parameter
function PlayerFlag(name, default_value) {
  //DebugCall("PlayerFlag", [name, default_value]);

  var value_type = typeof(default_value);
  if (value_type != "boolean") {
    Abort("Invalid default_value in PlayerFlag() type=" + value_type);
  }

  var eval = name + "Flag";
  ActiveScenario.addParameter(name, eval, 
    PlayerFlagValue, PlayerFlagValueList);
  PlayerPreferences.addParameter(name, eval, 
    default_value, FlagValueList);
  
  return PlayerFlagValue;
}