// mouse.js
// mouse pointer updates for Sphere

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
RequireScript("ui/window.js");
RequireScript("utilities/graphics.js");

// resource

DefaultPointerImage = LoadScaledImage("3d-pointer", 0.03*Screen.width);

// status

ActiveWindows = [];
EndClickAction = undefined;
LastLeft = IsMouseButtonPressed(MOUSE_LEFT);
LastRight = IsMouseButtonPressed(MOUSE_RIGHT);

function UpdateMouse(pointer_image) {
  //DebugCall("UpdateMouse", [pointer_image]);

  var saved_clip = new ScreenRect();
  Screen.clip();
  
  var screen_x = GetMouseX();
  var screen_y = GetMouseY();
  if (pointer_image != undefined) {
    pointer_image.blit(screen_x, screen_y);
  }
 
  var left = IsMouseButtonPressed(MOUSE_LEFT);
  var right = IsMouseButtonPressed(MOUSE_RIGHT);
  //DebugLog.write("  left=" + Quote(left) + " right=" + Quote(right));
  
  if (left && !LastLeft) {
    //DebugLog.write("pressed left mouse button");
    Click("left", screen_x, screen_y);
  } else if (!left && LastLeft) {
    //DebugLog.write("released left mouse button");
    EndClick();
  }
  LastLeft = left;

  if (right && !LastRight) {
    //DebugLog.write("pressed right mouse button");
    Click("right", screen_x, screen_y);
  } else if (!right && LastRight) {
    //DebugLog.write("released right mouse button");
    EndClick();
  }
  LastRight = right;

  saved_clip.clip();
}

function Click(button, screen_x, screen_y) {
  //DebugCall("Click", [button, screen_x, screen_y]);

  for (var i in ActiveWindows) {
    var window = ActiveWindows[i];
    
    if (window.click != undefined && window.contains(screen_x, screen_y)) {
      window.click(button, screen_x, screen_y);
    }
  }
}

function EndClick() {
  //DebugCall("EndClick");

  var action = EndClickAction;
  if (action != undefined) {
    //DebugLog.write("EndClick action=" + Quote(action));
    eval(action);
  }
  EndClickAction = undefined;
}

function MapClick(button, screen_x, screen_y) {
  //DebugCall("MapClick", [button, screen_x, screen_y]);
  
  if (button == "left" && LeftClickIcon != undefined) {
    LeftClickIcon.mapClick(screen_x, screen_y);
  }
  if (button == "right" && RightClickIcon != undefined) {
    RightClickIcon.mapClick(screen_x, screen_y);
  }
}