// icon.js
// Icon class for Sphere

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
// An Icon is a Window that displays an image.

// The three types react differently to mouse clicks:
//   "Action" icons simply call functions.
//   "Mode" icons alter the behavior of the mouse button for map clicks.
//   "Toggle" icons toggle global flags.

// configuration

LeftButtonImage = LoadImage("black-button.png");
RightButtonImage = LoadImage("black-button.png");
CheckImage = LoadImage("check.png");
ExImage = LoadImage("ex.png");

IconStyle = LoadWindowStyle("rounded12.rws");
IconStyle.thickness = 12; // pixels

IconColor = CreateColor(130, 130, 130);       // grey
IconHoverColor = CreateColor(180, 130, 180);  // purple-grey
IconGreyed = CreateColor(130, 130, 130, 160); // translucent grey

RequireScript("ui/mouse.js");

LeftClickIcon = undefined;
RightClickIcon = undefined;

// constructor

Icon.prototype = new Window();
Icon.prototype.constructor = Icon;

function Icon(rect) {
  if (this instanceof Icon == false) {
    return new Icon(rect);
  }
  //DebugCall("Icon", [rect]);

  //initialize properties
  Window.apply(this, [rect, IconColor, IconStyle]);
}

Icon.prototype.bindAction = 
function (on_activate, image_name, condition) {
  //DebugCall("Icon.bindAction", [on_activate, image_name, condition]);

  this.activate = on_activate;
  this.activeFlag = undefined;
  this.click = this.conditionalActivate;
  this.condition = condition;
  this.flagName = undefined;
  this.mapClick = undefined;
  this.loadImages(image_name);
  
  ActiveWindows.push(this);
  
  return this;
}

Icon.prototype.bindMode =
function (on_map_click, image_name) {
  //DebugCall("Icon.bindMode", [on_map_click, image_name]);
  
  this.activeFlag = undefined;
  this.click = this.setMode;
  this.condition = undefined;
  this.flagName = undefined;
  this.mapClick = on_map_click;
  this.loadImages(image_name);
  
  ActiveWindows.push(this);
  
  return this;
}

Icon.prototype.bindToggle = 
function (flag_name, image_name, active_image_name, condition) {
  //DebugCall("Icon.bindToggle", [flag_name, image_name, active_image_name, condition]);

  this.click = this.toggle;
  this.activeFlag = eval(flag_name);
  this.condition = condition;
  this.flagName = flag_name;
  this.mapClick = undefined;
  this.loadImages(image_name, active_image_name);
  
  ActiveWindows.push(this);
  
  return this;
}

Icon.prototype.conditionalActivate =
function (button, x, y) {
  //DebugCall("Icon.conditionalActivate");

  if (this.condition == undefined || eval(this.condition)) {
    this.activate(button, x, y);
  }
}

Icon.prototype.disable =
function () {
  //DebugCall("Icon.disable");
  
  this.condition = false;
  
  if (this == LeftClickIcon) {
    LeftClickIcon = undefined;
  }
  if (this == RightClickIcon) {
    RightClickIcon = undefined;
  }
}
  
Icon.prototype.draw =
function () {
  //DebugCall("Icon.draw");
  
  var flag_name = this.flagName;
  if (flag_name != undefined) {
    // update toggle state
    this.activeFlag = eval(flag_name);
  }
 
  // select image
  var image = this.image;
  var label = this.label;
  if (this.activeFlag == true) {
    image = this.activeImage;
    label = this.activeLabel;
  }
  if (this.style == undefined) {
    label = undefined;
  }

  if (image == undefined) {
    // unbound icon = blank window
    Window.prototype.draw.apply(this, []);
  
  } else if (this.condition != undefined && !eval(this.condition)) {
    // greyed-out icon
    Window.prototype.draw.apply(this, []);
    this.interior.centerBlit(image);
    this.interior.drawLabel(label);
    this.interior.fill(IconGreyed);
    
  } else {
    if (this.contains(GetMouseX(), GetMouseY())) {
      // mouse is hovering here
      Window.prototype.draw.apply(this, [IconHoverColor]);
    } else {
      Window.prototype.draw.apply(this, []);
    }
    this.interior.centerBlit(image);
    this.interior.drawLabel(label);
  }

  // draw status indicators in the corners
  
  if (this == LeftClickIcon) {
    this.interior.ulcBlit(LeftButtonImage);
  }
  if (this == RightClickIcon) {
    this.interior.urcBlit(RightButtonImage);
  }

  if (this.image == this.activeImage) {
    if (this.activeFlag == true) {
      this.interior.topBlit(CheckImage);
    } else if (this.activeFlag == false) {
      this.interior.topBlit(ExImage);
    }
  }
}

Icon.prototype.loadImages = 
function (name, active_name) {
  //DebugCall("Icon.loadImages", [name, active_name]);

  var height = this.interior.height;
  var width = this.interior.width;
  
  this.image = LoadScaledImage(name, width, height, "icons");
  if (name.charAt(0) != "'") {
    this.label = name;
  } else {
    this.label = undefined;
  }
  
  if (active_name == undefined) {
    this.activeImage = this.image;
    this.activeLabel = this.label;
  } else {
    this.activeImage = LoadScaledImage(active_name, width, height, "icons");
    if (name.charAt(0) != "'") {
      this.activeLabel = active_name;
    } else {
      this.activeLabel = undefined;
    }
  }
}


Icon.prototype.setMode =
function (button) {
  //DebugCall("Icon.setMode", [button]);

  if (this.condition == undefined || eval(this.condition)) {
    if (button == "left") {
      LeftClickIcon = this;
    } else if (button == "right") {
      RightClickIcon = this;
    } else {
      Abort("Unknown button in Icon.setMode(): " + Quote(button));
    }
  }
}

Icon.prototype.toggle =
function () {
  //DebugCall("Icon.toggle");
  
  if (this.condition == undefined || eval(this.condition)) {
    var flag_name = this.flagName;
    this.activeFlag = eval(flag_name);
    eval(flag_name + "=" + String(!this.activeFlag));
  }
}