// team.js
// Team class for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

RequireScript("roster.js");

Blue = new Team("blue");
Red = new Team("red");

function Team(name) {
  if (this instanceof Team == false) {
    return new Team(name);
  }
  //DebugCall("Team", [name], Quote(this));
  
  this.name = name;
  
  return this;
}

Team.prototype.hasCrusher =
function() {
  //DebugCall("Team.hasCrusher", [], Quote(this));

  var result = (this.numCrushers > 0);  
  
  return result;
}

Team.prototype.hasPortal =
function() {
  //DebugCall("Team.hasPortal", [], Quote(this));

  var result = !this.allPortals.isEmpty();
  
  return result;
}

Team.prototype.hasKiller =
function() {
  //DebugCall("Team.hasKiller", [], Quote(this));

  if (this.numFlys > 0) {
    return true;
  }
  
  for (var name in this.upCharacters.members) {
    var character = this.upCharacters.members[name];
    if (character.isKiller()) {
      return true;
    }
  }
  
  return false;
}

Team.prototype.isDefeated =
function() {
  //DebugCall("Team.isDefeated", [], Quote(this));

  if (!this.hasPortal()) {
    //DebugLog.write("Team lacks portals.");
    
    if (!this.hasKiller()) {
      //DebugLog.write("Team lacks killers.");
      // TODO: elfs are not lethal
      return true;
    }
    
    if (this.opposite.hasPortal() && !this.hasCrusher()) {
      //DebugLog.write("Team lacks crushers while enemy still has portals.");
      return true;
    }
  }

  return false;
}

Team.prototype.points =
function() {
  //DebugCall("Team.points", [], Quote(this));
  var count = this.allPortals.count()
            + this.upCharacters.count();
  
  return count;
}

Team.prototype.quote =
function() {
  return "Team{name:" + Quote(this.name) + "}";
}

Team.prototype.reset =
function() {
  //DebugCall("Team.reset", [], Quote(this));

  this.numCrushers = 0;   // knights and sands
  this.numFlys = 0;       // arrows flying toward targets
  this.allPortals = new Roster(this.name + ".allPortals");
  this.upCharacters = new Roster(this.name + ".upCharacters");
}

Team.prototype.setOpposite =
function(other_team) {
  //DebugCall("Team.setOpposite", [other_team], Quote(this));

  if (other_team instanceof Team == false) {
    Abort("Invalid other_team in Team.setOpposite(): " + Quote(other_team));
  }
  
  this.opposite = other_team;
}

function FindCrusher(map_xy, include_blue_flag, include_red_flag) {
  //DebugCall("FindCrusher", [map_xy, include_blue_flag, include_red_flag]);

  var best;
  if (include_blue_flag == undefined || include_blue_flag) {
    best = Blue.upCharacters.bestCrusher(map_xy);
  }
  if (include_red_flag == undefined || include_red_flag) {
    best = Red.upCharacters.bestCrusher(map_xy, best);
  }
  
  return best;
}

// find up character (based on screen distance)
function FindUp(map_xy, include_blue_flag, include_red_flag) {
  //DebugCall("FindUp", [map_xy, include_blue_flag, include_red_flag]);

  var best;
  if (include_blue_flag == undefined || include_blue_flag) {
    best = Blue.upCharacters.best(map_xy);
  }
  if (include_red_flag == undefined || include_red_flag) {
    best = Red.upCharacters.best(map_xy, best);
  }
  
  return best;
}