// soundfx.js
// stereo sound effects for battle simulation (Sphere)

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// TODO: rewrite this to use the Sphere 1.5 SoundEffect class?

// configuration

SoundFlag = PlayerFlag("Sound", true);

RequireScript("entities/entity.js");
RequireScript("utilities/random.js");
// also uses MapWindow

SoundFxCache = [];  // cache for soundfx objects

function CacheAllSoundFx() {
  //DebugCall("CacheAllSoundFx");
  
  CacheSoundFx("ack order", "hearobey.wav", 50, 0.9, 1.1);
  CacheSoundFx("bolt", "smack.wav", 100, 0.1, 0.2);
  CacheSoundFx("bounce arrow", "deflect2.wav");
  CacheSoundFx("bounce sands", "sword.wav");
  CacheSoundFx("bounce knight", "sword.wav");
  CacheSoundFx("damage portal", "crunch2.wav");
  CacheSoundFx("new arrow", "bowstring2.wav", 100);
  CacheSoundFx("spawn archer", "tada.wav", 8);
  CacheSoundFx("spawn sands", "tada.wav", 8);
  CacheSoundFx("spawn knight", "tada.wav", 8);
  CacheSoundFx("zap", "pulse.wav", 20, 2, 2);
}

function CacheSoundFx(name, sound_filename, base_volume, pitch1, pitch2) {
  if (base_volume == undefined || base_volume > 100) {
    base_volume = 100;
  }
  //DebugCall("CacheSoundFx", [name, sound_filename, base_volume, pitch1, pitch2]);
  
  var low_pitch, high_pitch;
  if (pitch2 != undefined) {
    low_pitch = pitch1;
    high_pitch = pitch2;
  } else {
    if (pitch1 == undefined) {
      pitch1 = 1;
    }
    low_pitch = 0.85 * pitch1;
    high_pitch = 1.15 * pitch1;
  }
  
  var s = new Object();
  s.low_pitch = low_pitch;
  s.high_pitch = high_pitch;
  s.percent = base_volume;   // base volume (1 .. 100)
  s.sound_filename = sound_filename;

  s.sound = LoadSound(sound_filename, false);
  
  var first = SoundFxCache[name];
  if (first == undefined) {
    // first instance with this name
    s.prev = s;
    s.next = s;
    SoundFxCache[name] = s;
  } else {
    // add to end of list for this name
    s.prev = first.prev;
    s.next = first;
    first.prev = s;
    s.prev.next = s;
  }
  
  return s;
}

function PlaySoundFx(name, entity) {
  if (!SoundFlag) {
    return;
  }  
  //DebugCall("PlaySoundFx", [name, entity]);

  if (entity instanceof Entity == false) {
    Abort("Invalid entity: " + Quote(entity));
  }
  
  var first = SoundFxCache[name];
  if (first == undefined) {
    //DebugLog.write("unknown soundfx: " + Quote(name) + " in PlaySoundFx()");
    //Abort("unknown soundfx: " + Quote(name) + " in PlaySoundFx()");
    return;
  }
  
  var s = first;
  if (s.sound.isPlaying()) {
    while (s.next != first && s.sound.isPlaying()) {
      //DebugLog.write(" already playing " + Quote(s.sound_filename));
      s = s.next;
    }
    if (s.next == first) {
      //DebugLog.write(" create duplicate " + Quote(s.sound_filename));
      s = CacheSoundFx(name, first.sound_filename, first.percent, first.low_pitch, first.high_pitch);
    }
  }
  //DebugLog.write(" sound = " + Quote(s.sound_filename) + " at [" + Quote(s.low_pitch) + ", " + Quote(s.high_pitch) + "]");
  SoundFxCache[name] = s.next;
  //DebugLog.write(" next = " + Quote(s.next.sound_filename));

  // get screen coordinates of sound-producing entity
  var x = entity.getScreenX();
  var y = entity.getScreenY();
  
  //DebugLog.write(" x = " + Quote(x) + ", y = " + Quote(y));
    
  var pan = (x - MapWindow.x)/MapWindow.width - 0.5;
  if (pan > 1) {
    pan = 1;
  } else if (pan < -1) {
    pan = -1;
  }
  pan = 255*pan;
  
  var closeness = (y - MapWindow.y)/MapWindow.height;
  if (closeness < 0) {
    closeness = 0;
  } else if (closeness > 1) {
    closeness = 1;
  }
  closeness = 1 + 1.55*closeness;
  
  //DebugLog.write(" pan=" + Quote(pan) + ", closeness=" + Quote(closeness));
 
  var pitch = Triangular(s.low_pitch, s.high_pitch);
  var volume = closeness * s.percent;
  
  //DebugLog.write(" play " + Quote(s.sound_filename) + " at pitch=" + Quote(pitch) + ", volume=" + Quote(volume));
  var sound = s.sound;
  sound.setPan(pan);  
  sound.setPitch(pitch);
  sound.setVolume(volume);
  sound.play(false);
}