// zap.js
// render magical attacks in battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

RequireScript("entities/entity.js");
RequireScript("soundfx.js");
RequireScript("team.js");
RequireScript("utilities/graphics.js");

// colors

Blue.zapColor = CreateColor(128, 128, 255);
Red.zapColor = CreateColor(255, 0, 0);
TransparentColor = CreateColor(0, 0, 0, 0);

// status

Zaps = [];
FirstZap = 0;

// call DrawZaps() every frame via SetRenderScript()

// render all zap effects
function DrawZaps() {
  //DebugCall("DrawZaps");

  var len = Zaps.length;
  
  while (FirstZap < len && !Zaps[FirstZap].visibleFlag) {
    //DebugLog.write("zap #" + Quote(FirstZap) + " is invisible");
    FirstZap++;
  }
  
  for (var id = FirstZap; id < len; id++) {
    DrawZap(Zaps[id]);
  }
}
  
  
// render a zap effect
function DrawZap(zap) {
  //DebugCall("DrawZap");
  if (!zap.visibleFlag) {
    return;
  }

  var x1 = MapToScreenX(Layer, zap.x1);
  var y1 = MapToScreenY(Layer, zap.y1);
  var x2 = MapToScreenX(Layer, zap.x2);
  var y2 = MapToScreenY(Layer, zap.y2);
  var x3 = MapToScreenX(Layer, zap.x3);
  var y3 = MapToScreenY(Layer, zap.y3);
  
  var radius = 12/ResolutionCm;
  OutlinedCircle(x1, y1, radius, zap.color); // halo
  GradientTriangle(x1, y1, x2, y2, x3, y3, zap.color, TransparentColor, TransparentColor);
}

// create a new zap effect
function Zap(source, target) {
  //DebugCall("Zap", [source, target]);

  if (typeof(source) == "string") {
    source = AllEntities.find(source);
  }
  if (typeof(target) == "string") {
    target = AllEntities.find(target);
  }

  if (source.zapId != undefined) {
    Abort("concurrent zaps from " + Quote(source));
  }

  var x1 = source.getMapX();  
  var y1 = source.getMapY();
  
  var direction = source.getDirectionName();
  var version = source.version;
  
  x1 += WandX(direction, version);  
  y1 += WandY(direction, version);
  
  var xx = target.getMapX();
  var yy = target.getMapY();
  
  var left = xx - 25/ResolutionCm;
  var top = yy - 140/ResolutionCm;
  var right = xx + 25/ResolutionCm;
  var bottom = yy;

  var zap = new Object;
  zap.x1 = x1;  
  zap.y1 = y1;
  if (x1 < left) {
    if (y1 < top) {
      zap.x2 = right; zap.y2 = top;
      zap.x3 = left;  zap.y3 = bottom;
    } else if (y1 > bottom) {
      zap.x2 = right; zap.y2 = bottom;
      zap.x3 = left;  zap.y3 = top;
    } else {
      zap.x2 = left;  zap.y2 = top;
      zap.x3 = left;  zap.y3 = bottom;
    }
  } else if (x1 > right) {
    if (y1 < top) {
      zap.x2 = right; zap.y2 = bottom;
      zap.x3 = left;  zap.y3 = top;
    } else if (y1 > bottom) {
      zap.x2 = right; zap.y2 = top;
      zap.x3 = left;  zap.y3 = bottom;
    } else {
      zap.x2 = right; zap.y2 = top;
      zap.x3 = right; zap.y3 = bottom;
    }
  } else {
    if (y1 < top) {
      zap.x2 = left;  zap.y2 = top;
      zap.x3 = right; zap.y3 = top;
    } else if (y1 > bottom) {
      zap.x2 = left;  zap.y2 = bottom;
      zap.x3 = right; zap.y3 = bottom;
    } else {
      zap.x2 = xx; zap.y2 = yy;
      zap.x3 = xx; zap.y3 = yy - 140/ResolutionCm;
    }
  }

  zap.color = source.team.zapColor;
  zap.visibleFlag = true;
  
  var id = Zaps.length;
  Zaps[id] = zap;
  source.zapId = id;

  PlaySoundFx("zap", source);
}

function UnZap(source) {
  //DebugCall("UnZap", [source]);
  
  if (typeof(source) == "string") {
    source = AllEntities.find(source);
  }
  var id = source.zapId;
  //DebugLog.write(" id = " + Quote(id));
  if (id == undefined) {
    return;
  }
  
  Zaps[id].visibleFlag = false;
  source.zapId = undefined;
}

// wand location hacks for "elf" models

function WandX(direction, version) {
  var x;
  
  if (version == "r") {
    switch (direction) {
      case "north":     x = 189; break;
      case "northeast": x = 257; break;
      case "east":      x = 286; break;
      case "southeast": x = 251; break;
      case "south":     x = 167; break;
      case "southwest": x = 91; break;
      case "west":      x = 74; break;
      case "northwest": x = 116; break;
      default:
        Abort("Unknown direction in WandX: " + Quote(direction));
    }
    
  } else {
    Abort("Unknown version in WandX: " + Quote(version));
  }
  
  return (x - 180)/ResolutionCm;
}

function WandY(direction, version) {
  var y;
  
  if (version == "r") {
    switch(direction) {
      case "north":     y = 106; break;
      case "northeast": y = 122; break;
      case "east":      y = 159; break;
      case "southeast": y = 196; break;
      case "south":     y = 209; break;
      case "southwest": y = 188; break;
      case "west":      y = 149; break;
      case "northwest": y = 117; break;
      default:
        Abort("Unknown direction in WandY: " + Quote(direction));
    }

  } else {
    Abort("Unknown version in WandY: " + Quote(version));
  }
  
  return (y - 230)/ResolutionCm;
}