// tzones.js
// target zone overlay for Sphere 

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// DrawTZone() draws the target zone outline of every person on the map
// call DrawTZone() every frame via SetLayerRenderer()

// settings, with defaults
//   note: choose colors that will contrast with the map!

// flag to enable this feature
TargetZonesFlag = PlayerFlag("TargetZones", false);

RequireScript("entities/character.js");
RequireScript("team.js");
RequireScript("utilities/debug.js");

// colors

Red.tzoneColor = CreateColor(255, 0, 0);   // red
Blue.tzoneColor = CreateColor(0, 0, 255);  // blue

function DrawTargetZones() {
  if (!TargetZonesFlag) {
    return;
  }
  //DebugCall("DrawTargetZones");
  
  // save clipping rectangle
  var old_clip = ScreenRect();
  
  MapWindow.clip();

  for (var name in Blue.upCharacters.members) {
    var entity = Blue.upCharacters.members[name];
    entity.drawTargetZone(Blue.tzoneColor);
  }
  for (var name in Red.upCharacters.members) {
    var entity = Red.upCharacters.members[name];
    entity.drawTargetZone(Red.tzoneColor);
  }
  
  // restore old clipping rectangle
  old_clip.clip();
}