// scoreboard.js
// scoreboard for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
// configuration

ScoreboardFlag = OptionalFlag("Scoreboard", false, "CheckForVictoryFlag");

RequireScript("entities/character.js");
RequireScript("entities/portal.js");
RequireScript("team.js");
RequireScript("ui/text_line.js");

// colors

Blue.scoreColor = CreateColor(128, 128, 255);      // light blue
Red.scoreColor = CreateColor(255, 0, 0);           // red
ScoreBackgroundColor = CreateColor(0, 0, 0, 170);  // shadow

// window style

ScoreboardStyle = LoadWindowStyle("rounded12.rws");
ScoreboardStyle.thickness = 12;


function CreateScoreboard(left_board, right_board) {
  //DebugCall("CreateScoreboard");

  var red_board, blue_board;
  if (Layout == "blue on left") {
    blue_board = left_board;
    red_board = right_board;
  } else {
    blue_board = right_board;
    red_board = left_board;
  }
  RedScoreboard = new TextLine(red_board, ShadowColor, 
     Red.scoreColor, undefined, "center");
  RedScoreboard.setStyle(ScoreboardStyle);
  
  BlueScoreboard = new TextLine(blue_board, ShadowColor, 
     Blue.scoreColor, undefined, "center");
  BlueScoreboard.setStyle(ScoreboardStyle);
}
  
function DrawScoreboard() {
  if (!ScoreboardFlag) {
    return;
  }
  //DebugCall("DrawScoreboard");
  
  var text;
  
  if (RedScoreboard != undefined) {
    text = String(Red.points());
    //text += "/" + String(MaxRoster);
    RedScoreboard.draw(text);
  }
  
  if (BlueScoreboard != undefined) {
    text = String(Blue.points());
    //text += "/" + String(MaxRoster);
    BlueScoreboard.draw(text);
  }
}