// eye.js
// map scrolling routines for battle simulation (Sphere)

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
// configuration

RequireScript("utilities/add_parms.js");

EyeFlag = PlayerFlag("Eye", false);

// colors and images

EyeImage = LoadImage("center.png");
EyeImage.hotX = 70;
EyeImage.hotY = 63;
EyeImage.scale = 0.25;

EyeColor = CreateColor(255, 255, 255, 170); // slightly translucent

RequireScript("coords.js");
RequireScript("locus.js");

// initially eyeing the center of battlefield
EyeLocus = FixedLocus([0, 0]);

function DrawEye() {
  if (!EyeFlag) {
    return;
  }
  
  var es_cm = LocusEsCm(EyeLocus);
    
  var map_x = CmToMapX(es_cm[0]);
  var map_y = CmToMapY(es_cm[1]);

  var x = MapToScreenX(Layer, map_x);
  var y = MapToScreenY(Layer, map_y);

  var zoom_scale = EyeImage.scale;
      
  // adjust to hotspot
  x -= zoom_scale * EyeImage.hotX;
  y -= zoom_scale * EyeImage.hotY;
  
  EyeImage.zoomBlitMask(x, y, zoom_scale, EyeColor);
}

// center the map view on the eye locus
function CenterMap() {
  //DebugCall("CenterMap");
  
  var es_cm = LocusEsCm(EyeLocus);
  var eye_x = CmToMapX(es_cm[0]);
  var eye_y = CmToMapY(es_cm[1]);
  
  // adjust for the map window being smaller than the screen
  eye_x += (Screen.width - MapWindow.width)/2;
  eye_y += (Screen.height - MapWindow.height)/2;

  SetCameraX(eye_x);
  SetCameraY(eye_y);
}

// transfer the eye to a character or a fixed location on the map
function ClickCenter(screen_x, screen_y) {
  //DebugCall("ClickCenter", [screen_x, screen_y]);

  var map_x = ScreenToMapX(Layer, screen_x);
  var map_y = ScreenToMapY(Layer, screen_y);

  var character = FindUp([map_x, map_y], true, true);
  if (character == undefined) {
    var east_cm = MapXToCm(map_x);
    var south_cm = MapYToCm(map_y);
    EyeLocus = FixedLocus([east_cm, south_cm]);
  } else {
    // project the character's eye to ground level
    var eye_level_cm = 145;
    var south_offset_cm = -eye_level_cm * PixelsPerEWCm / PixelsPerNSCm;
    EyeLocus = OffsetLocus(character, [0, south_offset_cm]); 
  }
}