// dtags.js
// directonal tags for battle simulator (Sphere) 
// -- tag characters controlled by directional arrows

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// DrawTZone() draws the target zone outline of every person on the map
// call DrawTZone() every frame via SetRenderScript()

RequireScript("entities/character.js");
RequireScript("utilities/graphics.js");

// flag to enable this feature

DirectionalTagsFlag = PlayerFlag("DirectionalTags", false);

// image

TagImage = LoadScaledImage("tag", 0.03*Screen.width);

function DrawDirectionalTags() {
  if (!DirectionalTagsFlag) {
    return;
  }
  //DebugCall("DrawDirectionalTags");
  
  var roster = Red.upCharacters;
  for (var name in roster.members) {
    var character = roster.members[name];
    if (character != undefined && character.directionalFlag) {
      character.drawDirectionalTag();
    }
  }
  
  roster = Blue.upCharacters;
  for (var name in roster.members) {
    var character = roster.members[name];
    if (character != undefined && character.directionalFlag) {
      character.drawDirectionalTag();
    }
  }
}

Character.prototype.drawDirectionalTag =
function() {  
  //DebugCall("Character.drawDirectionalTag");

  var x = this.getScreenX() - TagImage.width/2;
  var y = this.getScreenY() - TagImage.height/2;
  
  TagImage.blit(x, y);
}