// description.js
// description popups for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// windowstyle
    
CloudStyle = LoadWindowStyle("cloud50.rws");
CloudStyle.unit = 65; // pixels
CloudStyle.thickness = 50; // pixels

// colors

DescriptionBgColor = CreateColor(0, 75, 0);        // dark green
DescriptionTextColor = CreateColor(255, 255, 255); // white

DebugDescriptionBgColor = CreateColor(40, 0, 60);       // dark purple
DebugDescriptionTextColor = CreateColor(255, 255, 255); // white


RequireScript("describe.js");
RequireScript("entities/entity.js");
RequireScript("ui/text_box.js");

function ClickDebugDescribe(screen_x, screen_y) {
  //DebugCall("ClickDebugDescribe", [screen_x, screen_y]);
  var map_x = ScreenToMapX(Layer, screen_x);
  var map_y = ScreenToMapY(Layer, screen_y);

  DebugDescribeEntity = AllEntities.bestVisible([map_x, map_y]);
  EndClickAction = "DebugDescribeEntity=undefined";
}

function ClickDescribe(screen_x, screen_y) {
  //DebugCall("ClickDescribe", [screen_x, screen_y]);
  
  var map_x = ScreenToMapX(Layer, screen_x);
  var map_y = ScreenToMapY(Layer, screen_y);

  DescribeEntity = AllEntities.bestVisible([map_x, map_y]);
  EndClickAction = "DescribeEntity=undefined";
}

Entity.prototype.drawDebugDescription =
function() {
  //DebugCall("Entity.drawDebugDescription", [], Quote(this));
   
  var font = GetSystemFont();
  var text = this.getDebugDescription();

  var width = 260;
  var height = font.getStringHeight(text, width);
  
  var style = CloudStyle;
  var unit = style.unit;
  height = unit * Math.ceil(height/unit);
  width = unit * Math.ceil(width/unit);

  var screen_y = GetMouseY() - height/2; // center left edge on mouse pointer

  var rect = new ScreenRect(GetMouseX(), screen_y, width, height);
  var window = new Window(rect, DebugDescriptionBgColor, style);
  window.copyInterior(rect);
  var text_box = new TextBox(window, DebugDescriptionTextColor, text, font, "center");
  
  text_box.draw();
}

Entity.prototype.drawDescription =
function() {
  //DebugCall("Entity.drawDescription", [], Quote(this));
   
  var font = GetSystemFont();
  var text = "This " + this.describe();

  var width = 260;
  var height = font.getStringHeight(text, width);
  
  var style = CloudStyle;
  var unit = CloudStyle.unit;
  height = unit * Math.ceil(height/unit);
  width = unit * Math.ceil(width/unit);

  var screen_y = GetMouseY() - height/2; // center left edge on mouse pointer

  var rect = new ScreenRect(GetMouseX(), screen_y, width, height);
  var window = new Window(rect, DescriptionBgColor, style);
  window.copyInterior(rect);
  var text_box = new TextBox(window, DescriptionTextColor, text, font, "center");
  
  text_box.draw();
}