// bolt.js
// Bolt class for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
// a Bolt is used to draw a flash of lightning on the map

RequireScript("entities/team_entity.js");
RequireScript("ui/screen_rect.js");

BoltSeconds = 0.08; // duration in seconds

// configurable colors
Blue.boltColor = CreateColor(128, 128, 255); // light blue
Red.boltColor = CreateColor(255, 0, 0);      // red
ShadowColor = CreateColor(0, 0, 0, 170);     // shadow

// global instance

var TheBolt;

// constructor

function Bolt(target, screen_x, color) {
  //DebugLog.write("Bolt(" + Quote(target) + ", " + Quote(screen_x) + ", " + FormatColor(color) + ")");

  if (this instanceof Bolt == false) {
    return new Bolt(target, screen_x, color);
  }
  
  //initialize properties
  
  if (color == undefined) {
    color = target.team.opposite.boltColor;
    if (color == undefined) {
      Abort("Invalid foe color in Bolt(): " + Quote(foe_color));
    }
  }
  this.color = color;

  this.ticks = Math.ceil(BoltSeconds * TicksPerSecond);
  if (screen_x != undefined) {
    this.x = screen_x;
  } else {
    this.x = MapToScreenX(Layer, target.getMapX());
  }
  
  // bolt terminates 120 cm above target's base
  var heart_pixels = Math.round(120*PixelsPerVCm);
  this.y = MapToScreenY(Layer, target.getMapY() - heart_pixels);
  
  PlaySoundFx("bolt", target);
}

Bolt.prototype.draw = 
function () {  
  if (this.ticks <= 0) {
    return;
  }
  this.ticks--;
  //DebugLog.write("Bolt.draw()");
  
  var old_clip = new ScreenRect();
  MapWindow.clip();
  
  // darken the map
  MapWindow.fill(ShadowColor);
  
  var bias = 0.2;
  var x1 = this.x;
  var y1 = this.y;
  while (MapWindow.contains(x1, y1)) {
    var x2 = x1 + Triangular(-1, 1);
    var y2 = y1 + Triangular(-1, 1) - bias;
    Line(x1+1, y1, x2+1, y2, this.color);
    Line(x1-1, y1, x2-1, y2, this.color);
    Line(x1, y1+1, x2, y2+1, this.color);
    Line(x1, y1-1, x2, y2-1, this.color);
    x1 = x2;
    y1 = y2;
  }
  //var width = 3;
  //Rectangle(this.x-1, MapWindow.y, width, this.y - MapWindow.y, this.color);
  
  old_clip.clip();
}