// entities/bases.js
// collision debug aid for Sphere 
// -- draw all obstruction bases

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// DrawBases() draws the outline of the obstruction base  
//  of every person on the map.

RequireScript("entities/entity.js");
RequireScript("ui/screen_rect.js");

// flag parameter to enable the feature

ObstructionBasesFlag = PlayerFlag("ObstructionBases", false);

// colors

ObstructionBasesOutlineColor = CreateColor(255, 0, 0, 200);  // red

// rendering function (to be called via SetRenderScript())

function DrawBases() {
  if (!ObstructionBasesFlag) {
    return;
  }
  //DebugCall("DrawBases");
  
  // save clipping rectangle
  var old_clip = ScreenRect();
  
  MapWindow.clip();

  for (var name in AllEntities.members) {
    var entity = AllEntities.members[name];
    entity.drawObstructionBase();
  }
  
  // restore old clipping rectangle
  old_clip.clip();
}