// orders.js
// orders for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// The character's orders are coded as strings of text.
// A sequence of orders is called a "mission".

/*
 approach.portal  approach nearest enemy portal to within strikin range
 avoid.any@N      move away from nearest standing character within N cm
 avoid.foe@N      move away from nearest standing enemy within N cm
 avoid.hand@N     move away from nearest standing hand-to-hand foe within N cm
 defend.source@N  engage the target closest to your favorite portal
 directional      obey arrow keys until Ctrl key is pressed
 engage.any@N     engage the nearest target within N cm
 engage.archer@N  engage the nearest archer target within N cm
 engage.elf@N     engage the nearest elf target within N cm
 engage.sands@N   engage the nearest s&s target within N cm
 engage.knight@N  engage the nearest knight target within N cm
 go@LOCUS         go to LOCUS, then purge this order
 spin             spin clockwise in place
 stand            stand right where you are -- don't move
 stay@LOCUS       go to LOCUS and stay there -- useful for follow the leader
 wander@N         walk randomly, changing directions every N sim-seconds
*/

SampleMissions = [
  "approach.portal || engage.any",
  "avoid.foe",
  "defend.source || approach.portal",
  "directional",
  "engage.any",
  "engage.any || approach.portal",
  "stand",
  "stay@origin 0 0 0 1000 || wander@3"
];

OrderArgSeparator = "@";
OrderListSeparator = " || ";

RequireScript("entities/portal.js");
RequireScript("locus.js");

function ClickDirect(screen_x, screen_y) {
  //DebugCall("ClickDirect", [screen_x, screen_y]);
  
  var map_x = ScreenToMapX(Layer, screen_x);
  var map_y = ScreenToMapY(Layer, screen_y);

  var character = FindUp([map_x, map_y], CommandBlueFlag, CommandRedFlag);
  if (character != undefined) {
    character.purgeOrderIfPresent("directional");
    character.pushOrder("directional");
  }
}

function ClickSeekPortal(screen_x, screen_y) {
  //DebugCall("ClickSeekPortal", [screen_x, screen_y]);
  
  var map_x = ScreenToMapX(Layer, screen_x);
  var map_y = ScreenToMapY(Layer, screen_y);

  var crusher = FindCrusher([map_x, map_y], CommandBlueFlag, CommandRedFlag);
  var portal = FindPortal([map_x, map_y], CommandRedFlag, CommandBlueFlag);
  if (portal == undefined && crusher == undefined) {
    return;
  }
  
  if (portal != undefined && crusher != undefined) {
    var portal_dist2 = portal.dist2(portal, [map_x, map_y]);
    var crusher_dist2 = crusher.dist2(crusher, [map_x, map_y]);
    if (portal_dist2 > crusher_dist2) {
      portal = undefined;
    } else {
      crusher = undefined;
    }
  }
    
  if (crusher != undefined) {
    // push approach.portal order onto this crusher
    crusher.purgeOrderIfPresent("approach.portal");
    crusher.pushOrder("approach.portal")
    //TheBolt = Bolt(crusher, screen_x, ProductBoltColor);
  }
  
  if (portal != undefined) {
    // push goto order onto all opposing crushers
    var order = GoTo(AttractingLocus(portal));
    var roster = portal.team.opposite.upCharacters;
    var count = 0;
    for (var name in roster.members) {
      var character = roster.members[name];
      if (character.isCrusher()) {
        character.purgeOrderIfPresent(order);
        character.pushOrder(order);
        count++;
      }
    }
    if (count > 0) {
      //TheBolt = Bolt(portal, screen_x, ProductBoltColor);
    }
  } 
}

Character.prototype.nearestAble =
function() {
  //DebugCall("Character.nearestAble", [], Quote(this));
  
  var neighbor;
  neighbor = NearestPerson(Blue.roster, this.esCm, neighbor, 1);
  neighbor = NearestPerson(Red.roster, this.esCm, neighbor, 1);
  
  return neighbor;
}

function NearestThawedPerson(people, east_cm, south_cm) {
  //DebugCall("NearestThawedPerson", [people, east_cm, south_cm]);

  var nearest_cm2;
  var nearest_person;
  
  for (var i in people) {
    var person = people[i];
    if (!IsFrozen(person)) {
      var cm2 = PersonCm2(person, east_cm, south_cm);
      if (nearest_cm2 == undefined || nearest_cm2 > cm2) {
        nearest_cm2 = cm2;
        nearest_person = person;
      }
    }
  }

  //DebugLog.write(" NearestThawedPerson() returned " + Quote(nearest_person) + ")");
  return nearest_person;
}

// read-only functions

function OrderArg(order) {
  //DebugCall("OrderArg", [order]);

  if (typeof(order) != "string") {
    Abort("Unexpected order: " + Quote(order));
  }

  var list = order.split(OrderArgSeparator);
  var arg = list[1];
  if (arg == undefined) {
    arg = "";
  }
  
  return arg;
}

function OrderMode(order) {
  //DebugCall("OrderMode", [order]);
  
  if (typeof(order) != "string") {
    Abort("Unexpected order: " + Quote(order));
  }

  var list = order.split(OrderArgSeparator);
  var mode = list[0];
  
  return mode;
}

// create a "go" order
function GoTo(locus) {
  //DebugCall("GoTo", [locus]);

  if (typeof(locus) != "string") {
    Abort("Invalid locus: " + Quote(locus));
  }
  
  var result = "go" + OrderArgSeparator + locus;
  return result;
}