// name.js
// names for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

RequireScript("utilities/random.js");

// bookkeeping data

var NextPersonId = 1;
var NameExists = [];

function NewName(model) {
  // the first character of the name is randomized 
  //  in order to randomize the update order
  
  var name;
  
  switch (model) {
    case "archer":
    case "elf":
    case "knight":
    case "sands":
      name = PickNorseName();
      break;
  }
  
  if (name == undefined || NameExists[name]) {
    name = RandomLetter() + String(NextPersonId++) + "-" + model;
  }

  NameExists[name] = true;

  return name;
}

function IsPerson(name) {
  //DebugCall("IsPerson", [name]);
  
  if (name == undefined || !NameExists[name]) {
    return false
  } else {
    return true;
  }
}

// I derived the list from http://www.vikinganswerlady.com/ONMensNames.shtml
// I anglicized the spellings.
// Dithematic names have been omitted for now. 

NorseGivenNames = [ "Abbe", "Adgils", "Afi", "Ageir", 
"Agi", "Agni", "Aki", "Aldi", "Alf", "Ambi", "Ansvar", 
"Anki", "Ari", "Arni", "Asi", "Ask", "Atti", "Audi", "Auni",
"Baggi", "Bak", "Baldi", "Banki", "Bard", "Barni", 
"Bassi", "Baug", "Beinir", "Benteinn", "Berg", "Bersi",
"Bild", "Biorn", "Birgir", "Bisi", "Blasi", "Blesi",
"Boddi", "Bofi", "Bolli", "Bondi", "Bork", "Bosi", 
"Boti", "Botni", "Bragi", "Bram", "Brand", "Breid", 
"Bresi", "Brisi", "Brodd", "Bruni", "Brunn", "Brusi",   
"Buggi", "Bukk", "Buld", "Dag", "Dalli", "Dudi", 
"Dyri", "Egill", "Eirik", "Eldi", "Erlend", "Eyk", "Faddi", 
"Faksi", "Fari", "Fasti", "Feggi", "Finn", "Fleinn", 
"Floki", "Forkun", "Fot", "Frakki", "Fridi", "Frodi", 
"Fugli", "Fundin", "Fusi", "Galinn", "Galm", "Gamall", 
"Gamli", "Gard", "Gasi", "Gauti", "Gedda", "Geilir", 
"Geirr", "Gellir", "Gest", "Gildi", "Gilli", "Gisi",
"Glam", "Glodi", "Glum", "Gorm", "Grani", "Greip", 
"Grettir", "Grim", "Grip", "Grom", "Grubbi", "Gubbi",
"Gudi", "Gufi", "Gunnarr", "Gunni", "Gusi", "Gutti", 
"Gylfi", "Gyrd", "Hatting", "Hagbard", "Hogni", "Haki", 
"Hakon", "Hak", "Half", "Halli", "Halmi", "Hals", 
"Ham", "Hand", "Harald",   "Hardi", "Hari", "Hatt", 
"Hauk", "Hedinn","Hegg", "Helf", "Helgi", "Hogni", 
"Holfi", "Holm", "Holti", "Hord", "Hoskuld", "Hugi", 
"Humli", "Hund", "Huni", "Ingi", "Jarni", "Jofurr", 
"Jokull", "Juti", "Kafli", "Kalf", "Kambi", "Kari", 
"Karl", "Kaupi", "Ketill", "Kimbi", "Klakk", "Klaufi", 
"Klepp", "Knut", "Korek", "Krak", "Krok", "Krum", 
"Kuggi", "Kuss", "Lafi", "Laki", "Lambi", "Laugi", 
"Leif", "Leik", "Lid", "Lodinn", "Lofi", "Magni", 
"Mak", "Mani", "Mar", "Miki", "Moldi", "Mundi", 
"Nadd", "Nagli", "Nef", "Niall", "Obbi", "Oddi", 
"Ofeig", "Ogurr", "Olaf", "Oli", "Onarr", "Orm", 
"Orri", "Ospak", "Ostark", "Osvald", "Otkell",
"Ottarr", "Radi", "Rafni", "Ragi", "Rangi", "Rani", 
"Ring", "Rorik", "Rolf", "Rut", "Ragni", "Rambi", 
"Rand", "Raum", "Ref", "Rekk", "Reinn", "Riki", 
"Rugga", "Runi", "Saerda", "Sam", "Sandarr", "Saxi", 
"Sebbi", "Serk", "Sibba", "Siggi", "Simbi", "Skagi", 
"Skaldi", "Skalli", "Skapti", "Skari", "Skati", 
"Skuli", "Slagvi", "Smid", "Snaer", "Snari", "Snorri", 
"Solgi", "Solvi", "Sot", "Spaki", "Sparr", "Sporr", 
"Spraki", "Staki", "Starki", "Starr", "Stig", "Stori", 
"Sturla", "Stybbi", "Stygg", "Styrmir", "Surt", "Svan", 
"Svart", "Sverri", "Svipdag", "Taf", "Tann", "Tassi", 
"Tati", "Teit", "Thengill", "Thidrek", "Thialfi", 
"Thord", "Thorir", "Tind", "Tofi", "Toki", "Toli", 
"Torf", "Tosti", "Trygg", "Tubbi", "Tumi", "Tuni", 
"Tyrvi", "Ubbi", "Uffi", "Ugg", "Ulf", "Uni", 
"Unnarr", "Utlagi", "Vadi", "Vaeni", "Vafri", "Vagn", 
"Val", "Vandill", "Vani", "Varinn", "Vedr", "Vidarr", 
"Vifi", "Vigi", "Vili", "Vott" ];

function PickNorseName() {
  //DebugCall("PickNorseName");
  
  var name = ListPick(NorseGivenNames);
  if (NameExists[name]) {
    // Ignore Old Norse case inflection because the
    // spellings are anglicized.
    name += "-son-of-" + ListPick(NorseGivenNames);
  }
    
  return name;
}