// get_scenario.js
// scenario loading UI for Sphere

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
RequireScript("ui/text_line.js");
RequireScript("utilities/scenario.js");

// global variables

NewScenarioOption = " [new scenario]";

// select a scenario and load it

function GetScenario() {
  //DebugCall("GetScenario");
  
  // read startup file
  var auto = OpenFile("auto");
  var load_scenario_flag = auto.read("LoadScenarioFlag", false);
  var scenario_name = auto.read("ScenarioName", "");
  var skip_editing_flag = auto.read("SkipEditingFlag", false);
  var skip_briefing_flag = auto.read("SkipBriefingFlag", false);
  
  while (true) {
    if (!load_scenario_flag) {
      // select scenario from file menu
      scenario_name = PlayerSelectScenario(scenario_name);
      skip_editing_flag = false;
      skip_briefing_flag = false;
    }
  
    if (scenario_name != NewScenarioOption) {
      // load existing scenario
      ActiveScenario.load(scenario_name);
    }
    
    if (EditableScenarioFlag && !skip_editing_flag) {
      var key = ActiveScenario.edit();
      if (key == KEY_ESCAPE) {
        continue; // back at file menu
      }
    }

    if (scenario_name == NewScenarioOption) {
      scenario_name = EnterScenarioName();
      if (scenario_name == undefined) {
        scenario_name = undefined;
        continue; // back at file menu
      }
      CreateEmptyBriefing(scenario_name);
    }
    break; // to save and test
  }
  
  // save new scenario
  ActiveScenario.save(scenario_name);

  auto.write("ScenarioName", scenario_name);
  auto.write("LoadScenarioFlag", false);
  auto.close();
  
  ActiveScenario.apply(PlayerPreferences);
  ActiveScenario.overrides();
  if (skip_briefing_flag) {
    BriefingFlag = false;
  }

  // ready to run the simulator!
}

// get scenario name typed by player
function EnterScenarioName(choice) {
  //DebugCall("EnterScenarioName", [choice]);
  
  Screen.clip();

  var result = "";
  var font = ActiveScenario.font;
  var line_height = font.getHeight();
  
  var head_rect = Screen.overlay(0.3, 0.4, 0.4, 0.06);  
  var result_rect = head_rect.carve("bottom", 0, line_height);

  var bg_color = CreateColor(40, 0, 0);         // dark red
  var text_color = CreateColor(255, 255, 255);  // white

  var head_line = TextLine(head_rect, 
        ActiveScenario.headBackgroundColor, ActiveScenario.headTextColor);
  var result_line = TextLine(result_rect,
        bg_color, text_color);
  
  head_line.setText("Enter name for new scenario:");

  while (true) {
    result_line.setText(result);

    Screen.fill(ActiveScenario.backgroundColor);
    head_line.draw();
    result_line.draw();
    FlipScreen();
    
    var len = result.length;
    var key = GetKey();
    var shift = IsKeyPressed(KEY_SHIFT);
    if (key == KEY_BACKSPACE) {
      if (len > 0) {
        result = result.slice(0, len-1);
      }
    } else if (key == KEY_ENTER) {
       if (len > 0) {
         break;
       }
    } else if (key == KEY_ESCAPE) {
       result = undefined;
       break;
    } else {
      var ks = GetKeyString(key, shift);
      if (ks >= "0" && ks <= "9" || ks == " "
       || ks >= "A" && ks <= "Z"
       || ks >= "a" && ks <= "z") {
        result += ks;
      }
    }
  }

  //DebugLog.write("EnterScenarioName() returns " + Quote(result));
    
  return result;
}


// select a scenario from a menu
function PlayerSelectScenario(default_choice) {
  //DebugCall("PlayerSelectScenario", [default_choice]);
  
  var saved_rects = ActiveWindows;
  ActiveWindows = [];

  // put menu in the middle of the screen  
  var middle = Screen.overlay(0.05, 0.1, 0.6, 0.8);
  var font = ActiveScenario.font;
  var line_height = font.getHeight();
  
  var heading_rect = middle.carve("top", 0, line_height);
  ScenarioSelectHeading = TextLine(heading_rect, 
    ActiveScenario.headBackgroundColor, ActiveScenario.headTextColor, 
    "Select a scenario:", "left");
    
  var menu = new Menu(middle, font);

  var rect = Screen.overlay(0.7, 0.1, 0.25, 0.07);
  ActiveScenario.prefs = new Icon(rect);
  ActiveScenario.prefs.bindAction(EditPrefs, "'Preferences");

  rect = Screen.overlay(0.7, 0.2, 0.25, 0.07);
  ActiveScenario.enter = new Icon(rect);
  ActiveScenario.enter.bindAction(MenuEnter, "'Load scenario");

  rect = Screen.overlay(0.7, 0.3, 0.25, 0.07);
  ActiveScenario.escape = new Icon(rect);
  ActiveScenario.escape.bindAction(MenuEscape, "'Quit [Esc]");
  
  menu.update = ScenarioSelectUpdate;

  var scenario_name = menu.execute(default_choice);
  if (menu.lastKey == KEY_ESCAPE) {
    // dump the global variables
    DumpGlobals("../logs/globals.txt");
    Exit();
  }

  ActiveWindows = saved_rects;
  
  //DebugLog.write(" PlayerSelectScenario() returns " + Quote(scenario_name));
  return scenario_name;
}

function ScenarioSelectUpdate() {
  //DebugCall("ScenarioSelectUpdate");
  
  Screen.clip();
  Screen.fill(ActiveScenario.backgroundColor);
  
  ScenarioSelectHeading.draw();
  ActiveScenario.prefs.draw();
  ActiveScenario.escape.draw();
  ActiveScenario.enter.draw();
  
  var name_list = [ NewScenarioOption ];

  // add the names of all scenario files
  var file_list = GetFileList("save/scenarios");
  for (var i in file_list) {
    var file_name = file_list[i];
    if (file_name.substr(-4) == ActiveScenario.fileSuffix) {
      var scenario_name = file_name.substr(0, file_name.length - 4);
      name_list.push(scenario_name);
    }
  }
    
  // sort the list
  name_list.sort();

  //DebugLog.write("ScenarioSelectUpdate() returns " + Quote(name_list));
  return name_list;
}

function EditPrefs() {
  PlayerPreferences.load();
  var key = PlayerPreferences.edit();
  if (key == KEY_ESCAPE) {
    return;
  }
  PlayerPreferences.save();
}