// obstacle.js
// Obstacle class for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// An Obstacle is an Entity that represents an immovable, neutral object.
// There are three obstacle models defined: {pillar, tree-bare, tree-leafy}.

RequireScript("coords.js");
RequireScript("entities/entity.js");
RequireScript("roster.js");

ObstacleOpacity = PlayerEnum("ObstacleOpacity", 0.7, [0.5, 0.7, 0.9, 1.0]);

Obstacle.prototype = new Entity();
Obstacle.prototype.constructor = Obstacle;

// constructors

function ClickAddPillar(screen_x, screen_y) {
  //DebugCall("ClickAddPillar", [screen_x, screen_y]);

  AddObstacle("pillar", [screen_x, screen_y]);
}

function ClickAddTree(screen_x, screen_y) {
  //DebugCall("ClickAddTree", [screen_x, screen_y]);
  
  AddObstacle("tree-bare", [screen_x, screen_y]);
}

function AddObstacle(model, screen_xy) {
  //DebugCall("AddObstacle", [model, screen_xy]);

  var map_x = ScreenToMapX(ObstacleLayer, screen_xy[0]);
  var map_y = ScreenToMapY(ObstacleLayer, screen_xy[1]);
  var east_cm = MapXToCm(map_x);
  var south_cm = MapYToCm(map_y);

  var obstacle = new Obstacle(model);
  if (obstacle.place([east_cm, south_cm])) {
    //DebugLog.write("aborted " + obstacle.name);
    obstacle.deleteObstacle();
    return false;
  }
  
  return true;
}

function Obstacle(model) {
  if (this instanceof Obstacle == false) {
    return new Obstacle(model);
  }
  //DebugCall("Obstacle", [model]);
  if (model == undefined) {
    return this;
  }
  
  var status = "";
  Entity.apply(this, [model, status]);
  this.changeOpacity(Number(ObstacleOpacity));
  this.setLayer(ObstacleLayer);
  
  // bookkeeping
  AllObstacles.add(this);

  return this;
}

// destructors

function ClickRemoveObstacle(screen_x, screen_y) {
  //DebugCall("ClickRemoveObstacle", [screen_x, screen_y]);
  
  var map_x = ScreenToMapX(Layer, screen_x);
  var map_y = ScreenToMapY(Layer, screen_y);

  var obstacle = AllObstacles.best([map_x, map_y]);
  if (obstacle != undefined) {
    obstacle.deleteObstacle();
  }
}

Obstacle.prototype.deleteObstacle =
function() {
  //DebugCall("DeleteObstacle");

  AllObstacles.remove(this);
  this.deleteEntity();
}

// update

function ToggleObstacleOpacity() {
  //DebugCall("ToggleObstacleOpacity");

  if (ObstacleOpacity >= 0.9) {
    ObstacleOpacity = 0.7;
  } else {
    ObstacleOpacity = 1;
  }
  UpdateObstacleOpacities();
}

function UpdateObstacleOpacities() {
  //DebugCall("UpdateObstacleOpacities");

  for (var name in AllObstacles.members) {
    var obstacle = AllObstacles.members[name];
    obstacle.changeOpacity(ObstacleOpacity);
  }  
}

// read-only functions

Obstacle.prototype.isObstacle =
function() {
  //DebugCall("Obstacle.isObstacle");

  return true;
}