// mobile.js
// Mobile class for battle simulation (Sphere)

/*  Copyright (C) 2009 Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// A Mobile is a TeamEntity (see team_entity.js) that moves.

// A Mobile has the following properties:
//  + maxRangeCm  range of its attack, in centimeters
//  + minCos      cosine of the maximum turn angle for one tick
//  + stepCm      distance it can move in one tick
//  + targetName  person it's attacking
//   + all the properties of a TeamEntity.

RequireScript("entities/team_entity.js");

// constructor

function Mobile(team, model, status, version) {
  if (this instanceof Mobile == false) {
    return new Mobile(team, model, status, version);
  }
  //DebugCall("Mobile", [team, model, status, version]);
  if (team == undefined) {
    return this;
  }
  
  TeamEntity.apply(this, [team, model, status, version]);
}
Mobile.prototype = new TeamEntity();
Mobile.prototype.constructor = Mobile;

// set attack radius
Mobile.prototype.setMaxRangeCm =
function(cm) {
  //DebugCall("Mobile.setMaxRangeCm", [cm]);
  
  if (typeof(cm) != "number" || cm < 0) {
    Abort("Invalid cm: " + Quote(cm));
  }
  
  this.maxRangeCm = cm;
}

// set turn rate
Mobile.prototype.setMinCos =
function(cosine) {
  //DebugCall("Mobile.setMinCos", [cosine]);
  
  if (typeof(cosine) != "number" 
   || cosine < -1
   || cosine > 1) {
    Abort("Invalid cosine: " + Quote(cosine));
  }
  
  this.minCos = cosine;
}

// set movement, in cm per tick
Mobile.prototype.setStepCm =
function(cm) {
  //DebugCall("Mobile.setStepCm", [cm]);
  
  if (typeof(cm) != "number" || cm < 0) {
    Abort("Invalid cm: " + Quote(cm));
  }
  
  this.stepCm = cm;
}

// set target name
Mobile.prototype.setTargetName =
function(name) {
  //DebugCall("Mobile.setTargetName", [name], Quote(this));
  
  if (typeof(name) != "string") {
    Abort("Invalid name: " + Quote(name));
  }
  
  this.targetName = name;
}