// banner.js
// Banner class for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

RequireScript("entities/team_entity.js");

BannerModel = PlayerEnum("BannerModel", "gonfalon", [ "gonfalon", "none" ]);

ReflistDelimiter = " ";

// constructors

function AddBanner(references, map_x, map_y) {
  //DebugCall("AddBanner", [reflist, map_x, map_y]);

  var east_cm = MapXToCm(map_x);
  var south_cm = MapYToCm(map_y);
  
  var banner = new Banner(references);
  if (banner.place([east_cm, south_cm])) {
    return undefined;
  }
  return banner;
}

function Banner(references) {
  if (this instanceof Banner == false) {
    return new Banner(references);
  }
  //DebugCall("Banner", [references]);
  if (references == undefined) {
    return this;
  }
  
  if (references instanceof Roster == false) {
    Abort("Invalid references: " + Quote(references));
  }
  
  var first_ref = references.getFirst();
  var team = first_ref.team;
  var model = BannerModel;
  var status = "wav";
  
  TeamEntity.apply(this, [team, model, status]);
  
  this.priority = "2"; // always low priority
  this.setLayer(ObstacleLayer); 
  this.setFrameDuration("wav", 0, 0.2*TicksPerSecond);
  this.setFrameDuration("wav", 1, 0.2*TicksPerSecond);
  this.setFrameDuration("wav", 2, 0.2*TicksPerSecond);
  this.setFrameDuration("wav", 3, 0.2*TicksPerSecond);
  this.setFrameDuration("wav", 4, 0.2*TicksPerSecond);
  this.references = references;
  
  // bookkeeping
  AllBanners.add(this);

  return this;
}
Banner.prototype = new TeamEntity();
Banner.prototype.constructor = Banner;

// destructor

Banner.prototype.deleteBanner =
function() {
  //DebugCall("Banner.deleteBanner", [], Quote(this));

  AllBanners.remove(this);
  this.deleteEntity();
}

function ClickRemoveBanner(screen_x, screen_y) {
  //DebugCall("ClickRemoveBanner", [screen_x, screen_y]);

  var map_x = ScreenToMapX(Layer, screen_x);
  var map_y = ScreenToMapY(Layer, screen_y);

  var banner = AllBanners.best([map_x, map_y]);
  if (banner != undefined) {
    banner.deleteBanner();
  }
}

// update functions

Banner.prototype.update =
function() {
  //DebugCall("Banner.update", [], Quote(this));
  
  var tick_count = this.tickCount;
  tick_count--;
  if (tick_count > 0) {
    this.setTickCount(tick_count);
  } else {
    var frame = this.frame;
    this.changeFrame(frame + 1);
  }
}

Banner.prototype.removeReference =
function(character) {
  //DebugCall("Banner.removeReference", [character], Quote(this));
  
  this.references.remove(character);
  
  if (this.references.isEmpty()) {
    this.deleteBanner();
  }  
}

// read-only functions

Banner.prototype.getDirectionName =
function() {
  return this.priority;
}

Banner.prototype.isBanner =
function() {
  //DebugCall("Banner.isBanner");

  return true;
}