// briefing.js
// briefings for battle simulation (Sphere)

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
RequireScript("ui/mouse.js");
RequireScript("ui/text_box.js");

// configuration

BriefingFlag = PlayerFlag("Briefing", false);

// style

BriefingStyle = LoadWindowStyle("rounded12.rws");
BriefingStyle.thickness = 12; // pixels

// colors

BriefingBackgroundColor = CreateColor(160, 120, 100);  // light brown
BriefingTextColor = CreateColor(0, 30, 0);  // greenish black

BriefingYOffset = 0;

function GiveBriefing() {
  //DebugCall("GiveBriefing");

  // disable active windows  
  var save_windows = ActiveWindows;
  ActiveWindows = [];

  // read briefing text from raw file
  var path = "briefings/" + ActiveScenario.name + ".txt";
  var file = OpenRawFile(path, false);
  var buffer_size = 16384;  // bytes
  var text = "";
  do {
    var buffer = file.read(buffer_size);
    text += CreateStringFromByteArray(buffer);
  } while (buffer.length == buffer_size);
  file.close();

  // lay out the box and controls
  var rect = Screen.trim(Screen.width/30);

  var icon_spacing = rect.height/50;
  BriefingControls = new IconGrid(rect, "right", -6, 
    undefined, undefined, undefined, icon_spacing);
  BriefingControls.icons[0].bindAction(BriefingTop, "top", 
    "BriefingBox.offset < 0");
  BriefingControls.icons[1].bindAction(BriefingUp, "up", 
    "BriefingBox.offset < 0");
  BriefingControls.icons[2].bindAction(BriefingDown, "down", 
    "BriefingBox.offset > BriefingBottomOffset");
  BriefingControls.icons[3].bindAction(BriefingBottom, "bottom", 
    "BriefingBox.offset > BriefingBottomOffset");
  BriefingControls.icons[5].bindAction(BriefingDismiss, "dismiss");
  
  rect = rect.trim(BriefingStyle.thickness);
  var briefing_window = Window(rect, BriefingBackgroundColor, BriefingStyle);
  briefing_window.click = ClickDragBriefing;
  ActiveWindows.push(briefing_window);
  
  var font = ScaledFont(briefing_window.height/30);
  BriefingBox = TextBox(briefing_window, BriefingTextColor, text, font, "top");
  BriefingBottomOffset = BriefingBox.height - BriefingBox.textHeight;

  BriefingDismissed = false;
  BriefingBaseY = undefined;
  
  while (IsAnyKeyPressed()) {
    BriefingRedraw();
  }
  
  while (!BriefingDismissed) {
    BriefingRedraw();

    if (IsAnyKeyPressed()) {    
      if (IsKeyPressed(KEY_ESCAPE) || IsKeyPressed(KEY_ENTER)) {
        BriefingDismiss();
      } else if (IsKeyPressed(KEY_HOME)) {
        BriefingTop();
      } else if (IsKeyPressed(KEY_PAGEUP)) {
        BriefingUp();
      } else if (IsKeyPressed(KEY_PAGEDOWN)) {
        BriefingDown();
      } else if (IsKeyPressed(KEY_END)) {
        BriefingBottom();
      }
      
      // blank the window and wait for the player to release the key
      Screen.fill(BriefingControls.backgroundColor);
      FlipScreen();
      while (IsAnyKeyPressed());
    }
  }
    
  ActiveWindows = save_windows;
}

function BriefingRedraw() {
  //DebugCall("BriefingRedraw");
  
  Screen.fill(BriefingControls.backgroundColor);
  BriefingControls.draw();

  if (BriefingBaseY != undefined) {
    var offset = GetMouseY() - BriefingBaseY;
    BriefingBox.setOffset(offset);
  }   
  BriefingBox.draw();
  UpdateMouse(DefaultPointerImage);

  FlipScreen();
}

function ClickDragBriefing(button, screen_x, screen_y) {
  //DebugCall("ClickDragBriefing", [button, screen_x, screen_y]);

  BriefingBaseY = screen_y - BriefingBox.offset;
  EndClickAction = "BriefingBaseY = undefined";
}

function BriefingDismiss() {
  BriefingDismissed = true;
}

function BriefingTop() {
  BriefingBox.moveToTop();
}

function BriefingUp() {
  BriefingBox.moveDown(-BriefingBox.height/4);
}

function BriefingDown() {
  BriefingBox.moveDown(BriefingBox.height/4);
}

function BriefingBottom() {
  BriefingBox.moveToBottom();
}


function CreateEmptyBriefing(name) {
  //DebugCall("CreateEmptyBriefing". [name]);
  
  var message = "This scenario doesn't have a briefing yet.";

  var path = "briefings/" + name + ".txt";
  var file = OpenRawFile(path, true);
  var buffer = CreateByteArrayFromString(message);
  file.write(buffer);
  file.close();
}