// bind.js
// icon bindings for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
// scenario parameters that shape the user-interface

var DebugFlag = Flag("Debug", false);
var GodPowersFlag = Flag("GodPowers", false);

RequireScript("draw.js");
RequireScript("entities/character.js");
RequireScript("entities/obstacle.js");
RequireScript("overlays/bolt.js");
RequireScript("overlays/description.js");
RequireScript("team.js");
RequireScript("ui/icon_grid.js");

Blue.gridColor = CreateColor(0, 0, 128);      // dark blue
Red.gridColor = CreateColor(128, 0, 0);       // dark red


// bind GUI icons
function BindGameIcons() {
  //DebugCall("BindGameIcons");
  var gui;
  
  gui = SimGrid;
  ResumeIcon =
    gui.icons[0].bindToggle("PauseFlag", "pause", "resume");
    gui.icons[1].bindToggle("SoundFlag", "sound");
  LeftClickIcon = 
    gui.icons[2].bindMode(ClickDescribe, "describe");   
  RightClickIcon = 
    gui.icons[3].bindMode(ClickCenter, "center");
    gui.icons[4].bindAction(ZoomIn, "zoom-in", 
      "ResolutionCm > 1.5");
    gui.icons[5].bindAction(ZoomOut, "zoom-out", 
      "ResolutionCm < 4");
    gui.icons[6].bindAction(ToggleObstacleOpacity, "obstacles", 
      "AllObstacles.count() > 0");
    gui.icons[7].bindToggle("TargetZonesFlag", "tzones");
    gui.icons[8].bindAction(GiveBriefing, "briefing", "PauseFlag");
    gui.icons[9].bindAction(QuitToRestart, "restart", "PauseFlag");
    gui.icons[10].bindAction(QuitToMenu, "menu", "PauseFlag");
    gui.icons[11].bindAction(Quit, "quit", "PauseFlag");
    
  gui = CommandGrid;
  if (gui != undefined) {
    gui.icons[0].bindAction(ClickSelectAll, "select-all");
    gui.icons[1].bindMode(ClickSelectArea, "select-area");
    gui.icons[2].bindMode(ClickDirect, "direct");
    gui.icons[3].bindMode(ClickGoto, "goto-g");
    gui.icons[4].bindMode(ClickRemoveBanner, "remove-g");
    gui.icons[5].bindMode(ClickSeekPortal, "seek-portal");
    if (CommandBlueFlag && Blue.portals > 0
     || CommandRedFlag && Red.portals > 0) {
      gui.icons[6].bindMode(ClickChangeProductArcher, "make-arch");
      gui.icons[7].bindMode(ClickChangeProductSands, "make-sands");
      gui.icons[8].bindMode(ClickChangeProductAlternate, "alternate");
    }
  }

  gui = DebugGrid;
  if (gui != undefined) {
    gui.icons[0].bindToggle("ObstructionBasesFlag", "draw-base");
    gui.icons[1].bindToggle("BoxesFlag", "draw-box");
    gui.icons[2].bindMode(ClickDebugDescribe, "describe");
    gui.icons[3].bindToggle("RealClockFlag", "real-clock");
    gui.icons[4].bindToggle("ScoreboardFlag", "draw-score");
    gui.icons[5].bindToggle("SimClockFlag", "sim-clock");
    gui.icons[6].bindToggle("TimeClockFlag", "time-of-day");
    gui.icons[7].bindToggle("EyeFlag", "eye");
    gui.icons[8].bindToggle("SingleStepFlag", "step");
    //gui.icons[].bindToggle("FootprintsFlag", "footprints");
  }
  
  gui = GodPowersGrid;
  if (gui != undefined) {
    gui.icons[0].bindMode(ClickBoost, "boost");
    gui.icons[1].bindMode(ClickDefect, "defect");
    gui.icons[2].bindMode(ClickDisable, "disable");
    gui.icons[3].bindMode(ClickFreeze, "freeze");
    gui.icons[4].bindMode(ClickAddTree, "add-tree");
    gui.icons[5].bindMode(ClickAddPillar, "add-pillar");
    gui.icons[6].bindMode(ClickRemoveObstacle, "remove-o");
  }
  
}

function CreateGrids(rect) {
  //DebugCall(CreateGrids, [rect]);
  
  SimGrid = new IconGrid(rect, "bottom", 12);

  DebugGrid = undefined;
  CommandGrid = undefined;
  GodPowersGrid = undefined;
  
  if (DebugFlag) {
    DebugGrid = new IconGrid(rect, "right", 9);
  }

  if (CommandBlueFlag || CommandRedFlag) {
    var grid_color;
    if (CommandBlueFlag && !CommandRedFlag) {
      grid_color = Blue.gridColor;
    } else if (CommandRedFlag && !CommandBlueFlag) {
      grid_color = Red.gridColor;
    }
    
    if (GodPowersFlag) {
      GodPowersGrid = new IconGrid(rect, "right", 7, grid_color);
    }
    CommandGrid = new IconGrid(rect, "bottom", 9, grid_color);
  }  
}

function DrawGUI() {
  //DebugCall("DrawGUI");

  SimGrid.draw();

  if (CommandGrid != undefined) {
    CommandGrid.draw();
  }
  if (GodPowersGrid != undefined) {
    GodPowersGrid.draw();
  }
  if (DebugGrid != undefined) {
    DebugGrid.draw();
  }
  
  //DebugCall(" leaving DrawGUI");
}