////////////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------------//
//CODE BY: J. MATTHEW VANDEVANDER                                                         //
//Released as open source, you can steal or do whatever you want with this, I'd like to   //
//see what you can use if for though. :)                                                  //
//----------------------------------------------------------------------------------------//
////////////////////////////////////////////////////////////////////////////////////////////


RequireScript("roundto.js")
function slider(x,y,min,max,title,variable,w,h)
{
  if(!this.parent)
  {
    this.parent=screen
  }
  container.call(this)
  this.title = title;
  this.screenx=x;
  this.screeny=y;
  this.x=this.screenx+this.parent.activearea.x
  if(this.screeny+this.parent.activearea.y-systemfont_white.getHeight()<this.parent.activearea.y)
  {
    this.y=(this.screeny+this.parent.activearea.y)+systemfont_white.getHeight();
  }
  else
  {
    this.y=this.screeny+this.parent.activearea.y;
  }
  if(w)
  {
    this.w=w;
  }
  else
  {
    this.w=systemfont_white.getStringWidth(title)+50;
  }
  if(h)
  {
    this.h=h;
  }
  else
  {
    this.h=20;;
  }
  this.min=min
  this.max=max
  this.variable=variable
  this.value=eval(this.variable)
  this.edgecolor = white;
  this.fillcolor = gray;
  this.activecolor = red;
  this.overcolor = white;
  this.restcolor = CreateColor(200,200,200,255);
  this.ismouseover=false;
  this.active=false;
  this.sliderhandlewidth=10
  this.scalepercentage=(this.w-4-this.sliderhandlewidth)/(this.max-this.min)
  this.sliderposition=(this.value-this.min)*this.scalepercentage
  this.pixelspastslider=0
}

slider.prototype = new container();
slider.prototype.update = function()
{
  with (this)
  {
    x=screenx+parent.activearea.x
    if(screeny+parent.activearea.y-systemfont_white.getHeight()<parent.activearea.y)
    {
      y=(screeny+parent.activearea.y)+systemfont_white.getHeight();
    }
    else
    {
      y=screeny+parent.activearea.y;
    }
    if(screenx+w<parent.activearea.w&&screeny+h<parent.activearea.h)
    {
      if(parent.ismouseoveranyobject||!parent.focus)
      {
        ismouseover=false;active=false;
      }
      else
      {
        value=eval(variable)
        checkmouseover();
        if(mouse.l&&!mouse.lheld&&ismouseover) active=true;
        if(active)
        {
          pixelspastslider=mouse.x-x
          value = min+pixelspastslider/scalepercentage
        }
        if(!mouse.l) active=false;
        if(value>max) value=max;
        if(value<min) value=min;
        eval(variable+"=value;")
      }
    }
  }
}

slider.prototype.draw = function()
{
  with (this)
  {
    if(screenx+w<parent.activearea.w&&screeny+h<parent.activearea.h)
    {
      sliderposition=(value-min)*scalepercentage
      Rectangle(x,y,w,h,edgecolor)
      Rectangle(x+2,y+2,w-4,h-4,fillcolor)
      if(active)
      {
        Rectangle(x+2+sliderposition,y+2,sliderhandlewidth,h-4,activecolor);
      }
      if(ismouseover||active)
      {
        Rectangle(x+4+sliderposition,y+4,sliderhandlewidth-4,h-8,overcolor);
      }
      else
      {
        Rectangle(x+4+sliderposition,y+4,sliderhandlewidth-4,h-8,restcolor);
      }
      text(x,y-systemfont_white.getHeight(),title)
      text(x+w-systemfont_white.getStringWidth(roundto(this.value,2)),y-systemfont_white.getHeight(),roundto(this.value,2))
    }
    else
    {
      text(x,y,'ERROR: Slider: "'+title+'" goes outside of Window: "'+parent.title+'" bounds.\nIn order to fix this problem, resize the window or move/resize the slider.')
    }
  }
}

