////////////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------------//
//This file shows how to use the SphereWin environment to create some windows with buttons//
//It doesn't really 'do' anything, per se, as it's not a full application or 'OS', but it //
//shows you how to use my SphereWin functions                                             //
//----------------------------------------------------------------------------------------//
//CODE BY: J. MATTHEW VANDEVANDER                                                         //
//Released as open source, you can steal or do whatever you want with this, I'd like to   //
//see what you can use if for though. :)                                                  //
//----------------------------------------------------------------------------------------//
////////////////////////////////////////////////////////////////////////////////////////////


RequireScript("SphereWin.js") //To actually use the SphereWin environment, this is all we need to include
RequireScript("random.js")
RequireScript("delay.js")
InitializeSphereWin();
function extrawindow() //if you want to create multiple instances of an "application", then put the creation of the window into an function.
{
  exwindow = new window(random(1,screen.w-100),random(1,screen.h-100),random(150,300),random(65,300),"Window "+(screen.windows.length+1));
  exbutton = new button(12,12,"I am a Button!",'Abort("You Clicked Me, Fool!");')
  exbutton2 = new button(12,42,"Add Window",'extrawindow();')
  exwindow.add(exbutton)
  exwindow.add(exbutton2)
  AddWindow(exwindow,true)
}

    //We create some window objects here, so we can work with something
window1 = new window(200,200,300,200,"Window 1")
window2 = new window(220,180,300,200,"Window 2")
window3 = new window(240,160,300,200,"Window 3")
window4 = new window(260,140,300,200,"Window 4")
    //we also create a button and a slider object to work with
button1 = new button(12,12,"Toggle All Shadow Effects",'ToggleSphereWinShadows();')
slider1 = new slider(12,0,0,255,"Background Brightness",'screen.brightness')
    //checkbox objects must have a variable which they toggle in the main program
    //so we set up some variables for the checkboxes here, they don't do anything
    //other than just allow the checkboxes to work, but if you wanted to,
    //you could check elsewhere in your program for the status of these variables,
    //making them actually do something.
var checkbox1toggle=true;
var checkbox2toggle=true;
var checkbox3toggle=false;
    //create some checkbox objects
checkbox1 = new checkbox(12,12,"Toggle Me!","checkbox1toggle");
checkbox2 = new checkbox(12,28,"Toggle Me 2!","checkbox2toggle");
checkbox3 = new checkbox(12,12,"Toggle Me 3!","checkbox3toggle");
    //now we add our buttons/sliders/checkboxes to the window objects we created earlier
window1.add(button1);
window2.add(slider1);
window3.add(checkbox1);
window3.add(checkbox2);
window4.add(checkbox3);
    //then we finally add the windows to the screen
AddWindow(window1);
AddWindow(window2);
AddWindow(window3);
AddWindow(window4);
  //you can also add buttons, sliders, and checkboxes to the screen itself
  //as well as create them as you're adding them. (i.e. you don't have to
  //explicitly declare a button/slider/checkbox before you add it, you can
  //just make it when you add it.
AddtoScreen(new button(0,0,"Exit",'Exit();'))
AddtoScreen(new button(5,screen.h-28,"Add Window",'extrawindow();'));
AddtoScreen(new button(5,screen.h-28,"Add Window",'extrawindow();'));
AddtoScreen(new button(100,screen.h-28,"Toggle All Shadow Effects",'ToggleSphereWinShadows();'))
AddtoScreen(new slider(300,screen.h-28,0,255,"Background Brightness",'screen.brightness',255))
  //this is our main function
function game()
{
  while(!IsKeyPressed(KEY_ESCAPE))  //THIS IS ALL THE MAIN LOOP REQUIRES
  {
    UpdateSphereWin(); //Updates the SphereWin environment
    DrawSphereWin(); //Draws all windows/buttons/sliders/checkboxes
    FlipScreen(); //Flips the backbuffer onto the screen
  }
}

