// New Menu, by Feek.

function Menu(x,y,w,h)
{
	this.items = new Array();
	this.name = "";
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
	
	this.currentItem = 0;
}

Menu.prototype.addItem = function(Name,returnto, color, highlight)
{
	if (color == undefined)
	{
		color = white;
	}
	if (highlight == undefined)
	{
		highlight = red;
	}
	var item = new Object;
	item.name = Name;
	item.highlight = highlight;
	item.returnto = returnto;
	item.color = color;
	this.items[this.items.length] = item;
}

Menu.prototype.returnCurrentItem = function()
{
	return this.currentItem;
}

Menu.prototype.draw = function()
{
	Delay(250);
	var screen = GrabImage(0,0,sw,sh);
	while(!IsKeyPressed(KEY_ESCAPE))
	{
		if (IsMapEngineRunning() == true)
		{
			RenderMap();
		}
		else
		{
			screen.blit(0,0);
		}
		if (this.h == undefined)
		{
			
			this.h = this.items.length*font.getHeight();
		}
		font.setColorMask(white);
		font.drawText(this.x + (this.w/2)-(font.getStringWidth(this.name)/2),this.y-24,this.name);
		window.setColorMask(white);
		window.drawWindow(this.x,this.y,this.w,this.h);
		window.setColorMask(CreateColor(0,0,125,128));
		window.drawWindow(this.x+3,(this.y+3)+font.getHeight()*this.currentItem,this.w-6,font.getHeight()-6);
				
		for(var i = 0; i < this.items.length; ++i)
		{
			if (i != this.currentItem)
			{
				font.setColorMask(this.items[i].color);
			}
			if (i == this.currentItem)
			{
				font.setColorMask(this.items[i].highlight);
			}
			font.drawText(this.x+(this.w/2)-(font.getStringWidth(this.items[i].name)/2),this.y+i*font.getHeight(),this.items[i].name);
		}
		FlipScreen();
		while(AreKeysLeft())
		{
			PlaySound(slide);
			switch(GetKey())
			{
				case KEY_LEFT:
				case KEY_UP:
					if (this.currentItem != -1)
					{
						this.currentItem--;
					}
					if (this.currentItem == -1)
					{
						this.currentItem = this.items.length-1;
					}
				break;
				case KEY_RIGHT:
				case KEY_DOWN:
					if (this.currentItem != this.items.length)
					{
						this.currentItem++;
					}
					if (this.currentItem == this.items.length)
					{
						this.currentItem = 0;
					}
				break;
				case KEY_ENTER:
					Delay(125);
					if (this.items[this.currentItem].highlight != gray)
					{
						this.items[this.currentItem].returnto();
						return;
					}
				break;
			}
		}
	}
}