// Main script by FEEK!

RequireScript("Fade.js");
RequireScript("Cinematics.js");
RequireScript("Game.js");
RequireScript("audio.js");
RequireScript("Menu.js");

function Loader()
{
	var Loader = LoadImage("Loading.png");
	Loader.blit(0,0);
	FlipScreen();
	north = COMMAND_MOVE_NORTH;
	face_north = COMMAND_FACE_NORTH;
	south = COMMAND_MOVE_SOUTH;
	face_south = COMMAND_FACE_SOUTH;
	east = COMMAND_MOVE_EAST;
	face_east = COMMAND_FACE_EAST;
	west = COMMAND_MOVE_WEST;
	face_west = COMMAND_FACE_WEST;
	red = CreateColor(125,0,0);
	green = CreateColor(0,125,0);
	yellow = CreateColor(125,125,0);
	white = CreateColor(255,255,255);
	gray = CreateColor(125,125,125);
	black = CreateColor(255,255,255);
	orange = CreateColor(255,150,0);
	brown = CreateColor(100,60,25);
	font = LoadFont("font.rfn");
	window = LoadWindowStyle("window.rws");
	difficulty = "Easy";
	bg = LoadImage("Title.png");
	JBellRock = LoadSound("jbelrock.mp3",true);
	JingleBells = LoadSound("jingbell.mp3",true);
	Rudolf = LoadSound("rudolf.mp3",true);
	SantaToTown = LoadSound("to_town.mp3",true);
	ChristmasTree = LoadSound("xmastree.mp3",true);
	WishChristmas = LoadSound("wewishu.mp3",true);
	slide = LoadSound("Slide.wav",false);
	Music_List = [JBellRock,JingleBells,SantaToTown,ChristmasTree,WishChristmas];
	nextsong = 0;
	
	SetEasy = function () {difficulty = "Easy"; game_menu();}
	SetNormal = function() {difficulty = "Normal"; game_menu();}
	SetHard = function() {difficulty = "Hard"; game_menu();}
	SetVeryHard = function() {difficulty = "Very Hard"; game_menu();}
	SetInsane = function() {difficulty = "Insane"; game_menu();}
	
	nothing = function() {}
	
	diff_menu = new Menu(170,80,90,65)
	diff_menu.addItem("Easy",SetEasy,white,green);
	diff_menu.addItem("Normal",SetNormal,white,yellow);
	diff_menu.addItem("Hard",SetHard,gray,gray);
	diff_menu.addItem("Very Hard",SetVeryHard,gray,gray);
	diff_menu.addItem("Insane",SetInsane,gray,gray);
	diff_menu.addItem("Back",game_menu);

	SantaHA = false;
	RTheRnR = false;
	MusicPlayer = false;
	GodMode = false;
	TGM = false
	
	LoadData();
	
	unlock_menu = new Menu(170,80,130,55);
	unlock_menu.addItem("Santa Cinematic",SantaC,gray,gray);
	unlock_menu.addItem("Rudolf Cinematic",RudolfC,gray,gray);
	unlock_menu.addItem("Music Player",MPlayer,gray,gray);
	unlock_menu.addItem("God Mode!",ToggleGM,gray,gray);
	unlock_menu.addItem("Back",game_menu);
	
	main_menu = new Menu(170,80,90,45);
	main_menu.addItem("Play",gamestart);
	main_menu.addItem("Difficulty",difficulty_menu);
	main_menu.addItem("Unlockables",Unlockables);
	main_menu.addItem("Quit",Exit);
	
	music_menu = new Menu(160,80,140,75);
	JBellRPlay = function() {ChangeMusic(JBellRock,true);MPlayer();}
	music_menu.addItem("Jingle Bell Rock",JBellRPlay);
	JBellsPlay = function() {ChangeMusic(JingleBells,true);MPlayer();}
	music_menu.addItem("Jinglebells",JBellsPlay);
	RudolfPlay = function() {ChangeMusic(Rudolf,true);MPlayer();}
	music_menu.addItem("Rudolf the...",RudolfPlay);
	SantaPlay = function() {ChangeMusic(SantaToTown,true);MPlayer();}
	music_menu.addItem("Santa is...",SantaPlay);
	ChristmasPlay = function() {ChangeMusic(ChristmasTree,true);MPlayer();}
	music_menu.addItem("Oh Christmas Tree",ChristmasPlay);
	WishPlay = function() {ChangeMusic(WishChristmas,true);MPlayer();}
	music_menu.addItem("We Wish You A...",WishPlay);
	music_menu.addItem("Back",game_menu);
	
	Unlock();
	
	InGameMenu = new Menu(120,104,80,24);
	InGameMenu.addItem("Return",nothing);
	InGameMenu.addItem("Exit",RestartGame);
	
	Loader.blit(0,0);
	FadeOut(1020);
}

function game()
{
	Loader();
	ChangeMusic(JingleBells,true);
	bg.blit(0,0);
	FadeIn(1020);
	game_menu();
}

function game_menu()
{
	bg.blit(0,0);
	main_menu.draw();
}

function options_menu()
{
	bg.blit(0,0);
	opti_menu.draw();
}

function difficulty_menu()
{
	bg.blit(0,0);
	diff_menu.draw();
}

function Unlockables()
{
	bg.blit(0,0);
	unlock_menu.draw();
}

function gamestart()
{
	with (Audio) {Music.stop();}
	if (difficulty == "Easy" || difficulty == "Normal")
	{
		MapEngine("WorkshopEasy.rmp",60);
	}
	if (difficulty == "Hard" || difficulty == "Very Hard")
	{
		MapEngine("WorkshopHard.rmp",60);
	}
	if (difficulty == "Insane")
	{
		MapEngine("WorkshopInsane.rmp",60);
	}
}

function Delay(milliseconds)
{
  var start = GetTime();
  while (start + milliseconds > GetTime()) {
  }
}

function Opening()
{
	RenderMap();
	ChangeMusic(Music_List[nextsong]);
	with (Audio)
	{
		Music.setVolume(50);
	}
	FadeIn(510);
	Move("santa",south,7);
	WaitForPerson("santa");
	Face("santa",face_east);
	WaitForPerson("santa");
	Move("santa",east,1);
	WaitForPerson("santa");
	DispMsg("santa",red,"Wake up pointy-ears!");
	SetPersonDirection("helper","awake");
	Delay(250);
	DispMsg("helper",green,"W-what? Oh! Sorry sir...");
	Delay(250);
	DispMsg("santa",red,"I need you to control this machine!");
	Delay(250);
	DispMsg("santa",red,"Your task is to sort out the good...");
	Delay(250);
	DispMsg("santa",red,"...and the bad presents.");
	Delay(250);
	if (difficulty == "Easy")
	{
		DispMsg("santa",red,"5 strikes and then you're out!");
	}
	if (difficulty == "Normal")
	{
		DispMsg("santa",red,"5 strikes and then you're out!");
	}
	if (difficulty == "Hard")
	{
		DispMsg("santa",red,"4 strikes and then you're out!");
	}
	if (difficulty == "VeryHard")
	{
		DispMsg("santa",red,"4 strikes and then you're out!");
	}
	if (difficulty == "Insane")
	{
		DispMsg("santa",red,"3 strikes and then you're out!");
	}
	Delay(250);
	DispMsg("santa",red,"It's okay if you remove a good item.");
	Delay(250)
	DispMsg("santa",red,"I'll just deduce 1 point.");
	Delay(250)
	DispMsg("santa",red,"But if you don't remove a bad item...");
	Delay(250);
	DispMsg("santa",red,"...Then your head is on the line!");
	Delay(250)
	DispMsg("santa",red,"It should be an easy task, and if you fail...");
	Delay(250)
	DispMsg("santa",red,"...then you're kicked outta here! Now move it!");
	Move("santa",west,1);
	WaitForPerson("santa");
	Move("santa",north,7);
	WaitForPerson("santa");
	Delay(250);
	DestroyPerson("santa");
	DispMsg("helper",green,"O-oh boy! What did I get myself into!");
	MusicFadeIn(2040);
	SetRenderScript('ScoreBoard()');
	SetUpdateScript('Conveyor()');
}

function WaitForPerson(who)
{
	var time = GetTime();
	SetFrameRate(GetMapEngineFrameRate());
	while (!IsCommandQueueEmpty(who))
	{ 
		UpdateMapEngine();//change instances 
		RenderMap(); //render the map 
		FlipScreen(); //display the map on screen 
	} 
}
function Wait(msecs)
{
	var time = GetTime();
	SetFrameRate(GetMapEngineFrameRate());
	while (time + msecs > GetTime())
	{ 
		UpdateMapEngine();//change instances 
		RenderMap(); //render the map 
		FlipScreen(); //display the map on screen 
	} 
}

function DispMsg(who,color,msg)
{
	var x = GetPersonX(who);
	var y = GetPersonY(who);
	while (!IsKeyPressed(KEY_ENTER))
	{
		UpdateMapEngine();
		RenderMap();
		window.setColorMask(color);
		window.drawWindow(x-56,y-80,112,48);
		font.setColorMask(color);
		font.drawTextBox(x-56,y-80,112,48,0,msg);
		FlipScreen()
	}
}

function SaveData()
{
	var thisfile = OpenFile("../game.sgm");
	thisfile.write("Santa", SantaHA);
	thisfile.write("Rudolf", RTheRnR);
	thisfile.write("MusicPlayer", MusicPlayer);
	thisfile.write("GodMode", GodMode);
	thisfile.flush();
	thisfile.close();
}

function LoadData()
{
	var thisfile = OpenFile("../game.sgm");
	SantaHA = thisfile.read("Santa", false);
	RTheRnR = thisfile.read("Rudolf", false);
	MusicPlayer = thisfile.read("MusicPlayer", false);
	GodMode = thisfile.read("GodMode", false);
	thisfile.close();
}

function Unlock()
{
	if (SantaHA == true)
	{
		unlock_menu.items[0].color = white;
		unlock_menu.items[0].highlight = red;
		diff_menu.items[2].color = white;
		diff_menu.items[2].highlight = orange;
	}
	if (RTheRnR == true)
	{
		unlock_menu.items[1].color = white;
		unlock_menu.items[1].highlight = red;
		diff_menu.items[4].color = white;
		diff_menu.items[4].highlight = black;
	}
	if (MusicPlayer == true)
	{
		unlock_menu.items[2].color = white;
		unlock_menu.items[2].highlight = red;
		diff_menu.items[3].color = white;
		diff_menu.items[3].highlight = red;
	}
	if (GodMode == true)
	{
		unlock_menu.items[3].color = white;
		unlock_menu.items[3].highlight = red;
	}
}

function SantaC()
{
	MapEngine("WorkshopSanta.rmp",60);
}

function RudolfC()
{
	MapEngine("Rudolf.rmp",60);
}

function MPlayer()
{
	bg.blit(0,0);
	music_menu.draw();
}

function ToggleGM()
{
	TGM = true;
	game_menu();
}