// Fade Scripts

function FadeOut(miliseconds)
{
	var image = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
	var color = CreateColor(0,0,0);
	var time = GetTime();
	while (GetTime() - time < miliseconds)
	{
		color.alpha = (GetTime() - time) * 255 / miliseconds;
		image.blit(0, 0);
		ApplyColorMask(color);
		FlipScreen();
	}
	color.alpha = 255;
	image.blit(0, 0);
	ApplyColorMask(color);
	FlipScreen();
	image.blit(0, 0);
}

function FadeIn(miliseconds)
{
	var image = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
	var color = CreateColor(0,0,0);
	var time = GetTime();
	while (GetTime() - time < miliseconds)
	{
		color.alpha = 255 - (GetTime() - time) * 255 / miliseconds;
		image.blit(0, 0);
		ApplyColorMask(color);
		FlipScreen();
	}
	color.alpha = 0;
	image.blit(0, 0);
	ApplyColorMask(color);
	FlipScreen();
	image.blit(0, 0);
}

function MusicFadeIn(miliseconds,volume)
{
	if (volume == undefined)
	{
		volume = 255;
	}
	with (Audio) // Yep. Make sure this is the object.
	{
		var vol = Music.getVolume();
		var time = GetTime();
		while (GetTime() - time < miliseconds)
		{
			if (IsMapEngineRunning() == true)
			{
				UpdateMapEngine();
				RenderMap();
				FlipScreen();
			}
			if (Music.getVolume() <= 255) // just so the volume doesn't equal 355 or 280...etc.
			{
				Music.setVolume(vol + (GetTime() - time) * volume / miliseconds);
			}
		}
	}
}

function MusicFadeOut(miliseconds,volume) // volume is to dynamically lower the volume,
{																					// instead of lowering it to 0, but to a value.
	if (volume == undefined)
	{
		volume = 255;
	}
	with (Audio) // I made this object for this purpose, there is a similar system script too...
	{
		var time = GetTime();
		while (GetTime() - time < miliseconds)
		{
			if (IsMapEngineRunning() == true)
			{
				UpdateMapEngine();
				RenderMap();
				FlipScreen();
			}
			Music.setVolume(255 - (GetTime() - time) * volume / miliseconds);
		}
	}
}