// cinematics

function Move(name, direction, tiles)
{
	face = "";
	if (direction == north) {face = face_north;}
	if (direction == south) {face = face_south;}
	if (direction == east) {face = face_east;}
	if (direction == west) {face = face_west;}
	SetFrameRate(GetMapEngineFrameRate());
	QueuePersonCommand(name, face, false);
	for (j = 0; j < tiles; ++j)
	{
		for(i = 0; i < 16; ++i){
			QueuePersonCommand(name,direction, false);
		}
	}
}

function Face(who,command)
{
	QueuePersonCommand(who,command,true);
	UpdateMapEngine();
}

function SantaHeartAttack()
{
	CreatePerson("Santa","Santa.rss",true);
	SetPersonXYFloat("Santa",72,24);
	Move("Santa",south,6);
	WaitForPerson("Santa");
	Move("Santa",east,3);
	WaitForPerson("Santa");
	SetPersonDirection("Santa","MAD");
	SetPersonScript("Santa",SCRIPT_COMMAND_GENERATOR,'QueuePersonCommand("Santa",COMMAND_ANIMATE,true);');
	DispMsg("Santa",red,"Look at what my elves done!");
	Delay(250);
	DispMsg("Santa",red,"This will take years to sort!");
	Delay(250);
	DispMsg("Santa",red,"Christmas comes in a few days!!");
	Delay(250);
	DispMsg("Santa",red,"What will I do!?");
	Delay(250);
	DispMsg("Santa",red,"WHERE HAS THAT WRETCHED...");
	Delay(250);
	DispMsg("Santa",red,"...RED NOSED DEER GONE!");
	Delay(250);
	SetPersonDirection("Santa","Heart");
	DispMsg("Santa",red,"Oh... My heart. Oh...");
	Wait(3000);
	SetPersonDirection("Santa","Dead");
	CreatePerson("help1","Helper.rss",true);
	SetPersonXYFloat("help1",72,24);
	Move("help1",south,6);
	WaitForPerson("help1");
	CreatePerson("help2","Helper.rss",true);
	SetPersonXYFloat("help2",72,24);
	Move("help1",east,3);
	Move("help2",south,3);
	WaitForPerson("help2");
	CreatePerson("help3","Helper.rss",true);
	SetPersonXYFloat("help3",72,24);
	Move("help2",east,3);
	WaitForPerson("help2");
	Move("help2",south,2);
	Move("help3",south,7);
	WaitForPerson("help3");
	Move("help3",east,4);
	WaitForPerson("help3");
	Move("help3",north,1);
	WaitForPerson("help3");
	SetPersonDirection("help3","west");
	DispMsg("help1",green,"O-oh! He's dead!");
	Delay(250);
	DispMsg("help3",green,"Well, what do you want to do with him?");
	Delay(250);
	DispMsg("help2",green,"We could wrap him up in a present!");
	Delay(250);
	DispMsg("help1",green,"Yeah! We are so good at doing that!");
	Delay(250);
	DispMsg("help2",green,"We'll give santa to the children!");
	Delay(250);
	DispMsg("help1",green,"Although he's dead...");
	Delay(250);
	DispMsg("help2",green,"Is it me or is he stinking?");
	Delay(250);
	DispMsg("help3",green,"It must be decaying flesh...");
	Delay(250);
	DispMsg("help1",green,"Then we'll need to perfume him!");
	Wait(1000);
	SetPersonDirection("Santa","Perfumed");
	SetPersonScript("Santa",SCRIPT_COMMAND_GENERATOR,'QueuePersonCommand("Santa",COMMAND_ANIMATE,true);');
	Wait(2000);
	DispMsg("help1",green,"Ahh, now he smells better!");
	Delay(250);
	DispMsg("help3",green,"What are we waiting for? Let's wrap him up!");
	Delay(250);
	DispMsg("help2",green,"Heave-ho!");
	Wait(1000);
	SetPersonDirection("Santa","Wrapped");
	Wait(1000);
	DispMsg("help1",green,"Okay. Let's get outta here!");
	Delay(250);
	DispMsg("help2",green,"I call Rudolf!");
	Delay(250);
	DispMsg("help3",green,"Shotgun for sleigh!");
	RenderMap();
	FadeOut(2040);
	RestartGame();
}

function RudolfCinematic()
{
	ChangeMusic(Rudolf);
	CreatePerson("Rudolf","Rudolf.rss",true);
	UpdateMapEngine();
	RenderMap();
	FadeIn(1020);
	Move("Rudolf",east,6);
	WaitForPerson("Rudolf");
	SetPersonDirection("Rudolf","LookEast");
	Wait(1000);
	Move("Rudolf",east,7);
	WaitForPerson("Rudolf");
	SetPersonDirection("Rudolf","eat");
	CreatePerson("Hunter","Hunter.rss",true);
	SetPersonXYFloat("Hunter",312,216);
	Move("Hunter",west,7);
	WaitForPerson("Hunter");
	SetPersonDirection("Hunter","east");
	SetPersonDirection("Rudolf","LookEast");
	Wait(1000);
	SetPersonDirection("Rudolf","eat");
	DispMsg("Hunter",brown,"Well, looks like I have meself a deer!");
	SetPersonDirection("Rudolf","LookEast");
	Wait(1000);
	Move("Rudolf",west,7);
	Move("Hunter",west,3);
	WaitForPerson("Rudolf");
	SetPersonDirection("Rudolf","LookWest");
	Wait(1000);
	Move("Rudolf",west,1);
	Wait(1000);
	Move("Rudolf",west,1);
	Move("Hunter",west,2);
	Wait(1000);
	SetPersonDirection("Hunter","Shoot");
	SetPersonDirection("Rudolf","LookWest");
	Wait(500);
	DispMsg("Hunter",brown,"Got ya!");
	SetPersonDirection("Rudolf","Scared");
	CreatePerson("Bullet","Bullet.rss",true);
	SetPersonXYFloat("Bullet",GetPersonX("Hunter"),GetPersonY("Hunter")-24);
	SetPersonSpeed("Bullet",9);
	Move("Bullet",north,1);
	WaitForPerson("Bullet");
	DestroyPerson("Bullet");
	SetPersonDirection("Rudolf","dead");
	Move("Hunter",north,9);
	WaitForPerson("Hunter");
	DispMsg("Hunter",brown,"Woo boy! It even has a red nose!");
	Delay(250);
	DispMsg("Hunter",brown,"... and a tag... 'Belongs to santa'");
	Delay(250);
	DispMsg("Hunter",brown,"Well... Guess we'll do without santa this year...");
	Delay(250);
	DispMsg("Hunter",brown,"Oh well. Pretty sure the meat will sell fine!");
	RenderMap();
	FadeOut(2040);
	RestartGame();
}