// Main.js by Radnen. 2007

//------REQUIRE SCRIPTS------//
RequireScript('Load Data.js');
RequireScript('Items.js');
RequireScript('Spells.js');
RequireScript('Player.js');
RequireScript('Movement.js');
RequireScript('Enemies.js');
RequireScript('Animate.js');
RequireScript('audio.js');
RequireScript('Tile Break.js');
RequireScript('Battle.js');
RequireScript('FadeObject.js');
RequireScript('Teleport.js');
RequireScript('TextWindow.js');
RequireScript('FadeWindow.js');
RequireScript('FadeText.js');
RequireScript('Menu.js');
RequireScript('Shops.js');
RequireScript('lithonite.js');
RequireScript('Debug.js');
RequireScript('Cutscenes.js');

RequireSystemScript('time.js');
RequireSystemScript('screen.js');

// Declare the Lithonite engine //
var Lithonite = new LithoniteEngine("Lithonite");
function slope(c){Lithonite.slope(c)};

var hidefeet = true; //??

function game()
{
	var MainMenu = new StartMenu();
	MainMenu.addOption("New",Intro);
	MainMenu.addOption("Continue",Start);
	MainMenu.addOption("Load",'',Gray,DarkGray,false);
	MainMenu.addOption("Credits",'',Gray,DarkGray,false);
	MainMenu.addOption("Exit",Exit);
	
	ChangeMusic('Title.ogg',true,1.250);
	MainMenu.draw();
}

function Start(){MapEngine("Test.rmp",60);}

function NewGame()
{
	ChangeMap('House.rmp');
	ChangeMusic('MedievalTown.ogg',true,1.250);
	CreatePerson("you","Player.rss",false);
	SetPersonValue("you","d","north");
	Lithonite.SaveDirections("you");
	SetPersonSpeed("you",1.5);
	SetPersonXYFloat("you",96,160);
	AttachInput("you");
	AttachCamera("you");
	UpdateMapEngine();
	RenderMap();
	DrawText("Wake! Young warrior!",SW/2-font.getStringWidth("Wake! Young warrior!")/2,SH/2);
	Move("you",2,EAST);
	WaitForPerson("you");
	SetPersonDirection("you","yawn");
	RenderMap();
	DrawText("Someones calling for you!",SW/2-font.getStringWidth("Someones calling for you!")/2,SH/2);
	SetPersonDirection("you","stopeast");
	SetPersonScript("you",SCRIPT_COMMAND_GENERATOR,'ResetAttack()');
	SetUpdateScript('Update()');
	SetRenderScript('Render()');
}

function Update()
{
	if (Player.battleZone)
	{
		/*UpdateAttack();
		UpdateMagic();*/
		UpdateBattle();
		UpdateEnemies();
		CountTicks(); // for sword power in power meter.
	}
	GrassHiding();
	Movement();
}

var Debug = false;

function Render()
{
	Lithonite.deObstruct();
	DrawPowerBar();
	DrawEnemyHealthBar();
	DrawAuraTicker();
	GoldMeter.draw();
	RenderText();
	if (IsKeyPressed(KEY_TAB))
	{
		if (Debug) {Debug = false; SetLayerVisible(2,false);}
		else {Debug = true; SetLayerVisible(2,true);}
		Delay(200);
	}
	if (Debug) DrawDebug();
}

function CountTicks()
{
	if(Player.ticks!=Player.maxTicks) Player.ticks++;
}

function ClearKeys()
{
	while(AreKeysLeft())
	{
		GetKey();
	}
}

// For test game:

function DrawPowerBar()
{
	if (Player.battleZone)
	{
		PowerBar.blit(SW/2-PowerBar.width/2,SH-20);
		font.drawText(SW/2-PowerBar.width/2+4,SH-16,Math.round(Player.ticks/Player.maxTicks*100) + "%");
		Spells[Player.spell].img.blit(SW/2+PowerBar.width/2+2,SH-18);
	}
	hpMeter.blit(0,0);
	mpMeter.blit(0,16);
	Rectangle(14,4,Player.hp/Player.maxhp*52,4,Red);
	Rectangle(14,20,Player.mp/Player.maxmp*36,4,Blue);
}

function DrawEnemyHealthBar()
{
	for(var i = 0; i < BattleEnemies.length; ++i)
	{
		with(BattleEnemies[i])
		{
			if(damage2 < damage*5 && (hp2-damage2/5) >= 0)
			{
				var Color = CreateColor(255,0,0,(hp2-damage2/5)/maxhp*255);
				GradientRectangle(M2X(1,x-16),M2Y(1,y-24),(hp2-damage2/5)/maxhp*32,2,Red,Color,Color,Red);
				Outline(x-16,y-25,x+16,y-22);
				font.drawText(M2X(1,x+16),M2Y(1,y-24),"-" + damage);
				damage2++;
			}
		}
	}
}

function GetPerson(x,y)
{
	var p_list = GetPersonList();
	for (var i = 0; i < p_list.length; ++i)
	{
		var px = GetPersonX(p_list[i]);
		var py = GetPersonY(p_list[i]);
		if (px-7 < x && px+8 > x && py-7 < y && py+8 > y) return p_list[i];
	}
}

function CharacterName()
{
	var name = "";
	var naming = 1;
	while (naming)
	{
		title.blit(0,0);
		font.drawText(SW/2-60,SH/2-20,"Name:");
		window.drawWindow(SW/2-60,SH/2-5,120,10);
		font.drawText(SW/2-60,SH/2-5,name);
		FlipScreen();
		if (name.length < 8) name += GetKeyString(GetKey(),IsKeyPressed(KEY_SHIFT));
		if (IsKeyPressed(KEY_ENTER)) {if(name.length > 0) naming = false;}
		if (IsKeyPressed(KEY_BACKSPACE)) {name = name.slice(0,name.length-1); Delay(200);}
	}
	Player.name = name;
}