//___________________________________
//                                   \
// Lithonite Engine.  version 1.9d
//___________________________________/
/*

[Chronotrigger-a-like anti obstruction walking algorithm]

Check for obstructions and help sprite walk, execute lithonite

Changelog:
	Added push variable
	Fixed historical vector error.
	faster getCommand() and getFaceDir()
	Fixed Diagonal Deobstruction.
	New check-facing algorithm. Merged 1.3n and 1.4 into 1.4n
	Added slope()
	Changed some of the variables so Lithonite works during cutscenes.
	Lithonite now works better when Running.
	removed getFaceDir in favour of getDir('face_',
	moved SwapDirections from phenibut into Lithonite.
	Fixed Sphere touch bug for pushing.
	Implemented slope('s'): Snow Slippery walk
	Moved slope functions to SLOPES with long names. i.e:slope('slip').
	Fixed typo in LoadDirections().
	Fixed bug when pushing a Person.
	unix2dos. Added inline help (makes it slower, use 1.9f if speed is critical)
	Added this.is, so we can repos back if we've been deObstructed unnecessarily.
	Added .touched and .touching, .IsTouching() and .reposBack()
*/

function LithoniteEngine(objname,GIP)
{
  if(this instanceof LithoniteEngine== false) {
    return new LithoniteEngine(objname,GIP);
  }

this.objname=objname;
this.active=true;
this.speed_normalX=1.5;
this.speed_normalY=1.5;
this.speed_dashX=2.5;
this.speed_dashY=2.5;
this.speed_crawlX=.6;
this.speed_crawlY=.6;
this.isDashing=false;
this.isCrawling=false;
this.setDashingSprite
this.isSloping=false;
this.setDashDir= function(){};
this.setCrawlDir= function(){};
this.setNormalDir= function(){};
this.moving=0;	//0: standing 1: walking 2: Cinematics 3: whatever
this.GIP=(typeof GIP=="string")?GIP:"";
this.idle=0; // Idle counter (not moving)
this.pushing=0;
this.LMaxLookupX=8; //If you are 8 pixels off in the X-axis, it will reposition you to be not obstructed.
this.LMaxLookupY=8; //If you are 8 pixels off in the Y-axis, it will reposition you to be not obstructed.
this.move_x=0; this.move_y=0; //#Primary Lithonite vectors (integer -1,0 or 1)
this.hist_x=0; this.hist_y=0; //#Historical Lithonite vectors (integer -1,0 or 1)
this.old_x=0; this.old_y=0;   //#Slope auxiliary vectors
this.i_x=0;this.i_y=0; //#Inertia: Slope's icewalk/slippery speed vectors (float)
this.ix=0;this.iy=0; //#Inertia Lithonite Vectors (integer -1,0 or 1)
this.iif=0.01;	//Inertia Factor, at which speed increases
this.isf=1.07;	//Slip Factor, at which speed decreases
this.dir=0;	//Slope auxiliary direction = (this.hist_x+(this.hist_y<<2))
this.counter=0; // General Purpose action counter
this.is = 0; //Tells us if we just used lithonite to deobstruct, so we can move back if we touched an item that dissapears
this.touched=""; //Last person who has been touched
this.touching=""; //Holds for 1 cycle the name of a newly touched person.
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.setInputPerson = function(person) {
	this.GIP=person||(IsInputAttached()?GetInputPerson():this.GIP);
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.checkDashing = function(KEY) {
 if(!this.moving)return;
 if(IsKeyPressed(KEY)) 
 {
	if(!this.isDashing)
	{
		this.isDashing=true;
		this.isCrawling=false;
		SetPersonSpeedXY(this.GIP,this.speed_dashX,this.speed_dashY);
		this.setDashDir();
	} 
	return true;
 }
 else if(this.isDashing)
 {
	this.isDashing=false;
	SetPersonSpeedXY(this.GIP,this.speed_normalX,this.speed_normalY); 
	this.setNormalDir();
	return false;
 }
}

LithoniteEngine.prototype.checkCrawling = function(KEY) {
 if(!this.moving)return;
 if(IsKeyPressed(KEY)) 
 {
	if(!this.isCrawling)
	{
		this.isDashing=false;
		this.isCrawling=true;
		SetPersonSpeedXY(this.GIP,this.speed_crawlX,this.speed_crawlY);
		this.setCrawlDir();
	} 
	return true;
 }
 else if(this.isCrawling)
 {
	this.isCrawling=false;
	SetPersonSpeedXY(this.GIP,this.speed_normalX,this.speed_normalY); 
	this.setNormalDir();
	return false;
 }
}

LithoniteEngine.prototype.resetSpeed = function() {
	if(this.isDashing)
		SetPersonSpeedXY(this.GIP,this.speed_dashX,this.speed_dashY);
	else if(this.isCrawling)
		SetPersonSpeedXY(this.GIP,this.speed_crawlX,this.speed_crawlY);
	else
		SetPersonSpeedXY(this.GIP,this.speed_normalX,this.speed_normalY); 
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.calcVectors = function() {
	if(this.moving==2) return;
	this.move_x=this.move_y=0;
	if(IsKeyPressed(KEY_UP)   ) {this.moving=1; --this.move_y;}
	if(IsKeyPressed(KEY_RIGHT)) {this.moving=1; ++this.move_x;}
	if(IsKeyPressed(KEY_DOWN) ) {this.moving=1; ++this.move_y;}
	if(IsKeyPressed(KEY_LEFT) ) {this.moving=1; --this.move_x;}
	if(!this.moving){++this.idle;this.pushing=0;} else this.idle=0;
	if(this.move_x||this.move_y) {this.hist_x=this.move_x;this.hist_y=this.move_y;}
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.justStopped = function() {
	return(!this.move_x&&!this.move_y&&this.moving);
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.IsTouching = function() {
	if(this.touching && this.touching!=this.touched){
		this.touched=this.touching;
		this.touching="";
		return 1;
	}
	return 0;
}

//----------------------------------------------------------------------------//
LithoniteEngine.prototype.deObstruct = function(Person) {
 if(this.moving&&this.active)
 {
  Person=Person||this.GIP; 
  var $GPXX=GetPersonX(Person)+this.move_x;
  var $GPYY=GetPersonY(Person)+this.move_y;
  if(this.isDashing){$GPXX+=this.move_x; $GPYY+=this.move_y;}
  if(IsPersonObstructed(Person,$GPXX,$GPYY))
  {
	var $GPX = GetPersonX(Person);
	var $GPY = GetPersonY(Person);
	this.touching=GetObstructingPerson(Person, $GPXX, $GPYY);
	//Do nothing if we pressed 2 keys and it can go in one of those directions
	if(	this.move_x && this.move_y &&
		(
			!IsPersonObstructed(Person,$GPXX,$GPY)  
		||
			!IsPersonObstructed(Person,$GPX,$GPYY)
		)
	) return this.is=0;
  	else { //#1keypressed

	var $domoveL=0; var $domoveR=0;
	var $dHI=0; var $dVI=0;
	var $i=this.move_x?this.LMaxLookupX-1:this.LMaxLookupY-1;
	do{
		$dHI=this.move_y*$i; $dVI=this.move_x*$i;
		$domoveL=!IsPersonObstructed(Person,$GPXX+$dHI,$GPYY-$dVI);
		$domoveR=!IsPersonObstructed(Person,$GPXX-$dHI,$GPYY+$dVI);
		if($domoveL!=$domoveR)$i=0;
	}while($i--);
	if($domoveL && ($domoveL>=$domoveR))
	{
		SetPersonX(Person,$GPX+this.move_y);
		SetPersonY(Person,$GPY-this.move_x);
		return this.is=1;
	}
	else if($domoveR)
	{
		SetPersonX(Person,$GPX-this.move_y);
		SetPersonY(Person,$GPY+this.move_x);
		return this.is=2;
	}
	else{
		SetPersonX(Person,$GPX);
		SetPersonY(Person,$GPY);
	}
	if(GetObstructingPerson(Person,$GPXX,$GPYY)&&(!this.pushing++))
	CallPersonScript(GetObstructingPerson(Person,$GPXX,$GPYY), SCRIPT_ON_ACTIVATE_TOUCH);
  	}
  }//Else 1keypressed
 }//End_if:moving
 return this.is=0;
}

//----------------------------------------------------------------------------//


//----------------------------------------------------------------------------//

LithoniteEngine.prototype.standStill = function() { this.setDir('face_'); }

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.setDir = function(dir) {
 if(this.moving!=2) this.moving = 0;
 if(IsInputAttached()) //Just in case a cinematic sequence is playing
 {
  SetPersonFrame(this.GIP,0); //Just return to frame 0
  //Now determine if we have <dir>_<direction>, save it in the persons object if not.
  var data = GetPersonData(this.GIP);
  var facedir = this.getDir( dir,this.hist_x,this.hist_y);
  if(typeof data[facedir] == 'undefined')
  {
		data[facedir] = false;
		var ssd=GetPersonSpriteset(this.GIP).directions;
		var i=ssd.length-1;
		do{if (ssd[i].name==facedir) data[facedir] = true;}while(i--);
		SetPersonData(this.GIP,data);
  }
  if(data[facedir]) SetPersonDirection(this.GIP, facedir);
 }
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.getMoveDir = function(x,y) {
 switch(x+(y<<2))
 {
	case -5: return 'northwest'; break;
	case -4: return 'north'; break;
	case -3: return 'northeast'; break;
	case -1: return 'west'; break;
	case 1: return 'east'; break;
	case 3: return 'southwest'; break;
	case 4: return 'south'; break;
	case 5: return 'southeast'; break;
 }
 return 'south';
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.getDir = function(dir,x,y) {
 return dir+this.getMoveDir(x,y);
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.SwapDirections = function(movement,person)
{
	var Person=person||this.GIP;
	var GPSS= GetPersonSpriteset(Person);
	var GPSSd=GPSS.directions;
	var i=GPSSd.length-1;
	do{
		switch(GPSSd[i].name)
		{
			case "north":		GPSSd[i].name=movement+"north"; break;
			case movement+"north":	GPSSd[i].name="north"; break;
			case "south":		GPSSd[i].name=movement+"south"; break;
			case movement+"south":	GPSSd[i].name="south"; break;
			case "east":		GPSSd[i].name=movement+"east"; break;
			case movement+"east":	GPSSd[i].name="east"; break;
			case "west":		GPSSd[i].name=movement+"west"; break;
			case movement+"west":	GPSSd[i].name="west"; break;
			case "northwest":	GPSSd[i].name=movement+"northwest"; break;
			case movement+"northwest":	GPSSd[i].name="northwest"; break;
			case "northeast":		GPSSd[i].name=movement+"northeast"; break;
			case movement+"northeast":	GPSSd[i].name="northeast"; break;
			case "southwest":		GPSSd[i].name=movement+"southwest"; break;
			case movement+"southwest":	GPSSd[i].name="southwest"; break;
			case "southeast":		GPSSd[i].name=movement+"southeast"; break;
			case movement+"southeast":	GPSSd[i].name="southeast"; break;
		}
	}while(i--);
	SetPersonSpriteset(Person,GPSS);
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.SaveDirections = function(person)
{
	var Person=person||this.GIP;
	var GPSS= GetPersonSpriteset(Person);
	var GPSSd=GPSS.directions;
	var i=GPSSd.length-1;
	this.directions=new Array(i);
	do{
		Lithonite.directions[i]=GPSSd[i].name;
	}while(i--);
	return true;
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.LoadDirections = function(person)
{
	var Person=person||this.GIP;
	var GPSS= GetPersonSpriteset(Person);
	var GPSSd=GPSS.directions;
	if(GPSSd.length != this.directions.length)return false;
	var i=GPSSd.length-1;
	do{
		GPSSd[i].name=this.directions[i];
	}while(i--);
	SetPersonSpriteset(Person,GPSS);
	return true;
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.getCommand = function(move,x,y) {
	if(move)
	{
		switch(x+(y<<2))
		{
		case -4: return COMMAND_MOVE_NORTH;
		case 4: return COMMAND_MOVE_SOUTH;
		case -3: case -5: case 1: return COMMAND_MOVE_EAST;
		case 3: case 5: case -1: return COMMAND_MOVE_WEST;
		}
	}
	switch(x+(y<<2))
	{
		case -5: return COMMAND_FACE_NORTHWEST;
		case -4: return COMMAND_FACE_NORTH;
		case -3: return COMMAND_FACE_NORTHEAST;
		case -1: return COMMAND_FACE_WEST;
		case 1: return COMMAND_FACE_EAST;
		case 3: return COMMAND_FACE_SOUTHWEST;
		case 4: case 0:return COMMAND_FACE_SOUTH;
		case 5: return COMMAND_FACE_SOUTHEAST;
	}
	return COMMAND_WAIT;
}

//----------------------------------------------------------------------------//
/*
	Due to a rounding bug, sometimes $GPZZ != GetPersonZFloat(Person) (Z = X and Y)
	when dx or dy are float. This is intrinsic to Javascript. 
*/
LithoniteEngine.prototype.repos = function(dx,dy,person) {
  var Person=person||this.GIP;
  var $GPXX = GetPersonXFloat(Person)+dx;
  var $GPYY = GetPersonYFloat(Person)+dy;

  if(!IsPersonObstructed(Person,$GPXX,$GPYY)){
	SetPersonX(Person,$GPXX);
	SetPersonY(Person,$GPYY);
	return 1;
  }
  return 0;
}	

LithoniteEngine.prototype.reposNextTo = function(who,dx,dy,person) {
  var Person=person||this.GIP;
  var $GPXX = GetPersonXFloat(Person)+dx;
  var $GPYY = GetPersonYFloat(Person)+dy;

  if(!IsPersonObstructed(who,$GPXX,$GPYY)){
	SetPersonX(who,$GPXX);
	SetPersonY(who,$GPYY);
	return 1;
  }
  return 0;
}	

// Try to undo what deObstruct() did. 
LithoniteEngine.prototype.reposBack = function(person) {
  switch(this.is){
	case 0: return this.repos(-this.move_x,-this.move_y,person); break;
	case 1: return this.repos(-this.move_y,+this.move_x,person); break;
	case 2: return this.repos(+this.move_y,-this.move_x,person); break;
  }
}

//----------------------------------------------------------------------------//
/*
	repos() but with deObstruct() if we failed to reposition our sprite.
*/
LithoniteEngine.prototype.shove = function(dx,dy,person) {
  var Person=person||this.GIP;
  if(!this.repos(dx,dy,Person)){
	var active=this.active;
	this.active=1;
	this.move_x = dx;
	this.move_y = dy;
	var r=this.deObstruct();
	this.active=active;
	return r;
  }
  return 1;
}	

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.rectifySpeed=function(){
	if(this.isDashing)SetPersonSpeedXY(this.GIP,this.speed_dashX,this.speed_dashY);
	else if(this.isCrawling)SetPersonSpeedXY(this.GIP,this.speed_crawlX,this.speed_crawlY);
	else SetPersonSpeedXY(this.GIP,this.speed_normalX,this.speed_normalY);
	this.i_x=this.i_y=0;
	return 1;
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.doSlope=function(){}; //Is being redefined by slope()

//----------------------------------------------------------------------------//
/*
	Lithonite.slope(<name>);

	While your PC is inside a zone, run a defined script. We have a pre-defined set
	of functions that will cause the PC to move differently.
	Of course, you can use this function to check other things, like opening a door when you're in a zone.
	Once the zone script is running, if we hop onto another zone that overlaps our zone, it will continue to slope.
	Unless each zonescript starts with: Lithonite.isSloping=0;

	You can add your own 'slope' to the SLOPES object, just:
		
		Lithonite.SLOPES['myslope'] = function(){ <my stuff here> };
	Then, inside a zone:
		Lithonite.slope('myslope');

	Remember that inside this function you have access to all LithoniteEngine properties, for example: this.GIP
	
	u:slope goes up,going up; d:slope goes down going up. \ / slope goes upleft or upright.
	u-stairs: same as u, only that it chokes to emulate 'stairs'. d-stairs, /-stairs and \-stairs.
	!U:going UP is impossible, down is ok. !D !L !R
	E:auto-east,no escape. W N S
	E+:auto-east,but you can still walk. W+ N+ S+
	ice: cannot change direction, while skating. slip: skid a bit. tipsy: swap directions (DRUNK!)
	fast float mud(slowdown) velocity:speedup, same as fast. hover:standing still,can change dir.
	SetPersonX(this.GIP,$GPX-this.hist_x); // | and - : only that movement is allowed.
*/
LithoniteEngine.prototype.SLOPES = {

	'\\': function(){this.repos(0,this.move_x);this.deObstruct();},
	'/' : function(){this.repos(0,-this.move_x);this.deObstruct();},
	'u': function(){if(this.move_y<0)SetPersonSpeedXY(this.GIP,1,0.5);if(this.move_y>0)SetPersonSpeedXY(this.GIP,1,1.5);},
	'd': function(){if(this.move_y>0)SetPersonSpeedXY(this.GIP,1,0.5);if(this.move_y<0)SetPersonSpeedXY(this.GIP,1,1.5);},
	'\\-stairs' : function(){var n=Math.abs(Math.round(Math.sin(GetTime()>>6)));SetPersonSpeedXY(this.GIP,n,1); this.repos(0,this.move_x);this.deObstruct()},
	'/-stairs' : function(){var n=Math.abs(Math.round(Math.sin(GetTime()>>6)));SetPersonSpeedXY(this.GIP,n,1); this.repos(0,-this.move_x);this.deObstruct()},
	'u-stairs': function(){var n=Math.abs(Math.round(Math.sin(GetTime()>>6)));if(this.move_y<0)SetPersonSpeedXY(this.GIP,1,n);if(this.move_y>0)SetPersonSpeedXY(this.GIP,1,n*1.5);},
	'd-stairs': function(){var n=Math.abs(Math.round(Math.sin(GetTime()>>6)));if(this.move_y>0)SetPersonSpeedXY(this.GIP,1,n);if(this.move_y<0)SetPersonSpeedXY(this.GIP,1,n*1.5);},
	'!U': function(){if(this.move_y<0){SetPersonSpeedXY(this.GIP,GetPersonSpeedX(this.GIP),1);this.repos(0,-this.move_y);}else this.resetSpeed();},
	'!D': function(){if(this.move_y>0){SetPersonSpeedXY(this.GIP,GetPersonSpeedX(this.GIP),1);this.repos(0,-this.move_y);}else this.resetSpeed();},
	'!R': function(){if(this.move_x>0){SetPersonSpeedXY(this.GIP,1,GetPersonSpeedY(this.GIP));this.repos(-this.move_x,0);}else this.resetSpeed();},
	'!L': function(){if(this.move_x<0){SetPersonSpeedXY(this.GIP,1,GetPersonSpeedY(this.GIP));this.repos(-this.move_x,0);}else this.resetSpeed();},
//	'!L': function(){if(this.move_x<0){n=1;if(this.isDashing)n=this.speed_dashX; this.repos(-this.move_x*n,0);}},
	'fast': function(){this.repos(this.move_x,this.move_y);},
	'tipsy': function(){SetPersonSpeedXY(this.GIP,-1,-1);},
	'E': function(){SetPersonSpeedXY(this.GIP,0,0);if(!this.repos(1,0)){this.moving=1;this.move_x=1;this.deObstruct()};},
	'W': function(){SetPersonSpeedXY(this.GIP,0,0);if(!this.repos(-1,0)){this.moving=1;this.move_x=-1;this.deObstruct()};},
	'N': function(){SetPersonSpeedXY(this.GIP,0,0);if(!this.repos(0,-1)){this.moving=1;this.move_y=-1;this.deObstruct()};},
	'S': function(){SetPersonSpeedXY(this.GIP,0,0);if(!this.repos(0,1)){this.moving=1;this.move_y=1;this.deObstruct()};},

	'E+': function(){SetPersonSpeedXY(this.GIP,0,0);if(!this.repos(1,0)){this.moving=1;this.move_x=1;this.deObstruct()};},
	'W+': function(){SetPersonSpeedXY(this.GIP,0,0);if(!this.repos(-1,0)){this.moving=1;this.move_x=-1;this.deObstruct()};},
	'N+': function(){SetPersonSpeedXY(this.GIP,0,0);if(!this.repos(0,-1)){this.moving=1;this.move_y=-1;this.deObstruct()};},
	'S+': function(){SetPersonSpeedXY(this.GIP,0,0);if(!this.repos(0,1)){this.moving=1;this.move_y=1;this.deObstruct()};},

	'-': function(){SetPersonSpeedXY(this.GIP,GetPersonSpeedX(this.GIP),0);},
	'|': function(){SetPersonSpeedXY(this.GIP,0,GetPersonSpeedY(this.GIP));},

	'x': function(){this.repos(-this.move_y,this.move_x);},
	'mud': function(){SetPersonSpeedXY(this.GIP, 0.5,0.5);},
	'velocity': function(){SetPersonSpeedXY(this.GIP, 2,2);},

	'slip': function(){ 
			this.i_x+=this.iif*this.move_x; if(this.i_x<-1)this.i_x=-1; else if(this.i_x>1)this.i_x=1;
			this.i_y+=this.iif*this.move_y; if(this.i_y<-1)this.i_y=-1; else if(this.i_y>1)this.i_y=1;
			this.ix=this.iy=0;
			if(!this.move_x)this.i_x/=this.isf; if(this.i_x*this.i_x<0.0001)this.i_x=0; else {this.ix=this.i_x<0?-1:1; QueuePersonCommand(this.GIP, this.getCommand(true,this.ix*this.ix,0), true);}
			if(!this.move_y)this.i_y/=this.isf; if(this.i_y*this.i_y<0.0001)this.i_y=0; else {this.iy=this.i_y<0?-1:1; QueuePersonCommand(this.GIP, this.getCommand(true,0,this.iy*this.iy), true);}
			if(this.move_x||this.move_y)QueuePersonCommand(this.GIP, this.getCommand(false,this.move_x,this.move_y), true); else SetPersonFrame(this.GIP,0);
			SetPersonSpeedXY(this.GIP, this.i_x, this.i_y );},
	'ice': function(){SetPersonSpeedXY(this.GIP,0,0);var d=(this.hist_x+(this.hist_y<<2));if(!this.repos(this.old_x,this.old_y)&&(!this.idle)&&(d!=this.dir)){this.dir=d; this.old_x=this.hist_x; this.old_y=this.hist_x?0:this.hist_y;}},

	'float': function(){DetachCamera();var p=Math.sin(GetTime()>>7);this.repos(0,p>>1);},

}


LithoniteEngine.prototype.slope=function(c){
	if(this.isSloping==true)return;
	this.isSloping=true;
	switch(c){

		case 'hover':
			this.standStill();
			this.doSlope=this.SLOPES[c]; 
			break;

		case 'slip':
			this.i_x=this.move_x;
			this.i_y=this.move_y;
			this.doSlope=this.SLOPES[c];
			break;

		case 'ice': 
			this.dir=(this.hist_x+(this.hist_y<<2));
			this.old_x=this.hist_x;
			this.old_y=this.hist_x?0:this.hist_y;
			this.active=false;
			SetPersonSpeedXY(this.GIP,0,0);	//stop walking
			//bounced on a wall AND changed direction?  //iceskate in place until key ispressed.
			this.doSlope=this.SLOPES[c];
			break;
		default:
			if(typeof this.SLOPES[c] == 'function')this.doSlope=this.SLOPES[c];
			else this.doSlope=new Function(c);
	}

	this.zone=GetCurrentZone();
	this.testFromUntil(0,
	"!AreZonesAt(GetPersonX('"+this.GIP+"'),GetPersonY('"+this.GIP+"')||!"+this.objname+".isSloping,GetPersonLayer('"+this.GIP+"'))",
	this.objname+".isSloping=false;"+this.objname+".doSlope=function(){};"+this.objname+".zone=undefined;"+this.objname+".rectifySpeed();"+this.objname+".active=true;",
	1, undefined, true);
}



LithoniteEngine.prototype.testFromUntil=function(delayCounter,condition,runCommand,retryDelay,retryCounter,immediate)
{
	if(typeof retryCounter!='undefined') {if((retryCounter--)<0)return;}
	if(delayCounter>0){SetDelayScript(delayCounter, this.objname+".testFromUntil(0,\""+condition+"\",\""+runCommand+"\","+retryDelay+","+(retryCounter+1)+");");return;}
	if(!eval(condition)){SetDelayScript(retryDelay, this.objname+".testFromUntil(0,\""+condition+"\",\""+runCommand+"\","+retryDelay+","+retryCounter+","+immediate+");");return;}
	if(typeof immediate=='undefined') immediate=true;
	if(immediate)eval(runCommand);else SetDelayScript(1,runCommand);
}


//----------------------------------------------------------------------------//

LithoniteEngine.prototype.DetachAll = function(){
  this.camera=IsCameraAttached()?GetCameraPerson():"";
  this.GIP=IsInputAttached()?GetInputPerson():this.GIP;
  if(IsCameraAttached())DetachCamera();
  if(IsInputAttached())DetachInput();
}

LithoniteEngine.prototype.AttachAll = function(){
  if(this.camera)AttachCamera(this.camera);
  AttachInput(this.GIP);
}

LithoniteEngine.prototype.DetachGIP = function(){
  this.camera=IsCameraAttached()?GetCameraPerson():"";
  this.GIP=IsInputAttached()?GetInputPerson():this.GIP;
  if(IsInputAttached())DetachInput();
}

LithoniteEngine.prototype.AttachGIP = function(){
  AttachInput(this.GIP);
}

LithoniteEngine.prototype.DetachCamera = function(){
  this.camera=IsCameraAttached?GetCameraPerson():"";
  this.GIP=IsInputAttached()?GetInputPerson():this.GIP;
  if(IsCameraAttached())DetachCamera();
}

LithoniteEngine.prototype.AttachCamera = function(){
  if(this.camera)AttachCamera(this.camera);
}

