// text.js by Radnen

/*
	This is used to animate a textbox to open up.
*/
function OpenTextBox()
{
	if (DoesPersonExist("you"))
	{
		var d = GetPersonDirection("you");
		if (d == "north") SetPersonDirection("you","stopnorth");
		if (d == "south") SetPersonDirection("you","stopsouth");
		if (d == "east") SetPersonDirection("you","stopeast");
		if (d == "west") SetPersonDirection("you","stopwest");
		UpdateMapEngine();
	}
	var winObj = new FadeWindow(window,SW-96,56);
	winObj.Slide(76,SH+64,76,SH-64);
	var winObj2 = new FadeWindow(window,48,48);
	winObj2.Slide(-56,SH-58,16,SH-58);
	if (IsMapEngineRunning()) RenderMap();
	PlaySlideWindowArray([winObj,winObj2],300);
}

/*
	This will add text to the text box and can be called
	whenever you need to add in dialogue.
*/
var temp_face = null;
function Text(txt,face)
{
	temp_face = face;
	for (var i = 0; i < txt.length; ++i)
	{
		if (IsMapEngineRunning()) RenderMap();
		window.drawWindow(76,SH-64,SW-96,56);
		window.drawWindow(16,SH-58,48,48);
		face.blit(16,SH-58);
		font.drawTextBox(76,SH-64,SW-96,56,0,txt.substr(0,i));
		FlipScreen();
		Delay(15);
	}
	while(!IsKeyPressed(KEY_CTRL))
	{
		if (IsMapEngineRunning()) RenderMap();
		window.drawWindow(76,SH-64,SW-96,56);
		window.drawWindow(16,SH-58,48,48);
		Darrow.blit(SW/2+38,SH-12);
		face.blit(16,SH-58);
		font.drawTextBox(76,SH-64,SW-96,56,0,txt);
		FlipScreen();
	}
	window.drawWindow(76,SH-64,SW-96,56);
	window.drawWindow(16,SH-58,48,48);
	face.blit(16,SH-58);
	font.drawTextBox(76,SH-64,SW-96,56,0,txt);
	var txtFadeImg = GrabImage(76,SH-64,SW-96,56);
	var txtFadeObj = new FadeImage(txtFadeImg);
	txtFadeObj.slideFrom(76,SH-64);
	txtFadeObj.slideTo(76,SH-64);
	txtFadeObj.fade_type = "out";
	if (IsMapEngineRunning()) RenderMap();
	window.drawWindow(76,SH-64,SW-96,56);
	window.drawWindow(16,SH-58,48,48);
	face.blit(16,SH-58);
	txtFadeObj.slide(500);
}

/*
	This is used to animate the text box to close.
*/
function CloseTextBox()
{
	if (IsMapEngineRunning()) RenderMap();
	window.drawWindow(76,SH-64,SW-96,56);
	window.drawWindow(16,SH-58,48,48);
	var FadeObj = new FadeImage(temp_face);
	FadeObj.slideFrom(16,SH-58);
	FadeObj.slideTo(16,SH-58);
	FadeObj.fade_type = "out";
	FadeObj.slide(300);
	var winObj = new FadeWindow(window,SW-96,56);
	winObj.Slide(76,SH-64,76,SH+64);
	var winObj2 = new FadeWindow(window,48,48);
	winObj2.Slide(16,SH-58,-32,SH-58);
	if (IsMapEngineRunning()) RenderMap();
	PlaySlideWindowArray([winObj,winObj2],300);
}

/*
	This function is used to draw text at certain coordinates.
	Update is used to block the map engine to pause the game or not.
*/
function DrawText(txt,x,y,update)
{
	var BG = GrabImage(0,0,SW,SH);
	if (IsMapEngineRunning()) SetFrameRate(GetMapEngineFrameRate());
	else SetFrameRate(60);
	for (var i = 0; i < txt.length; ++i)
	{
		BG.blit(0,0);
		font.drawText(x,y,txt.substr(0,i));
		FlipScreen();
	}
	while (!IsKeyPressed(KEY_CTRL))
	{
		BG.blit(0,0);
		font.drawText(x,y,txt);
		FlipScreen();
	}
	SetFrameRate(0);
	BG.blit(0,0);
	font.drawText(x,y,txt);
}

/*
	This allows for a "render text", text that is rendered in the render script.
	This text is for updates such as aquiring items and gaining info. Update stuff.
*/

var TextQueue = [];
var QueueCounter = 0;
function QueueRenderText(txt,once)
{
	if(!once) TextQueue.push(txt); // should be that simple.
	else TextQueue[0] = txt; // in case of repeate issues.
	QueueCounter = 150;
}

function RenderText()
{
	if (TextQueue.length > 0)
	{
		Rectangle(SW/2-72,3,120,font.getStringWidth(TextQueue[0]) > 120 ? 20 : 10 ,ClearBlue);
		font.drawTextBox(SW/2-72,3,120,font.getStringWidth(TextQueue[0]) > 120 ? 32 : 16,0,TextQueue[0]);
		QueueCounter--;
		if (QueueCounter == 0)
		{
			TextQueue.splice(0,1);
			if (TextQueue.length > 0) QueueCounter = 150; 
		}
	}
}