// Teleport.js by Radnen

RequireSystemScript('screen.js');

/*
	Basic Teleport function. Can't go wrong with this one.
*/

function Teleport(map,x,y,instant)
{
	var player = GetInputPerson();
	RenderMap();
	if (!instant) FadeOut(500);
	ChangeMap(map);
	SetPersonX(player,(x*16)+7);
	SetPersonY(player,(y*16)+7);
	UpdateMapEngine();
	RenderMap();
	if (!instant) FadeIn(500);
}

function OpenDoor()
{
	var person = GetCurrentPerson();
	if (GetPersonValue(person,"wait") == 0)
	{
		SetPersonValue(person,"wait",100);
		Animate(person,"Open");
		SetPersonScript(person,SCRIPT_COMMAND_GENERATOR,'CloseDoor()');
	}
}

function CloseDoor()
{
	var name = GetCurrentPerson();
	if (IsCommandQueueEmpty(name) && GetPersonValue(name,"wait") > 0)
	{
		SetPersonLayer(name,0);
		SetPersonValue(name,"wait",GetPersonValue(name,"wait")-1);
	}
	if (GetPersonValue(name,"wait") == 0)
	{
		SetPersonFrame(name,0);
		SetPersonValue(name,"wait",-1);
		SetPersonLayer(name,GetPersonLayer("you"));
	}
}

function SwitchMap(map,x,y)
{
	Teleport(map,x,y);
	g_CL = 0;
}