// Spells.js by Radnen

/*
	This is the Spell Object. It holds the info for
	the spell. Each spell has it's own effect function
	Meh, it'll take time...
*/

function Spell(name,effect,cost)
{
	this.name = name;
	this.effect = effect;
	this.img; // a 16x16 bit image depicting the spell.
	this.cost = cost;
}

// List of Spells
var Spells = [];
Spells[0] = new Spell("Fireball",Fireball,5);
Spells[0].img = LoadImage("Icons/Fireball.png");
Spells[1] = new Spell("AtkUp",AtkUp,5);
Spells[1].img = LoadImage("Icons/AttackUp.png");
Spells[2] = new Spell("DefUp",DefUp,10);
Spells[2].img = LoadImage("Icons/DefendUp.png");
Spells[3] = new Spell("Heal",Heal,10);
Spells[3].img = LoadImage("Icons/Heal.png");
Spells[4] = new Spell("Jump",Jump,0);
Spells[4].img = LoadImage("Icons/Jump.png");

/*
	PlayerCast() Is used to animate the casting animations of the player.
*/

function PlayerCast()
{
	if (GetPersonValue("you","d") == "north") Animate("you","CastNorth",true);
	if (GetPersonValue("you","d") == "south") Animate("you","CastSouth",true);
	if (GetPersonValue("you","d") == "west") Animate("you","CastWest",true);
	if (GetPersonValue("you","d") == "east") Animate("you","CastEast",true);
}

/*
	Projectile object. Used to create fireballs and the like.
	It may even be used for arrows and thrown objects.
*/

function Projectile(name, spriteset, animation, atk, destroy)
{
	this.name = name;
	this.pixels = 0;
	this.spriteset = spriteset;
	this.destroy = destroy;
	this.animation = animation;
	this.x; this.y;
	this.atk = atk;;
	this.E_Spriteset = "";
	this.E_Animation = "";
}

Projectile.prototype.create = function(life)
{
	with(this)
	{
		pixels = life;
		if (!DoesPersonExist(name))
		{
			if (animation != undefined) E_Animation = animation;
			CreatePerson(name,spriteset,true);
			IgnoreTileObstructions(name,true);
			IgnorePersonObstructions(name,true);
			SetPersonLayer(name,2);
			SetPersonSpeed(name,3);
		}
	}
}

Projectile.prototype.move = function(face,direction)
{
	with(this)
	{
		if (pixels > 0)
		{
			SetPersonDirection(name,face);
			QueuePersonCommand(name,direction,true);
			SetPersonMask(name,White);
			x = GetPersonX(name);
			y = GetPersonY(name);
			pixels-=1;
			var i = BattleEnemies.length-1;
			if (pixels <= 8 && DoesPersonExist(name))
			{
				SetPersonMask(name,CreateColor(pixels/8*255,pixels/8*255,255,pixels/8*255));
			}
			if (i != -1)
			{
				do
				{
					if (!BattleEnemies[i].death)
					{
						if (x > BattleEnemies[i].x-16 && y > BattleEnemies[i].y-16 &&
								x < BattleEnemies[i].x+16 && y < BattleEnemies[i].y+16)
						{
							DestroyPerson(name);
							if (E_Animation != "")
							{
								if (DoesPersonExist("E" + name)) DestroyPerson("E" + name);
								CreateEntityAnimation("E" + name,spriteset,x,y,E_Animation,2);
							}
							BattleEnemies[i].damageEnemy(atk);
						}
					}
					if (destroy)
					{
						if (x/16 > 0 && y/16 > 0 && x/16 < GetLayerWidth(1)-1 && y/16 < GetLayerHeight(1)-1)
						{
							var Tile = GetTile(x/16,y/16,1);
							if (GetTileName(Tile) == "bush") {SetTile(x/16,y/16,1,0);SetTile(x/16,y/16,2,0)}
						}
					}
				}while(i--);
			}
		}
		else DestroyPerson(name);
	}
}

Projectile.prototype.setup = function()
{
	with(this)
	{
		var d = GetPersonValue("you","d") // player direction
		if (d == "north")
		{
			SetPersonX(name,Player.x); SetPersonY(name,Player.y-16);
		}
		if (GetPersonValue("you","d") == "south")
		{
			SetPersonX(name,Player.x); SetPersonY(name,Player.y+16);
		}
		if (GetPersonValue("you","d") == "east")
		{
			SetPersonX(name,Player.x+16); SetPersonY(name,Player.y-8);
		}
		if (GetPersonValue("you","d") == "west")
		{
			SetPersonX(name,Player.x-16); SetPersonY(name,Player.y-8);
		}
	}
}

/*
	The Aura object is used to give a poerup bonus to your
	main player.
*/

var Auras = [];
function Aura(name,spriteset,direction,life,area)
{
	this.name = name;
	this.spriteset = spriteset;
	this.direction = direction;
	this.life = 0;
	this.maxlife = life;
	this.x = 0; this.y = 0;
	this.effect = "";
	this.onEnd = "";
	this.area = area || false; // for area effect aura //
}

Aura.prototype.create = function()
{
	with(this)
	{
		life = maxlife;
		CreatePerson(name,spriteset,false);
		SetPersonX(name,GetPersonX("you"));
		SetPersonY(name,GetPersonY("you"));
		SetPersonLayer(name,0); // bottom
		SetPersonDirection(name,direction);
		SetPersonScript(name,SCRIPT_COMMAND_GENERATOR,'QueuePersonCommand(GetCurrentPerson(),COMMAND_ANIMATE,true)');
	}
}

Aura.prototype.update = function()
{
	with(this)
	{
		if (DoesPersonExist(name))
		{
			SetPersonX(name,GetPersonX("you"));
			SetPersonY(name,GetPersonY("you"));
			if (GetPersonLayer(name) != 0) SetPersonLayer(name,0);
			if (life == 0)
			{
				DestroyPerson(name);
				eval(onEnd);
			}
		}
	}
}

// This is used to find Auras:
function FindAura(name)
{
	var i = Auras.length-1;
	do
	{
		if(Auras[i].name == name) return i;
	}while(i--);
}

// Is used to set up the player's spell param
function SetUpSpell()
{
	SetPersonValue("you","spell",true);
	SetPersonValue("you","lastdirection",GetPersonDirection("you"));
	Player.ticks = 0;
	DetachInput();
	_tempSS2 = GetPersonSpriteset('you');
	SetPersonSpriteset('you',PlayerSpell);
	if (GetPersonValue("you","hide")) SetPersonSpriteset("you",CutOutBase("you",true));
	if (GetPersonValue("you","water")) SetPersonSpriteset("you",CutOutBase("you",false));
}

// ------THE SPELL EFFECTS------ //
/*
	Each spell effect has a level. A higher level will
	make the effect stronger. And can even change the
	image of the spell to suit it's strength.
	
	I'll only worry about the first level of spells.
	
	Almost all spells will have 2 functions. One for
	spell start, and another for it's end.
*/
// Fireball //
var FireBall = new Projectile("Fireball","Fireball.rss","FireExplosion",4,true);
function Fireball(level)
{
	if(Player.mp >= 4)
	{
		PlaySound(Firestrike);
		SetUpSpell();
		PlayerCast();
		FireBall.create(30);
		Player.mp-=4;
		//PlaySound(FireWhoosh);
		FireBall.setup();
		var d = GetPersonValue("you","d");
		if (d == "north") SetPersonScript("Fireball",SCRIPT_COMMAND_GENERATOR,'FireBall.move("north",NORTH)');
		if (d == "south") SetPersonScript("Fireball",SCRIPT_COMMAND_GENERATOR,'FireBall.move("south",SOUTH)');
		if (d == "east") SetPersonScript("Fireball",SCRIPT_COMMAND_GENERATOR,'FireBall.move("east",EAST)');
		if (d == "west") SetPersonScript("Fireball",SCRIPT_COMMAND_GENERATOR,'FireBall.move("west",WEST)');
	}
	else QueueRenderText("Not enough MP!",1);
}

// AtkUp //
var AttackAura = new Aura("AttackUp","Aura.rss","Powerup",480);
function AtkUp(level)
{
	if(Player.mp >= 6)
	{
		if (!DoesPersonExist("AttackUp"))
		{
			SetUpSpell();
			Player.mp-=6;
			Animate("you","SelfCastRed",true);
			AttackAura.create();
			AttackAura.onEnd = 'Player.atk-=5; SetPersonMask("you",White); Auras.splice(FindAura("AttackUp"),1)';
			Auras.push(AttackAura);
			SetPersonMask("you",CreateColor(255,200,200));
			Player.atk+=5;
		}
	}
	else QueueRenderText("Not enough MP!",1);
}

// DefUp //
var DefendAura = new Aura("DefendUp","Aura.rss","Defendup",480);
function DefUp(level)
{
	if(Player.mp >= 8)
	{
		if(!DoesPersonExist("DefendUp"))
		{
			SetUpSpell();
			Player.mp-=8
			Animate("you","SelfCastBlue",true);
			DefendAura.create();
			DefendAura.onEnd = 'Player.def-=5; SetPersonMask("you",White); Auras.splice(FindAura("DefendUp"),1)';
			Auras.push(DefendAura);
			SetPersonMask("you",CreateColor(200,200,255));
			Player.def+=5;
		}
	}
	else QueueRenderText("Not enough MP!",1);
}

// Heal //
function Heal(level)
{
	if(Player.mp >= 10)
	{
		SetUpSpell();
		Player.mp-=10;
		Animate("you","SelfCastBlue",true);
		CreatePerson("Heal","Heal.rss",true);
		SetPersonX("Heal",Player.x);
		SetPersonY("Heal",Player.y);
		SetPersonLayer("Heal",3);
		Animate("Heal","Animate",false);
		SetPersonScript("Heal",SCRIPT_COMMAND_GENERATOR,'if (IsCommandQueueEmpty("Heal")) DestroyPerson("Heal");');
		if (Player.hp < Player.maxhp-10) Player.hp+=10;
		else Player.hp = Player.maxhp;
	}
	else QueueRenderText("Not enough MP!",1);
}

// Jump // Beta Jump effect
function Jump()
{
	
}
// End O' Spell Effects //


// Eat it.

// Yeah, I mean it.

// Eat it.