// Shop Script //
// Radnen //

function shop(shoptypes)
{
	this.myWeapons = [];
	this.myArmors = [];
	this.items = [];
	this.CI = shoptypes; // array; some shops may sell only one type of thing.
	this.shoptype = "weapons";
	this.cms = 0;
	this.SX = 0;
	this.ci = 0;
	this.S = 0;
}

shop.prototype.addItem = function(array,count)
{
	if(array instanceof Weapon)
	{
		for(var i = 0; i < count;++i) {this.myWeapons.push(array);}
	}
	if(array instanceof Armor)
	{
		for(var i = 0; i < count;++i) {this.myArmors.push(array);}
	}
}

shop.prototype.openShop = function()
{
	var inShop = false;
	var shopping = true;
	this.cms = 0;
	this.SX = 0;
	this.ci = 0;
	this.S = 0;
	var inventorylength = 0;
	
	with(this)
	{
		while(shopping)
		{
			RenderMap();
			Rectangle(0,0,SW,SH,TGray);
			
			if (!inShop)
			{
				window.drawWindow(SW/2-60,SH/2-40,120,80);
				inWindow.drawWindow(SW/2-30,SH/2-8,56,16);
				inWindow.drawWindow(SW/2-48,SH/2-32,96,10);
				inWindow.drawWindow(SW/2-48,SH/2+24,96,10);
				font.drawText(SW/2-48,SH/2-32,"Welcome!");
				font.drawText(SW/2-48,SH/2+24,"Buy " + CI[cms]);
				for (var i = 0; i < ShopIcons.length; ++i)
				{
					ShopIcons[i].blit(SW/2-30+i*20,SH/2-8);
				}
				Selector.blit((SW/2-30+cms*20)-2,SH/2-10);
			}
			else
			{
				window.drawWindow(SW/2-124,32,116,176);
				window.drawWindow(SW/2+8,32,116,176);
				inWindow.drawWindow(SW/2-116,40,100,10);
				inWindow.drawWindow(SW/2+16,40,100,10);
				font.drawText(SW/2-116,40,"Your items.");
				font.drawText(SW/2+16,40,"Shop's items.");
				drawShopItems();
				Selector.blit(SW/2-116+SX*124,56+(ci-S)*24);
				if (S > 0) UpArrow.blit(SW/2+132,52);
				if (S+4 < inventorylength+1) DownArrow.blit(SW/2+132,132);
			}
			
			
			FlipScreen();
			
			while(AreKeysLeft())
			{
				switch(GetKey())
				{
					case KEY_RIGHT:
					if (!inShop)
					{
						if (cms < ShopIcons.length-1) cms++;
					}
					else SX = 1;
					break;
					case KEY_LEFT:
					if (!inShop)
					{
						if (cms > 0) cms--;
					}
					else SX = 0;
					break;
					case KEY_UP:
					if (inShop)
					{
						if (ci != 0)
						{
							ci--;
							if (ci < S) S--;
						}
					}
					break;
					case KEY_DOWN:
					if (inShop)
					{
						if (ci < inventorylength)
						{
							ci++;
							if (ci >= S + 4) S++;
						}
					}
					break;
					case KEY_CTRL:
					if (!inShop)
					{
						shoptype = CI[cms];
						if (CI[cms] == "weapons") inventorylength = myWeapons.length-1;
						if (CI[cms] == "armor") inventorylength = myArmors.length-1;
						if (CI[cms] == "items") inventorylength = myItems.length-1;
						inShop = true;
					}
					else
					{
						if (SX)
						{
							if (shoptype == "weapons") AddItem(myWeapons[ci].name);
							if (shoptype == "armor") AddItem(myArmors[ci].name);
						}
					}
					break;
					case KEY_SHIFT:
						shopping = false;
					break;
				}
			}
		}
	}
}

shop.prototype.drawShopItems = function()
{
	with(this)
	{
		switch(shoptype)
		{
			case "weapons":
				for(var i = 0; i < 4; ++i)
				{
					if (i < myWeapons.length)
					{
						myWeapons[i+S].img.blit(SW/2+10,58+i*24);
						font.drawText(SW/2+28,56+i*24,myWeapons[i+S].name);
					}
				}
			break;
			case "armor":
				for(var i = 0; i < 4; ++i)
				{
					if (i < myArmors.length)
					{ 
						myArmors[i+S].img.blit(SW/2+10,58+i*24);
						font.drawText(SW/2+28,56+i*24,myArmors[i+S].name);
					}
				}
			break;
			case "items":
				for(var i = 0; i < 4; ++i)
				{
					if (i < myItems.length)
					{ 
						myItems[i+S].img.blit(SW/2+10,58+i*24);
						font.drawText(SW/2+28,56+i*24,myItems[i+S].name);
					}
				}
			break;
		}
	}
}

shop.prototype.drawPlayerItems = function()
{
}

var shops = [];
shops[0] = new shop(["weapons","armor","items"]);
shops[0].addItem(Weapons[0],3);
shops[0].addItem(Weapons[1],2);
shops[0].addItem(Armors[0],3);
shops[0].addItem(Armors[1],2);
shops[0].addItem(Armors[2],2);