/*
	This goes in the update script. It checks to see if you are moving.
	If you are not, then it will set your character to an idle stance
	-- a look direction. This also updates the lithonite engine as well
	as update your position to save miliseconds that would have been
	lost in many GetPersonX/Y() calls.
*/
function Movement()
{
	if (!IsMovementKeyPressed() && IsInputAttached())
	{
		var person = GetInputPerson();
		var Direction = GetPersonDirection(person);
		if (Direction == "north") SetPersonDirection(person,"stopnorth"); 
		if (Direction == "south") SetPersonDirection(person,"stopsouth");
		if (Direction == "east") SetPersonDirection(person,"stopeast");
		if (Direction == "west") SetPersonDirection(person,"stopwest");
	}
	if (IsMovementKeyPressed() && IsInputAttached())
	{
		var person = GetInputPerson(); // This won't update every frame.
		if (IsKeyPressed(KEY_UP)) SetPersonValue(person,"d","north");
		if (IsKeyPressed(KEY_DOWN)) SetPersonValue(person,"d","south");
		if (IsKeyPressed(KEY_LEFT)) SetPersonValue(person,"d","west");
		if (IsKeyPressed(KEY_RIGHT)) SetPersonValue(person,"d","east");
	}
	UpdateLithonite();
	Player.x = GetPersonX("you");
	Player.y = GetPersonY("you");
	if (Lithonite.justStopped()) LithoniteIdle();
	//The following is because talk is only checked in directions north/south/west/east and not in face_north/etc.
	if(IsKeyPressed(GetTalkActivationKey())&&Lithonite.moving==0){
		QueuePersonCommand(Lithonite.GIP, Lithonite.getCommand(0,Lithonite.hist_x,Lithonite.hist_y),true);
		Lithonite.moving=1;
	}
}

function IsMovementKeyPressed()
{
	if (IsKeyPressed(KEY_UP)) return true;
	else if (IsKeyPressed(KEY_DOWN)) return true;
	else if (IsKeyPressed(KEY_LEFT)) return true;
	else if (IsKeyPressed(KEY_RIGHT)) return true;
	else return false
}

var NORTH = COMMAND_MOVE_NORTH;
var FACE_NORTH = COMMAND_FACE_NORTH;
var SOUTH = COMMAND_MOVE_SOUTH;
var FACE_SOUTH = COMMAND_FACE_SOUTH;
var EAST = COMMAND_MOVE_EAST;
var FACE_EAST = COMMAND_FACE_EAST;
var WEST = COMMAND_MOVE_WEST;
var FACE_WEST = COMMAND_FACE_WEST;

function Move(name, tiles, direction,face)
{
	if (face == undefined)
	{
		if (direction == NORTH) {face = FACE_NORTH;}
		if (direction == SOUTH) {face = FACE_SOUTH;}
		if (direction == EAST) {face = FACE_EAST;}
		if (direction == WEST) {face = FACE_WEST;}
	}
	for(k=0; k < tiles; k++)
	{
		QueuePersonCommand(name, face, false);
		for(i = 0; i < 16; i++)
		{
			QueuePersonCommand(name,direction, false);
		}
	}
}

function WaitForPerson(who)
{
	SetFrameRate(GetMapEngineFrameRate());
	while (!IsCommandQueueEmpty(who))
	{ 
		UpdateMapEngine();//change instances 
		RenderMap(); //render the map 
		FlipScreen(); //display the map on screen 
	} 
	SetFrameRate(0);
}

function UpdateLithonite()
{
 Lithonite.setInputPerson();
 Lithonite.checkDashing(KEY_SHIFT);
 Lithonite.calcVectors();
 Lithonite.doSlope();
  while (AreKeysLeft()) 
 {
   switch (GetKey()) 
  {
   case KEY_ENTER: GameMenu.draw(); break;
   case KEY_1: Player.spell = 0; break;
   case KEY_2: Player.spell = 1; break;
   case KEY_3: Player.spell = 2; break;
   case KEY_4: Player.spell = 3; break;
   case KEY_H: GoldMeter.appear = 0; Player.gold+=15; break;
  }//end_switch
 }//end_while 
}

function LithoniteIdle()
{
  Lithonite.standStill();
}

/*
	These functions are used to hide your characters base or
	make the effect as though he were walking in water.
*/
function CutOutBase(name,cut)
{
	var SS = GetPersonSpriteset(name);
	var SSImageLength = SS.images.length;
	var SSbase = SS.base;
	for(var i = 0; i < SSImageLength; ++i)
	{
		if (cut) SS.images[i] = Erase(SS.images[i],SSbase.x1-1,SSbase.y1,SSbase.x2+2,SSbase.y2+1);
		else SS.images[i] = TransparentBase(SS.images[i],SSbase.x1-1,SSbase.y1-4,SSbase.x2+2,SSbase.y2+1);
	}
	return SS;
}

function Erase(img,x1,y1,x2,y2) // will return an image with a rectangle erased.
{
	var Simg = img.createSurface();
	Simg.setBlendMode(REPLACE);
	Simg.rectangle(x1,y1,x2-x1,y2-y1,Transparent);
	return Simg.createImage();
}

function TransparentBase(img,x1,y1,x2,y2)
{
	var Simg = img.createSurface();
	var TransparentBlue = CreateColor(50,50,200,125);
	Simg.applyLookup(x1,y1,x2-x1,y2-y1,Color(30),Color(30),Color(180),[]);
	return Simg.createImage();	
}

function Color(num)
{
	var col = [];
	for(var i = num; i > 0; --i) col.push(i); 
	return col; 
}

function GrassHiding()
{
	var x = GetPersonX("you")-7;
	var y = GetPersonY("you")-7;
	var tile = GetTile(x/16,y/16,1);
	if (GetTileName(tile) == "grass")
	{
		if (!GetPersonValue("you","hide"))
		{
			_tempSS = GetPersonSpriteset("you");
			SetPersonSpriteset("you",CutOutBase("you",true));
		}
		SetPersonValue("you","hide",true);
	}
	else if (GetTileName(tile) == "water")
	{
		if (!GetPersonValue("you","water"))
		{
			_tempSS = GetPersonSpriteset("you");
			SetPersonSpriteset("you",CutOutBase("you",false));
		}
		SetPersonValue("you","water",true);
	}
	else if (GetTileName(tile) == "ladder")
	{
		if (!GetPersonValue("you","climb"))
		{
			_tempSS = GetPersonSpriteset("you");
			SetPersonSpriteset("you",PlayerClimbing);
		}
		SetPersonValue("you","climb",true);
	}
	else
	{
		if (GetPersonValue("you","hide")) SetPersonSpriteset("you",_tempSS);
		if (GetPersonValue("you","climb")) SetPersonSpriteset("you",_tempSS);
		if (GetPersonValue("you","water")) SetPersonSpriteset("you",_tempSS);
		SetPersonValue("you","hide",false);
		SetPersonValue("you","climb",false);
		SetPersonValue("you","water",false);
	}
}

//

function RandomMovement(who,tiles)
{
	var direction = [NORTH,SOUTH,EAST,WEST,COMMAND_WAIT,COMMAND_WAIT];
	var face = [FACE_NORTH,FACE_SOUTH,FACE_EAST,COMMAND_FACE_WEST];
	var random = Math.floor(Math.random()*6);
	if (direction[random] == COMMAND_WAIT) tiles = 3;
	for(var t = 0; t < tiles; ++t)
	{
		if (direction[random] != COMMAND_WAIT) QueuePersonCommand(who,face[random],true);
		for(var i = 0; i < 16; ++i)
		{
			QueuePersonCommand(who,direction[random],false);
		}
	}
}

function Move2(who,pixels,face,direction)
{
	SetPersonDirection(who,face);
	for(var i = 0; i < pixels; ++i)
	{
		QueuePersonCommand(who,direction,false);
	}
}

// used to move enemy towards player //
function MoveToPlayer(name)
{
	direction = GetPersonDirection(name)
	var px = GetPersonX("you");
	var py = GetPersonY("you");
	var x = GetPersonX(name);
	var y = GetPersonY(name);
	if (px > x && py > y-15 && py < y+16)
	{
		SetPersonDirection(name,"east");
		QueuePersonCommand(name,EAST,true);
	}
	if (px > x && py > y+16)
	{
		SetPersonDirection(name,"southeast");
		QueuePersonCommand(name,SOUTH,true);
		QueuePersonCommand(name,EAST,true);
	}
	if (py > y && px > x-15 && px < x+16)
	{
		SetPersonDirection(name,"south");
		QueuePersonCommand(name,SOUTH,true);
	}
	if (px < x && py > y+16)
	{
		SetPersonDirection(name,"southwest");
		QueuePersonCommand(name,SOUTH,true);
		QueuePersonCommand(name,WEST,true);
	}
	if (px < x && py > y-15 && py < y+16)
	{
		SetPersonDirection(name,"west");
		QueuePersonCommand(name,WEST,true);
	}
	if (px < x && py < y-15)
	{
		SetPersonDirection(name,"northwest");
		QueuePersonCommand(name,NORTH,true);
		QueuePersonCommand(name,WEST,true);
	}
	if (py < y && px > x-15 && px < x+16)
	{
		SetPersonDirection(name,"north");
		QueuePersonCommand(name,NORTH,true);
	}
	if (px > x && py < y-15)
	{
		SetPersonDirection(name,"northeast");
		QueuePersonCommand(name,NORTH,true);
		QueuePersonCommand(name,EAST,true);
	}
}

/*
	ConvertDirection() is used to convert the players direction to a command.
	"north" becomes COMMAND_MOVE_NORTH
*/
function ConvertDirection(value)
{
	switch(value)
	{
		case "north": return NORTH;
		case "south": return SOUTH;
		case "east": return EAST;
		case "west": return WEST;
	}
}