// In game Menu() // by Radnen

function gameMenu()
{
	this.options = ["Stats","Equip","Spells","Quests","Save","Quit"];
	this.conditions = [false,false,false,false,false];
	this.ci = 0;
	this.cq = 0;
	this.ce = 0;
	this.cea = null;
	this.cew = null;
	this.cs = 0;
	this.inQuestMenu = false;
	this.inSpellMenu = false;
	this.inEquipMenu = false;
	this.PlayerImage = null;
}

gameMenu.prototype.draw = function()
{
	ClearKeys();
	for(var i = 0; i <this.conditions.length; ++i) {this.conditions[i] = false}
	this.ci = 0;
	var active = true;
	var Map = GetCurrentMap();
	
	var winObj = new FadeWindow(window,80,96);
	winObj.Slide(8,-88,8,8);
	var winObj2 = new FadeWindow(window,80,80);
	winObj2.Slide(-88,120,8,120);
	var winObj3 = new FadeWindow(window,104,16);
	winObj3.Slide(8,SH+24,8,SH-24);
	var winObj4 = new FadeWindow(window,184,16);
	winObj4.Slide(SW+8,SH-24,128,SH-24);
	RenderMap();
	Rectangle(0,0,SW,SH,CreateColor(0,0,0,180));
	PlaySlideWindowArray([winObj,winObj2,winObj3,winObj4],200);
	this.PlayerImage = GetPersonSpriteset("you").images[0];
	
	with(this)
	{
		while(active)
		{
			RenderMap();
			Rectangle(0,0,SW,SH,CreateColor(0,0,0,180));
			window.drawWindow(8,8,80,96);
			window.drawWindow(8,120,80,80);
			YourFace.blit(24,120);
			font.drawText(8,168,Player.name);
			font.drawText(8,184,"Lvl:" + Player.level);
			window.drawWindow(8,SH-24,104,16);
			//font.drawText(8,SH-24,"Time:"+GameClock.getTime());
			window.drawWindow(128,SH-24,184,16);
			font.drawText(10,SH-22,"Gold: "+ Player.gold);
			for (var i = 0; i < options.length; ++i)
			{
				font.drawText(16,8+i*16,options[i]);
			}
			if (!inQuestMenu && !inSpellMenu && !inEquipMenu) arrow.blit(8,8+ci*16)
			
			if (conditions[0]) DrawStats();
			if (conditions[1]) DrawEquip();
			if (conditions[2]) DrawSpells();
			if (conditions[3]) DrawQuests();
			
			FlipScreen();
			
			while(AreKeysLeft())
			{
				switch(GetKey())
				{
					case KEY_UP:
						if (!inQuestMenu && !inSpellMenu && !inEquipMenu)
						{
							if (ci > 0) {ci--; PlaySound(Beep);}
						}
						if (inQuestMenu && cq > 0) {cq--; PlaySound(Beep);}
						if (inEquipMenu && ce > 5) {ce-=6; PlaySound(Beep);}
						if (inSpellMenu && cs > 0) {cs--; PlaySound(Beep);}
					break;
					case KEY_DOWN:
						if (!inQuestMenu && !inSpellMenu && !inEquipMenu)
						{
							if (ci < options.length-1) {ci++; PlaySound(Beep);}
						}
						if (inQuestMenu && cq < Player.quests.length-1) {cq++; PlaySound(Beep);}
						if (inEquipMenu && Player.inventory.length-1 > ce+5) {ce+=6; PlaySound(Beep);}
						if (inSpellMenu && cs < Player.spells.length-1) {cs++; PlaySound(Beep);}
					break;
					case KEY_ENTER:
					case KEY_CTRL:
						if (inSpellMenu) {Player.spell = cs; PlaySound(Beep);}
						if (inEquipMenu)
						{
							if (Player.inventory[ce] instanceof Weapon)
							{
								if (cew != ce)
								{
									if (Player.weapon != null) Player.atk-=Player.weapon.atk; // take off old attack
									Player.weapon = Player.inventory[ce];
									Player.atk+=Player.weapon.atk; // add on new attack
									SetPersonSpriteset("you",Player.weapon.ss);
									PlayerImage = GetPersonSpriteset("you").images[0];
									cew = ce;
								}
								else
								{
									Player.atk -= Player.weapon.atk;
									Player.weapon = null;
									SetPersonSpriteset("you",PlayerNormal);
									PlayerImage = GetPersonSpriteset("you").images[0];
									cew = null;
								}
							}
							if (Player.inventory[ce] instanceof Armor)
							{
								if (cea != ce)
								{
									if (Player.armor != null) Player.def-=Player.armor.def; // take off old defence
									Player.armor = Player.inventory[ce];
									Player.def+=Player.armor.def; // add on new defence
									cea = ce;
								}
								else
								{
									Player.def -= Player.armor.def;
									Player.armor = null; // unequip
									cea = null;
								}
							}
						}
						if (ci == 5) Exit();
						for(var i = 0; i <conditions.length; ++i) {conditions[i] = false}
						conditions[ci] = true;
						if (ci == 1) {inEquipMenu = true; PlaySound(Beep)}
						if (ci == 2) {inSpellMenu = true; PlaySound(Beep)}
						if (ci == 3) {inQuestMenu = true; PlaySound(Beep)}
					break;
					case KEY_ESCAPE:
					case KEY_SHIFT:
						if (inEquipMenu) {inEquipMenu = false;conditions[1] = false;PlaySound(Cancel);}
						else if (inSpellMenu) {inSpellMenu = false;conditions[2] = false;PlaySound(Cancel);}
						else if (inQuestMenu) {inQuestMenu = false;conditions[3] = false;PlaySound(Cancel);}
						else active = false;
					break;
					case KEY_RIGHT:
						if (inEquipMenu && ce < Player.inventory.length-1) {ce++; PlaySound(Beep);}
					break;
					case KEY_LEFT:
						if (inEquipMenu && ce > 0) {ce--; PlaySound(Beep);}
					break;
				}
			}
		}
	}
	ClearKeys();
	Delay(250);
}

gameMenu.prototype.DrawStats = function()
{
	window.drawWindow(128,8,168,192);
	inWindow.drawWindow(136,16,152,32);
	font.drawText(136,16,"Name: " + Player.name);
	font.drawText(136,32,"Job: " + Player.job);
	
	inWindow.drawWindow(136,64,152,32);
	font.drawText(136,64,"HP: " + Player.hp + "/" + Player.maxhp);
	font.drawText(136,80,"MP: " + Player.mp + "/" + Player.maxmp);
	
	inWindow.drawWindow(144,112,136,80);
	font.drawText(144,112,"Atk: " + Player.atk);
	font.drawText(144,128,"Def: " + Player.def);
	font.drawText(144,144,"Spd: " + Player.spd);
	font.drawText(144,160,"Exp: " + Player.xp);
	font.drawText(144,176,"Next: " + Player.nxp);
}

gameMenu.prototype.DrawEquip = function()
{
	window.drawWindow(128,8,168,192);
	inWindow.drawWindow(144,16,16,16);
	inWindow.drawWindow(144,80,136,64);
	font.drawText(168,8,"Weapon:");
	if (this.cew != null) {font.drawText(168,24,Player.weapon.name); Player.weapon.img.blit(144,16);}
	else font.drawText(168,24,"NONE");
	inWindow.drawWindow(144,48,16,16);
	font.drawText(168,40,"Armor:");
	if (this.cea != null) {font.drawText(168,56,Player.armor.name); Player.armor.img.blit(144,48);}
	else font.drawText(168,56,"NONE");
	this.DrawItems(144,80);
	font.drawText(144,150,"ATK: " + Player.atk);
	font.drawText(144,166,"DEF: " + Player.def);
	
	if (Player.inventory[this.ce] instanceof Weapon)
	{
		if ((Player.baseatk+Player.inventory[this.ce].atk)-Player.atk > 0)
		{
			font.setColorMask(Green);
			font.drawText(144+font.getStringWidth("ATK: " + Player.atk),150," +" +
			((Player.baseatk+Player.inventory[this.ce].atk)-Player.atk));
		}
		else if ((Player.baseatk+Player.inventory[this.ce].atk)-Player.atk < 0)
		{
			font.setColorMask(Red);
			font.drawText(144+font.getStringWidth("ATK: " + Player.atk),150," " +
			((Player.baseatk+Player.inventory[this.ce].atk)-Player.atk));
		}
		font.setColorMask(White);
	}
	
	if (Player.inventory[this.ce] instanceof Armor)
	{
		if ((Player.basedef+Player.inventory[this.ce].def)-Player.def > 0)
		{
			font.setColorMask(Green);
			font.drawText(144+font.getStringWidth("DEF: " + Player.def),166," +" +
			((Player.basedef+Player.inventory[this.ce].def)-Player.def));
		}
		else if ((Player.basedef+Player.inventory[this.ce].def)-Player.def < 0)
		{
			font.setColorMask(Red);
			font.drawText(144+font.getStringWidth("DEF: " + Player.def),166," " +
			((Player.basedef+Player.inventory[this.ce].def)-Player.def));
		}
		font.setColorMask(White);
	}
	inWindow.drawWindow(234,158,32,32);
	this.PlayerImage.blit(228,144);
}

gameMenu.prototype.DrawItems = function(px,py)
{
	var Inum = 0;
	for (var y = 0; y < 4; ++y)
	{
		for (var x = 0; x < 6; ++x)
		{
			if (Player.inventory[Inum] != undefined) Player.inventory[Inum].img.blit(px+x*20,py+y*20);
			if (Inum == this.ce) Selector.blit(px-2+x*20,py-2+y*20);
			if (Inum == this.cea) equipped.blit(px+x*20,py+y*20);
			if (Inum == this.cew) equipped.blit(px+x*20,py+y*20);
			Inum++;
		}
	}
}

gameMenu.prototype.DrawSpells = function()
{
	window.drawWindow(128,8,168,192);
	inWindow.drawWindow(172,16,64,16);
	inWindow.drawWindow(136,56,152,16);
	font.drawText(204-font.getStringWidth("Spells")/2,16,"Spells");
	Player.spells[Player.spell].img.blit(136,56);
	font.drawText(154,54,"Current Spell:");
	font.drawText(154,64,Player.spells[Player.spell].name);
	inWindow.drawWindow(162,88,104,0);
	for (var i = 0; i < Player.spells.length; ++i)
	{
		inWindow.drawWindow(136,104+i*32,152,16);
		font.drawText(154,102+i*32,Player.spells[i].name);
		font.drawText(154,112+i*32,"MP usage:" + Player.spells[i].cost);
		Player.spells[i].img.blit(136,104+i*32);
	}
	use_arrow.blit(256,104+this.cs*32);
}

gameMenu.prototype.DrawQuests = function()
{
	window.drawWindow(128,8,168,192);
	inWindow.drawWindow(172,16,64,16);
	font.drawText(204-font.getStringWidth("Quests")/2,16,"Quests");
	if (this.inQuestMenu)
	{
		arrow.blit(128,40+this.cq*32);
	}
	if (Player.quests.length == 0) font.drawText(136,40,"No quests here...");
}


var GameMenu = new gameMenu();


function StartMenu()
{
	this.options = [];
	this.ci = 0;
}

StartMenu.prototype.addOption = function(txt,call,clr1,clr2,sel)
{
	if (clr1 == undefined) clr1 = White;
	if (clr2 == undefined) clr2 = Red;
	if (sel == undefined) sel = true;
	var option = new Object;
	option.txt = txt;
	option.call = call;
	option.color = clr1;
	option.highlight = clr2;
	option.sel = sel;
	
	this.options.push(option);
}

StartMenu.prototype.draw = function()
{
	with(this)
	{
		while(!IsKeyPressed(KEY_ESCAPE) && !IsKeyPressed(KEY_SHIFT))
		{
			title.blit(0,0);
			window.drawWindow(SW/2-80,SH/2-32,160,80);
			for(var i = 0; i < options.length; ++i)
			{
				if (ci == i) font.setColorMask(options[i].highlight);
				else font.setColorMask(options[i].color);
				font.drawText(8+SW/2-80,SH/2-32+i*16,options[i].txt);
			}
			
			arrow.blit(SW/2-80,SH/2-31+ci*16);
			
			FlipScreen();
			
			while(AreKeysLeft())
			{
				switch (GetKey())
				{
					case KEY_UP:
						if(ci > 0) {ci--; PlaySound(Beep);}
					break;
					case KEY_DOWN:
						if (ci < options.length-1) {ci++; PlaySound(Beep);}
					break;
					case KEY_CTRL:
						if (options[ci].sel) {options[ci].call(); return;}
					break;
				}
			}
		}
	}
}