// Items //

function Weapon(name, atk, img, price, lvl)
{
	this.name = name;
	this.atk = atk;
	this.img = LoadImage(img);
	this.price = price;
	this.level = lvl;
	this.attack = "";
	this.type = "";
	this.ss = ""; // for players sprite set.
}

var Weapons = [];
Weapons[0] = new Weapon("Old Blade",2,"Icons/Old Sword.png",1,0);
Weapons[0].type = "sword";
Weapons[0].ss = PlayerLongSword;
Weapons[1] = new Weapon("Bow",3,"Icons/Bow.png",150,4);
Weapons[1].type = "range";
Weapons[1].ss = PlayerBow;

function Armor(name, def, img, price, lvl)
{
	this.name = name;
	this.def = def;
	this.img = LoadImage(img);
	this.price = price;
	this.level = lvl;
}

var Armors = [];
Armors[0] = new Armor("Worn Shirt",2,"Icons/Old Clothes.png",1,0);
Armors[1] = new Armor("Worn Leather",4,"Icons/Leather Armor.png",80,1);
Armors[2] = new Armor("Iron Armor",6,"Icons/Iron Armor.png",350,5);

/*
	this is used to add an item to your inventory.
*/
function AddItem(name)
{
	for (var i = 0; i < Weapons.length; ++i)
	{
		if (Weapons[i].name == name) Player.inventory.push(Weapons[i]);
	}
	for (var i = 0; i < Armors.length; ++i)
	{
		if (Armors[i].name == name) Player.inventory.push(Armors[i]);
	}	
}

function GoldObj(amt,x,y,name)
{
	this.amt = amt;
	this.name = name;
	this.x = x; this.y = y;
}

function OnHit()
{
	var x = GetPersonX(GetCurrentPerson());
	var y = GetPersonY(GetCurrentPerson());
	if (Player.x > x-8 && Player.y > y-8 && Player.x < x+8 && Player.y < y+8)
	{
		DestroyPerson(GetCurrentPerson());
		PlaySound(Goldtake,145);
	}
}

GoldObj.prototype.create = function()
{
	with(this)
	{
		CreatePerson(name,"Gold.rss",true);
		SetPersonX(name,x);
		SetPersonY(name,y);
		SetPersonLayer(name,1);
	}
}

var GoldDrops = [];
function DropGold(amt,who)
{
	var x = GetPersonX(who);
	var y = GetPersonY(who);
	GoldDrops.push(new GoldObj(amt,x,y,"Gold"+who))
	with(GoldDrops[GoldDrops.length-1])
	{
		create();
		SetPersonScript(name,SCRIPT_COMMAND_GENERATOR,'OnHit()');
		SetPersonScript(name,SCRIPT_ON_DESTROY,'AddGold(GoldDrops[GoldDrops.length-1].amt)');
	}
}

function AddGold(amount)
{
	Player.gold += amount;
	GoldMeter.appear = 0;
}

/* For Chests */
var Chests = []; // make sure to save this array.
function Chest(num,item_array)
{
	if (!Chests[num])
	{
		Animate(GetCurrentPerson(),"Open",true);
		for(var i = 0; i < item_array.length; ++i)
		{
			if (typeof item_array[i] == "string")
			{
				AddItem(item_array[i]);
				QueueRenderText("Got " + item_array[i] + "!");
			}
			else
			{
				AddGold(item_array[i]);
				QueueRenderText("Got " + item_array[i] + " Gold!");
			}
		}
		PlaySound(Goldtake,145);
		Chests[num] = true;
	}
	else
	{
		QueueRenderText("Chest is empty!");
	}
}