// Fade Window //

function FadeWindow(window,w,h)
{
	// defaults:
	this.window = window;
	this.fade_type = "in";
	this.fade = false;
	this.x = 0;
	this.y = 0;
	this.w = w;
	this.h = h;
	this.xv = 0;
	this.yv = 0;
	this.newX = 0;
	this.newY = 0;
	this.color = CreateColor(255,255,255);
}

FadeWindow.prototype.Slide = function(x1,y1,x2,y2)
{
	with(this)
	{
		x = x1;
		xv = x1;
		y = y1;
		yv = y1;
		newX = x2;
		newY = y2;
	}
}

FadeWindow.prototype.Fade = function(msecs)
{
	var bg = GrabImage(0,0,SW,SH);
	var time = GetTime();
	with (this)
	{
		while (time + msecs > GetTime())
		{
			bg.blit(0,0);
			if (fade)
			{
				if (fade_type == "in") color.alpha = (GetTime() - time) * 255 / msecs;
				if (fade_type == "out") color.alpha = 255 - (GetTime() - time) * 255 / msecs;
			}
			window.setColorMask(color);
			window.drawWindow(xv,yv,w,h);
			if (newX > x) xv = x + (GetTime() - time) * (newX-x) / msecs;
			if (newX < x) xv = x - (GetTime() - time) * (x-newX) / msecs;
			if (newY > y) yv = y + (GetTime() - time) * (newY-y) / msecs;
			if (newY < y) yv = y - (GetTime() - time) * (y-newY) / msecs;
			FlipScreen();
		}
		bg.blit(0,0);
		window.setColorMask(color);
		window.drawWindow(xv,yv,w,h);
	}
}

function PlaySlideWindowArray(array,msecs) // will play all slide images in an array.
{
	var bg = GrabImage(0,0,SW,SH);
	var time = GetTime();
	while(time + msecs > GetTime())
	{
		bg.blit(0,0);
		var i = array.length-1;
		do
		{
			with(array[i])
			{
				if (fade)
				{
					if (fade_type == "in") color.alpha = (GetTime() - time) * 255 / msecs;
					if (fade_type == "out") color.alpha = 255 - (GetTime() - time) * 255 / msecs;
				}
				window.setColorMask(color);
				window.drawWindow(xv,yv,w,h);
				if (newX > x) xv = x + (GetTime() - time) * (newX-x) / msecs;
				if (newX < x) xv = x - (GetTime() - time) * (x-newX) / msecs;
				if (newY > y) yv = y + (GetTime() - time) * (newY-y) / msecs;
				if (newY < y) yv = y - (GetTime() - time) * (y-newY) / msecs;
			}
		}while(i--);
		FlipScreen();
	}
	bg.blit(0,0);
	i = array.length-1;
	do
	{
		with(array[i]) {window.setColorMask(color); window.drawWindow(xv,yv,w,h);}
	}while(i--);
}