// Fade Window //

function FadeText(txt)
{
	// defaults:
	this.font = font;
	this.fade_type = "in";
	this.fade = false;
	this.txt = txt;
	this.x = 0;
	this.y = 0;
	this.xv = 0;
	this.yv = 0;
	this.newX = 0;
	this.newY = 0;
	this.color = CreateColor(255,255,255);
}

FadeText.prototype.Slide = function(x1,y1,x2,y2)
{
	with(this)
	{
		x = x1;
		xv = x1;
		y = y1;
		yv = y1;
		newX = x2;
		newY = y2;
	}
}

FadeText.prototype.draw = function(msecs)
{
	var bg = GrabImage(0,0,SW,SH);
	var time = GetTime();
	with (this)
	{
		while (time + msecs > GetTime())
		{
			bg.blit(0,0);
			if (fade)
			{
				if (fade_type == "in") color.alpha = (GetTime() - time) * 255 / msecs;
				if (fade_type == "out") color.alpha = 255 - (GetTime() - time) * 255 / msecs;
			}
			font.setColorMask(color);
			font.drawText(xv,yv,txt);
			if (newX > x) xv = x + (GetTime() - time) * (newX-x) / msecs;
			if (newX < x) xv = x - (GetTime() - time) * (x-newX) / msecs;
			if (newY > y) yv = y + (GetTime() - time) * (newY-y) / msecs;
			if (newY < y) yv = y - (GetTime() - time) * (y-newY) / msecs;
			FlipScreen();
		}
		bg.blit(0,0);
		font.setColorMask(color);
		font.drawText(xv,yv,txt);
	}
}

function PlayFadeTextArray(array,msecs) // will play all slide images in an array.
{
	var bg = GrabImage(0,0,SW,SH);
	var time = GetTime();
	while(time + msecs > GetTime())
	{
		bg.blit(0,0);
		var i = array.length-1;
		do
		{
			with(array[i])
			{
				if (fade)
				{
					if (fade_type == "in") color.alpha = (GetTime() - time) * 255 / msecs;
					if (fade_type == "out") color.alpha = 255 - (GetTime() - time) * 255 / msecs;
				}
				font.setColorMask(color);
				font.drawText(xv,yv,txt);
				if (newX > x) xv = x + (GetTime() - time) * (newX-x) / msecs;
				if (newX < x) xv = x - (GetTime() - time) * (x-newX) / msecs;
				if (newY > y) yv = y + (GetTime() - time) * (newY-y) / msecs;
				if (newY < y) yv = y - (GetTime() - time) * (y-newY) / msecs;
			}
		}while(i--);
		FlipScreen();
	}
	bg.blit(0,0);
	i = array.length-1;
	do
	{
		with(array[i]) {font.setColorMask(color); font.drawText(xv,yv,txt);}
	}while(i--);
}