// FadeObject.js by Radnen

/*
	This is the fade object function. It is used on images
	that are needed to be faded in and slide across the screen.
*/
function FadeImage(img)
{
	// defaults:
	this.img = img;
	this.fadeStop = 255;
	this.fade = true;
	this.fade_type = "in";
	this.x = 0;
	this.y = 0;
	this.xv = 0;
	this.yv = 0;
	this.newX = 0;
	this.newY = 0;
	this.color = CreateColor(255,255,255); // colormask for fading
}

FadeImage.prototype.slideFrom = function(x,y)
{
	this.x = x;
	this.y = y;
	this.xv = x;
	this.yv = y;
}

// This is used to set the images area to slide towards //
FadeImage.prototype.slideTo = function(newX,newY)
{
	this.newX = newX;
	this.newY = newY;
}

FadeImage.prototype.fadeStop = function(num)
{
	this.fadeStop = num;
}

// This is used to slide the image over time //
FadeImage.prototype.slide = function(msecs)
{
	var bg = GrabImage(0,0,SW,SH);
	var time = GetTime();
	with (this)
	{
		while (time + msecs > GetTime())
		{
			bg.blit(0,0);
			if (fade)
			{
				if (fade_type == "in") color.alpha = (GetTime() - time) * fadeStop / msecs;
				if (fade_type == "out") color.alpha = 255 - (GetTime() - time) * fadeStop / msecs;
			}
			img.blitMask(xv,yv,color);
			if (newX > x) xv = x + (GetTime() - time) * (newX-x) / msecs;
			if (newX < x) xv = x - (GetTime() - time) * (x-newX) / msecs;
			if (newY > y) yv = y + (GetTime() - time) * (newY-y) / msecs;
			if (newY < y) yv = y - (GetTime() - time) * (y-newY) / msecs;
			FlipScreen();
		}
		bg.blit(0,0);
		img.blitMask(xv,yv,color);
	}
}

FadeImage.prototype.clone = function()
{
	var i;
	var temp_obj = new Object;
	for (i in this){temp_obj[i] = this[i];}
	return temp_obj;
}

function PlaySlideImageArray(array,msecs) // will play all slide images in an array.
{
	var bg = GrabImage(0,0,SW,SH);
	var time = GetTime();
	while(time + msecs > GetTime())
	{
		bg.blit(0,0);
		var i = array.length-1;
		do
		{
			with(array[i])
			{
				if (fade)
				{
					if (fade_type == "in") color.alpha = (GetTime() - time) * fadeStop / msecs;
					if (fade_type == "out") color.alpha = 255 - (GetTime() - time) * fadeStop / msecs;
				}
				img.blitMask(xv,yv,color);
				if (newX > x) xv = x + (GetTime() - time) * (newX-x) / msecs;
				if (newX < x) xv = x - (GetTime() - time) * (x-newX) / msecs;
				if (newY > y) yv = y + (GetTime() - time) * (newY-y) / msecs;
				if (newY < y) yv = y - (GetTime() - time) * (y-newY) / msecs;
			}
		}while(i--);
		FlipScreen();
	}
	bg.blit(0,0);
	i = array.length-1;
	do
	{
		with(array[i]) {img.blitMask(xv,yv,color);}
	}while(i--);
}


//---===Blinking Image===---//
/*
	This is used for arrows and text that need to blink
	and not block other processes, their drawing is
	completely dependent on time.
*/
function BlinkImg(img,x,y)
{
	var now = new Date();
	if (now.getMilliseconds() < 500) img.blit(x,y);
}

function BlinkTxt(txt,x,y)
{
	var now = new Date();
	if (now.getMilliseconds() < 500) font.drawText(x,y,txt);
}