// The Enemy Object Code
// Radnen 2007 //

/*
	Basic enemy object. Holds all of the base values for
	a monster. This data will be cloned to battle data
	and from there on the enemies are given life.
*/
function Enemy(hp,atk,def,range)
{ // sight range
	this.hp = hp;
	this.hp2 = hp; // seperate for damage meter.
	this.maxhp = hp;
	this.atk = atk;
	this.def = def;
	this.range = range;
	this.name = "";
	this.death = false;
	this.battle = false;
	this.x; this.y;
	this.direction = "";
	this.move = true;
	this.wait = 120;
	this.maxwait = 120;
	this.grounded = false;
	this.showbar = false;
	this.damage = 0;
	this.damage2 = 0;
	this.onDeath = "";
	this.FollowPlayer = false;
	this.speed = 1.25;
}

/*
	Used to clone data to battle data.
*/
Enemy.prototype.clone = function()
{
	var temp = {};
	for(var i in this) temp[i] = this[i];
	return temp;
}

function Outline(x1,y1,x2,y2)
{
	Line(M2X(1,x1),M2Y(1,y1),M2X(1,x2),M2Y(1,y1),Black);
	Line(M2X(1,x2),M2Y(1,y1),M2X(1,x2),M2Y(1,y2),Black);
	Line(M2X(1,x2),M2Y(1,y2),M2X(1,x1),M2Y(1,y2),Black);
	Line(M2X(1,x1),M2Y(1,y2),M2X(1,x1),M2Y(1,y1),Black);
}

Enemy.prototype.damageEnemy = function(amt)
{
	with(this)
	{
		damage = amt;
		damage2 = 0;
		hp2 = hp;
		hp-=amt;
		
	}
}

var BattleEnemies = []; // Battle data is held here.

/*
	BounceBack(), this function is used to bounce an enemy back after
	being struck by your sword/spear. Enemy bounceback doesn't occur
	with ranged weapons since they lack the force. 
*/

function BounceBack(name)
{
	var num = GetEnemy(name);
	with(BattleEnemies[num])
	{
		if (!grounded && !death)
		{
			ClearPersonCommands(name);
			SetPersonSpeed(name,2);
			var d = GetPersonValue("you","d");
			if (d == "north") QueuePersonScript(name,'Move2(GetCurrentPerson(),20,"flynorth",NORTH)',true);
			if (d == "south") QueuePersonScript(name,'Move2(GetCurrentPerson(),20,"flysouth",SOUTH)',true);
			if (d == "east") QueuePersonScript(name,'Move2(GetCurrentPerson(),20,"flyeast",EAST)',true);
			if (d == "west") QueuePersonScript(name,'Move2(GetCurrentPerson(),20,"flywest",WEST)',true);
			SetPersonValue(name,"bounce",true);
			move = false;
		}
	}
}

var Enemies = [];
// A Gray Wolf //
Enemies[0] = new Enemy(20,5,3,56);
// Enemies[1] = new Enemy();
// --End-- //

function SetEnemy(enemy,num,myAI,onDeath) // Used in an entities On_Create script.
{
	if (onDeath == undefined) onDeath = "";
	SetPersonSpeed(GetCurrentPerson(),Enemies[enemy].speed); 
	BattleEnemies[num] = Enemies[enemy].clone();
	BattleEnemies[num].name = GetCurrentPerson();
	BattleEnemies[num].onDeath = onDeath;
	AI.push(myAI);
}

// ------ENEMY AI------ //
/*
	The AI will be the longest section. Every different enemy
	type will have a different AI. There will be AI's for basic
	fighters, ranged fighters and magic users, as well as for
	each individual boss.
*/
var AI = [];
function TestAI(ID)
{
	if (DoesPersonExist(ID))
	{
		if (ID == undefined) ID = GetCurrentPerson();
		if (ID != undefined)
		{
			var num = GetEnemy(ID);
			var d = GetPersonDirection(ID);
			var ex = GetPersonX(ID);
			var ey = GetPersonY(ID);
			with(BattleEnemies[num])
			{
				if (hp > 0 && move)
				{
					switch(direction)
					{
					case "north":
						if (Player.x > x-24 && Player.y > y && Player.x < x+24 && Player.y < y-range)
						{
							FollowPlayer = true;
						}
						else FollowPlayer = false;
					break;
					case "south":
						if (Player.x > x-24 && Player.y > y && Player.x < x+24 && Player.y < y+range)
						{
							FollowPlayer = true;
						}
						else FollowPlayer = false;
					break;
					case "east":
						if (Player.x > x && Player.y > y-24 && Player.x < x+range && Player.y < y-24)
						{
							FollowPlayer = true;
						}
						else FollowPlayer = false;
					break;
					case "west":
						if (Player.x > x-range && Player.y > y-24 && Player.x < x && Player.y < y+24)
						{
							FollowPlayer = true;
						}
						else FollowPlayer = false;
					break;
					}
					if (!FollowPlayer) RandomMovement(ID,1);
					else MoveToPlayer(ID);
				}
			}
		}
		ResetEnemy(ID);
	}
}

// ------GET ENEMY------//
function GetEnemy(ID)
{
	for ( var i = 0; i < BattleEnemies.length; ++i)
	{
		if (BattleEnemies[i].name == ID) return i;
	}
	return 0;
}

// ------UPDATE ENEMY INFO------ //
/*
	This is used in the update script to kill the enemies when
	their health has reached zero or below. This will not get
	rid of battle data, so stuff like an enemy resurrecting
	another enemy can be made possible.
*/
function UpdateEnemies()
{
	for (var i = 0; i < BattleEnemies.length; ++i)
	{
		if (BattleEnemies[i].hp <= 0 && !BattleEnemies[i].death)
		{
			CreatePerson("S"+BattleEnemies[i].name,"Spark.rss",true);
			SetPersonX("S"+BattleEnemies[i].name,GetPersonX(BattleEnemies[i].name));
			SetPersonY("S"+BattleEnemies[i].name,GetPersonY(BattleEnemies[i].name));
			SetPersonLayer("S"+BattleEnemies[i].name,GetPersonLayer(BattleEnemies[i].name));
			Animate("S"+BattleEnemies[i].name,"spark",false);
			eval(BattleEnemies[i].onDeath);
			DestroyPerson(BattleEnemies[i].name);
			QueuePersonScript("S"+BattleEnemies[i].name,'DestroyPerson(GetCurrentPerson())',true);
			BattleEnemies[i].death = true;
		}
		else
		{
			if (DoesPersonExist(BattleEnemies[i].name))
			{
				BattleEnemies[i].x = GetPersonX(BattleEnemies[i].name);
				BattleEnemies[i].y = GetPersonY(BattleEnemies[i].name);
				BattleEnemies[i].direction = GetPersonDirection(BattleEnemies[i].name);
			}
		}
	}
}

/*
	Now, like your players reset attack function, the enemies need
	one too. Again, this is used to restore their values for wait time
	or animations.
*/

function ResetEnemy(name)
{
	var num = GetEnemy(name);
	with(BattleEnemies[num])
	{
		if (GetPersonValue(name,"bounce") && IsCommandQueueEmpty(name))
		{
			SetPersonValue(name,"bounce",false);
			SetPersonDirection(name,"grounded");
			grounded = true;
			SetPersonSpeed(name,1);
		}
		if (grounded)
		{
			wait--;
			if (wait == 0)
			{
				SetPersonDirection(name,"north");
				move = true;
				wait = maxwait;
				grounded = false;
			}
		}
	}
}