// Debug.js by Radnen

/*
	This goes in a renderscript. It draws all of the info that I
	want it to draw for testing purposes.
*/
function DrawDebug()
{
	font.drawText(0,0,BattleEnemies[0].name + ": hp:" + BattleEnemies[0].hp);
	font.drawText(0,10,BattleEnemies[1].name + ": hp:" + BattleEnemies[1].hp);
	font.drawText(0,40,GetLayerHeight(1));
	font.drawText(0,50,GetLayerWidth(1));
	RenderSwordSpots();
	RenderFireballHotspot();
	RenderSpriteNames();
	RenderSpriteBases();
	DrawEnemySightRange();
	font.drawText(0,20,"Press R to restart game room");
	if (IsKeyPressed(KEY_R)) {BattleEnemies = [];ChangeMap(GetCurrentMap()); Delay(200);}
	for (var i = 0; i < Auras.length; ++i)
	{
		font.drawText(0,SH-10-i*10, Auras[i].name);
	}
	font.drawText(0,60,distance);
}

/*
	Visual debugging functions.
*/

function RenderSwordSpots()
{
	var hotspots = CreateHotSpots(1);
	for(var i = 0; i < hotspots.length; ++i)
	{
		Rectangle(M2X(1,hotspots[i].x*16),M2Y(1,hotspots[i].y*16),16,16,TGray);
	}
}

function RenderFireballHotspot()
{
	if (DoesPersonExist("Fireball"))
	{
		var d = GetPersonDirection("Fireball");
		with(FireBall)
		{
			if (d == "north") Rectangle(M2X(1,x-8),M2Y(1,y-12),16,16,TGray);
			if (d == "south") Rectangle(M2X(1,x-8),M2Y(1,y),16,16,TGray);
			if (d == "east") Rectangle(M2X(1,x),M2Y(1,y-8),16,16,TGray);
			if (d == "west") Rectangle(M2X(1,x-16),M2Y(1,y-8),16,16,TGray);
		}
	}
}

function RenderSpriteNames()
{
	var p = GetPersonList();
	var i = p.length-1;
	do {DrawPersonName(p[i]);}while(i--);
}

function DrawPersonName(name)
{
	var px = GetPersonX(name);
	var py = GetPersonY(name);
	font.drawText(M2X(1,px+16),M2Y(1,py),name);
}

function RenderSpriteBases()
{
  var p = GetPersonList();
  var i=p.length-1;
  do {DrawPersonBase(p[i]);}while(i--);
}

function DrawPersonBase(person)
{
  if(DoesPersonExist(person))
  {
		var layer = GetPersonLayer(person);
		var base = GetPersonBase(person);
		var w = (base.x2-base.x1+1);
		var h = (base.y2-base.y1+1);
		var x1 = M2X(layer,GetPersonX(person)-(w>>1)+1);
		var y1 = M2Y(layer,GetPersonY(person)-(h>>1));
		var x2 = M2X(layer,GetPersonX(person)+(w>>1));
		var y2 = M2Y(layer,GetPersonY(person)+(h>>1));
			
		Line(x1,y1, x2, y1, Blue);
		Line(x1,y1, x1, y2, Blue);
		Line(x1,y2, x2, y2, Blue);
		Line(x2,y1, x2, y2, Blue);
  }
}

function DrawEnemySightRange()
{
	for (var i = 0; i < BattleEnemies.length; ++i)
	{
		with(BattleEnemies[i])
		{
			switch(direction)
			{
			case "north":
				Rectangle(M2X(0,x-24),M2Y(0,y-range),48,range,TGray);
			break;
			case "south":
				Rectangle(M2X(0,x-24),M2Y(0,y),48,range,TGray);
			break;
			case "east":
				Rectangle(M2X(0,x),M2Y(0,y-24),range,48,TGray);
			break;
			case "west":
				Rectangle(M2X(0,x-24),M2Y(0,y-range),48,range,TGray);
			break;
			}
		}
	}
}
