// Cutscenes.js by Radnen 2007

function ClearScreen()
{
	FadeOut(500);
	Rectangle(0,0,SW,SH,Black);
}

function Intro()
{
	CharacterName();
	ChangeMusic('Intro.ogg',true);
	shadow.blit(0,0);
	FadeIn(3000);
	shadow.blit(0,0);
	var Text1 = new FadeText("Radnen Presents...");
	Text1.fade = true;
	Text1.Slide(32,120,SW/2-font.getStringWidth(Text1.txt)/2,80);
	Text1.draw(2500);
	var Text2 = new FadeText("A Sphere 2007 Game.");
	Text2.fade = true;
	Text2.Slide(24,60,SW/2-font.getStringWidth(Text2.txt)/2,120);
	Text2.draw(2500);
	Delay(3000);
	FadeOut(3000);
	Rectangle(0,0,SW,SH,Black);
	DrawText("1000 years ago...",SW/2-font.getStringWidth("1000 years ago...")/2,SH/2);
	ClearScreen();
	DrawText("There was an evil king.",SW/2-font.getStringWidth("There was an evil king")/2,SH/2);
	ClearScreen();
	DrawText("Who searched the world,",SW/2-font.getStringWidth("Who searched the world")/2,SH/2);
	ClearScreen();
	DrawText("For powerful relics.",SW/2-font.getStringWidth("For powerful relics.")/2,SH/2);
	ClearScreen();
	MapEngine("CastleHall.rmp",60);
}

function KingIntro()
{
	CreatePerson("King",'Dark King.rss',true);
	SetPersonDirection("King","stopeast");
	AttachCamera("King");
	Move("King",18,EAST);
	WaitForPerson("King");
	SetPersonDirection("King","stopeast");
	wait(1000);
	OpenTextBox();
	Text("Tell me what you know.",KingFace);
	Text("I-I found a special stone sire.",MonkFace);
	Text("Where is it?",KingFace);
	Text("I-It's in a cavern, deep underground, my lord.",MonkFace);
	Text("I would like to have this relic as my own.",KingFace);
	Text("A-Anything you s-say, sire!",MonkFace);
	CloseTextBox();
	wait(1000);
	RenderMap();
	FadeOut(2000);
	ChangeMap('Dark Citadel.rmp');
	Rectangle(0,0,SW,SH,Black);
	DrawText("And he found the stone.",SW/2-font.getStringWidth("And he found the stone.")/2,SH/2);
	ClearScreen();
	AttachCamera("King");
	UpdateMapEngine();
	RenderMap();
	FadeIn(2000);
	Move("King",14,NORTH);
	WaitForPerson("King");
	SetPersonDirection("King","stopnorth");
	RenderMap();
	DrawText("A trap was sprung.",SW/2-font.getStringWidth("A trap waas sprung.")/2,SH/2);
	RenderMap();
	DrawText("And encased in stone...",SW/2-font.getStringWidth("And encased in stone...")/2,SH/2);
	RenderMap();
	DrawText("The king froze for 1000 years.",SW/2-font.getStringWidth("The king froze for 1000 years.")/2,SH/2);
	SetPersonDirection("King","Stone");
	wait(2000);
	FadeOut(2000);
	ChangeMap('Castle.rmp');
	SetCameraX(184);
	SetCameraY(168);
	UpdateMapEngine();
	RenderMap();
	FadeIn(2000);
	DrawText("Without a king, peace returned.",SW/2-font.getStringWidth("Without a king, peace returned.")/2,SH/2);
	FadeOut(2000);
	ChangeMap('Grass.rmp');
	SetCameraX(312);
	SetCameraY(298);
	UpdateMapEngine();
	RenderMap();
	FadeIn(2000);
	DrawText("And when all seemed well...",SW/2-font.getStringWidth("And when all seemed well...")/2,SH/2);
	RenderMap();
	Earthquake(2,200);
	Delay(1000);
	DrawText("The king broke away,",SW/2-font.getStringWidth("The king broke away,")/2,SH/2);
	RenderMap();
	DrawText("And evil started to return.",SW/2-font.getStringWidth("And evil started to return.")/2,SH/2);
	FadeOut(2000);
	Rectangle(0,0,SW,SH,Black);
	DrawText("The king lost his kingship.",SW/2-font.getStringWidth("The king lost his kingship.")/2,SH/2);
	ClearScreen();
	DrawText("And new kings came.",SW/2-font.getStringWidth("And new kings came.")/2,SH/2);
	ClearScreen();
	DrawText("Now, the only thing left,",SW/2-font.getStringWidth("Now, the only thing left,")/2,SH/2);
	ClearScreen();
	DrawText("is revenge, and destruction.",SW/2-font.getStringWidth("is revenge and destruction.")/2,SH/2);
	ClearScreen();
	NewGame();
}

function Earthquake(times,speed)
{
	var img = GrabImage(0,0,SW,SH);
	Quake = new FadeImage(img);
	for(var i = 0; i < times; ++i)
	{
		Quake.slideFrom(0,0);
		Quake.slideTo(-16,0);
		Quake.slide(speed);
		Quake.slideFrom(-16,0);
		Quake.slideTo(16,0);
		Quake.slide(speed);
		Quake.slideFrom(16,0);
		Quake.slideTo(0,0);
		Quake.slide(speed);
	}
}