// Battle.js

/*
	UpdateAttack() This goes in the update function and has a
	checks to see whether or not you had pressed the attack button
*/
var Arrow = new Projectile("Arrow","Arrow.rss","",Player.atk,true);
var BattleField = false;
function UpdateBattle()
{
	if(BattleField)
	{
	if (IsKeyPressed(KEY_CTRL) && !GetPersonValue("you","climb") && !GetPersonValue("you","attack") && Player.weapon != null)
	{
		var d = GetPersonValue("you","d");
		PlaySound(Swordslash,145);
		SetPersonFrame("you",0); // ??? in case you were thrown off frame?
		if (Player.weapon.type == "sword")
		{
			SetPersonValue("you","attack",true);
			DetachInput();
			if (d == "south") Animate("you","attacksouth",true);
			if (d == "north") Animate("you","attacknorth",true);
			if (d == "east") Animate("you","attackeast",true);
			if (d == "west") Animate("you","attackwest",true);
		}
		if (Player.weapon.type == "range" && !DoesPersonExist("Arrow"))
		{
			Arrow.create(32);
			Arrow.atk = Player.atk; // update it's atk.
			Arrow.setup();
			var d = GetPersonValue("you","d");
			if (d == "north") SetPersonScript("Arrow",SCRIPT_COMMAND_GENERATOR,'Arrow.move("north",NORTH)');
			if (d == "south") SetPersonScript("Arrow",SCRIPT_COMMAND_GENERATOR,'Arrow.move("south",SOUTH)');
			if (d == "east") SetPersonScript("Arrow",SCRIPT_COMMAND_GENERATOR,'Arrow.move("east",EAST)');
			if (d == "west") SetPersonScript("Arrow",SCRIPT_COMMAND_GENERATOR,'Arrow.move("west",WEST)');
		}
	}
	if (IsKeyPressed(KEY_ALT) && !GetPersonValue("you","climb")/* && Player.ticks == Player.maxTicks*/)
	{
		Spells[Player.spell].effect();
	}
	for (var i = 0; i < Auras.length; ++i)
	{
		Auras[i].update();
	}
	if (DoesPersonExist("Heal")){SetPersonX("Heal",GetPersonX("you"));SetPersonY("Heal",GetPersonY("you"));}
	Cut();
	}
}

/*
	This is used during the cool down time to finish up your attack and
	reset you to a noramal stance.
*/
function ResetAttack()
{
	if (GetPersonValue("you","attack") && Player.weapon.type == "sword")
	{
		if (IsCommandQueueEmpty("you")) {SetPersonValue("you","attack",false); SetPersonFrame("you",0); AttachInput("you");}
	}
	if (GetPersonValue("you","spell"))
	{
		if (IsCommandQueueEmpty("you"))
		{
			SetPersonValue("you","spell",false);
			AttachInput("you");
			SetPersonSpriteset("you",_tempSS2);
			SetPersonDirection("you",GetPersonValue("you","lastdirection"));
			SetPersonFrame("you",0);
		}
	}
}

/*
	There can only be one ticker object on at a time. This object is
	used as an indicator to tell you how much time is left on your
	current powerup. This only works on timed spells.
*/

function DrawAuraTicker()
{
	for(var i = 0; i < Auras.length; ++i)
	{
		with(Auras[i])
		{
			if (life > 0)
			{
				Rectangle(M2X(0,Player.x-7),M2Y(0,Player.y-32-(i*3)),life/maxlife*16,2,Blue);
				Outline(Player.x-7,Player.y-33-(i*3),Player.x+11,Player.y-30-(i*3));
				life--;
			}
		}
	}
}

// To check if a person exists (useful during combat)
function DoesPersonExist(name)
{
	var personList = GetPersonList();
	var i = personList.length;
	while (--i > -1)
	{
		if (name == personList[i]) return true;
	}
	return false;
}