// Animate.js by Radnen

/*
	GetDirectionNum() was sorta stolen from spherical when tunginobi made
	this example for getting the direction number in a spriteset. I figure
	this is the only way of doing so without adjusting loops or variable names...
*/
function GetDirectionNum(ss,direction)
{
	for (var i = 0; i < ss.directions.length; ++i)
	{
		if (ss.directions[i].name == direction) return i;
	}
	throw "could not find direction: " + direction + "in entity."; 
}

/*
	Animate function. It has a conditional for blocking events. This can
	be used for battle or in a cinematic when a certain animation needs playing.
*/
function Animate(person,direction,wait_time)
{
	SetPersonDirection(person,direction);
	var ss = GetPersonSpriteset(person);
	var dir = ss.directions[GetDirectionNum(ss,direction)];
	var frame_amt = dir.frames.length-1;
	var frame_update = dir.frames[0].delay;
	for (var frame = 0; frame < frame_amt; ++frame)
	{
		SetPersonValue(person,"frame",frame)
		for (var delay = 0; delay < frame_update; ++delay)
		{
			QueuePersonCommand(person,COMMAND_ANIMATE,false);
			if (wait_time) wait(8); // will block 8 ms
		}
	}
}

// This is a blocking code:
function wait(msecs)
{
	var time = GetTime();
	SetFrameRate(GetMapEngineFrameRate());
	while(time+msecs > GetTime())
	{
		UpdateMapEngine();
		RenderMap();
		FlipScreen();
	}
	SetFrameRate(0);
}

/*
	CreateEntityAnimation() is used to create a person that runs
	through an animate cycle and destroys itself when done. 
*/
function CreateEntityAnimation(name,spriteset,x,y,direction,layer)
{
	CreatePerson(name,spriteset,true);
	SetPersonXYFloat(name,x,y);
	Animate(name,direction,false);
	SetPersonScript(name,SCRIPT_COMMAND_GENERATOR,'if (IsCommandQueueEmpty(GetCurrentPerson())) DestroyPerson(GetCurrentPerson());');
}