// Pathfinding.js //
// By Radnen //
// Followed by Beakers Tutorial, silly me. //

function MovePath(name, x, y, layer, TargetX, TargetY, maxDistance)
{
	// Maximum checking distance, small for performance //
	if (maxDistance == undefined || maxDistance > 25) maxDistance = 25;
	
	if (x < 0 || y < 0)
	{
		x = Math.floor(GetPersonX(name)/GetTileWidth());
		y = Math.floor(GetPersonY(name)/GetTileHeight());
	}
	
	// Set up pathing array //
	var Path = [];
	for (var i = 0; i < GetLayerWidth(layer); i++) Path[i] = new Array(GetLayerHeight(layer));
	Path[x][y] = " "; // path starts clear.
	
	var TempPath = [maxDistance];
	// set the tiles 'status' mark as a default value.
	for (var i = 0; i < maxDistance; ++i) TempPath[i] = "";
	
	var LastBlocks1 = [200];
	// Set Players position into array //
	LastBlocks1[0] = x;
	LastBlocks1[1] = y;
	var LastBlocks2 = [200];
	
	// The players current position //
	var CurrentX = 0, CurrentY = 0;
	
	// Loop controls //
	var Found = false, Stop = false;
	
	// Index trackers for LastBlocks 1 & 2 //
	var Counter1 = 0, Counter2 = 0;
	// Set up rounds, a current tile the player will move to //
	var Round = 0;
	
	while(!Found && !Stop)
	{
		while (LastBlocks1[2*Counter1] != undefined)
		{
			CurrentX = LastBlocks1[2*Counter1];
			CurrentY = LastBlocks1[2*Counter1+1];
			
			// LEFT BLOCK //
			if (!CheckBlock(-1, 0, CurrentX, CurrentY, name) && IsPathValid(CurrentX-1, CurrentY, layer, Path))
			{
				Path[CurrentX-1][CurrentY] = "E";
				LastBlocks2[2*Counter2] = CurrentX-1;
				LastBlocks2[2*Counter2+1] = CurrentY;
				Counter2++;
				
				if (CurrentX-1 == TargetX && CurrentY == TargetY) { Found = true; break; }
			}

			// TOP BLOCK //
			if (!CheckBlock(0, -1, CurrentX, CurrentY, name) && IsPathValid(CurrentX, CurrentY-1, layer, Path))
			{
				Path[CurrentX][CurrentY-1] = "S";
				LastBlocks2[2*Counter2] = CurrentX;
				LastBlocks2[2*Counter2+1] = CurrentY-1;
				Counter2++;
				
				if (CurrentX == TargetX && CurrentY-1 == TargetY) { Found = true; break; }
			}
			
			// RIGHT BLOCK //
			if (!CheckBlock(1, 0, CurrentX, CurrentY, name) && IsPathValid(CurrentX+1, CurrentY, layer, Path))
			{
				Path[CurrentX+1][CurrentY] = "W";
				LastBlocks2[2*Counter2] = CurrentX+1;
				LastBlocks2[2*Counter2+1] = CurrentY;
				Counter2++;
				
				if (CurrentX+1 == TargetX && CurrentY == TargetY) { Found = true; break; }
			}

			// BOTTOM BLOCK //
			if (!CheckBlock(0, 1, CurrentX, CurrentY, name) && IsPathValid(CurrentX, CurrentY+1, layer, Path))
			{
				Path[CurrentX][CurrentY+1] = "N";
				LastBlocks2[2*Counter2] = CurrentX;
				LastBlocks2[2*Counter2+1] = CurrentY+1;
				Counter2++;
				
				if (CurrentX == TargetX && CurrentY+1 == TargetY) { Found = true; break; }
			}
			
			Counter1++;
		}
		// Reset Counters //
		Counter1 = 0;
		if (Counter2 == 0) Stop = true; // And stop round if unreachable.
		Counter2 = 0;
		
		// Move Information Over From LastBlocks2 //
		var I = 0;
		while (LastBlocks1[I] != undefined || LastBlocks2[I] != undefined)
		{
			if (LastBlocks2[I] != undefined)
			{
				LastBlocks1[I] = LastBlocks2[I];
				LastBlocks2[I] = undefined;
			}
			else LastBlocks1[I] = undefined;
			I++;
		}
		
		Round++; // Go to next round :)
	}
	
	// Now we play with the information //
	if (Found)
	{
		CurrentX = TargetX;
		CurrentY = TargetY;
		for (var i = 0; i < Round; ++i)
		{
			if (CurrentX == x && CurrentY == y) break;
			
			if (Path[CurrentX][CurrentY] == "E")
			{
				TempPath[i] = "W";
				CurrentX++;
			}
			else if (Path[CurrentX][CurrentY] == "N")
			{
				TempPath[i] = "S";
				CurrentY--;
			}
			else if (Path[CurrentX][CurrentY] == "W")
			{
				TempPath[i] = "E";
				CurrentX--;
			}
			else if (Path[CurrentX][CurrentY] == "S")
			{
				TempPath[i] = "N";
				CurrentY++;
			}
		}
		
		// output path to this string //
		var PathString = "";
		// Flip order,
		for (var i = 0; i < Round; ++i) PathString += "" + TempPath[Round-i-1];
	}
	else
	{
		var PathString = "";
	}
	
	PathString += "F"; // for finish //
	return PathString; // And we are done. //
}

// Checks to see if person can move to the tile //
function CheckBlock(xOff, yOff, x, y, name)
{
	const TILE_W = GetTileWidth(), TILE_H = GetTileHeight();
	
	return (IsPersonObstructed(name, (xOff+x+.5) * TILE_W - 1, (yOff+y+.5) * TILE_H - 1));
}

// Will return the validation of the path to see if you actually have a path within the screen //
function IsPathValid(x, y, layer, path)
{
	const LAYER_W = GetLayerWidth(layer), LAYER_H = GetLayerHeight(layer);

	if (x >= 0 && x < LAYER_W && y >= 0 && y < LAYER_H)
	{
		if (path[x][y] == undefined) return true;
	}
	return false;
}