//________________________________MAIN VEIN____________________________

//___The Blood_______

RequireScript("warping.js");
RequireScript("Pathfind.js");
RequireScript("Movement.js");
RequireSystemScript('time.js'); 
RequireSystemScript('screen.js');
RequireSystemScript('fademessage.js');
RequireSystemScript('colors.js');

//___The Oxygen_____
var UpPressed = false;
var Jumped = false;
var Falling = false;
var Hitting = false;
var font = GetSystemFont();
var Color = new Object();
var SW = GetScreenWidth();
var SH = GetScreenHeight();
var Yumz = {};
var Music = LoadSound("spooky.s3m");
var Music2 = LoadSound("zombie.mod");
Color.Normal = CreateColor(255, 255, 255);
Color.White = CreateColor(255, 255, 255);
Color.WhiteS = CreateColor(255, 255, 255, 128);
Color.Blue = CreateColor(0, 150, 240);
Color.Yellow = CreateColor(253, 176, 23);
Color.YellowS = CreateColor(253, 176, 23, 128);
Color.YellowS2 = CreateColor(253, 176, 23, 0);
Color.Rust = CreateColor(128, 128, 106);
Color.Grayed = CreateColor(184, 184, 184);
Color.Red = CreateColor(200, 0, 0);
Color.Cyan = CreateColor(0, 160, 198);
Color.CyanS = CreateColor(0, 160, 198, 128);
Color.Shadow = CreateColor(0, 0, 0, 128);
Color.Shadow2 = CreateColor(0, 0, 0, 64);
Color.Empty = CreateColor(0, 0, 0, 0);
Color.WShadow = CreateColor(255, 255, 255, 128);
Color.Black = CreateColor(0, 0, 0);
Color.Gray = CreateColor(128, 128, 128);
Color.Green = CreateColor(18, 150, 38);

var GAMEOVER = LoadImage("GameOver.PNG");
var Thnkyou = LoadImage("ThnksPage.PNG");

function Animate(person, direction, wait_time)
{
	SetPersonDirection(person,direction);
	var ss = GetPersonSpriteset(person);
	var dir = ss.directions[GetDirectionNum(ss, direction)];
	var frame_amt = dir.frames.length-1;
	var frame_update = dir.frames[0].delay;
	for (var frame = 0; frame < frame_amt; ++frame)
	{
		for (var delay = 0; delay < frame_update; ++delay)
		{
			QueuePersonCommand(person, COMMAND_ANIMATE, false);
			if (wait_time) wait(8); // will block 8 ms
		}
	}
}

// This is a blocking code: ohes noes!!! codez!!!
function wait(msecs)
{
	var time = GetTime();
	SetFrameRate(GetMapEngineFrameRate());
	while(time+msecs > GetTime())
	{
		UpdateMapEngine();
		RenderMap();
		FlipScreen();
	}
	SetFrameRate(0);
}

function ClearKeyQueue()
{
	while(AreKeysLeft()) GetKey();
}

function Die()
{
	ClearKeyQueue();
	while(!IsKeyPressed(KEY_ENTER))
	{
		RenderMap();
		GAMEOVER.blit(0, 0);
		BlinkTxt(font, SW/2-font.getStringWidth("Press Enter")/2, SH-96, "Press Enter");
		FlipScreen();
	}
	RestartLevel()
	//DestroyPerson("Yumz");
	//ExitMapEngine();	
}

function DrawBG()
{
	GradientRectangle(0, 0, SW, SH, Color.Blue, Color.Blue, Color.Black, Color.Black);
}

function Debug()
{
	font.drawText(0, 0, Yumz.toSource());
}

function BlinkTxt(font, x, y, text)
{
	var time = new Date();
	if (time.getMilliseconds() > 500) font.drawText(x, y, text);
}

function GetDirectionNum(ss,direction)
{
	for (var i = 0; i < ss.directions.length; ++i)
	{
		if (ss.directions[i].name == direction) return i;
	}
	throw "could not find direction: " + direction + "in entity."; 
}

//Radnen helped with this... and that and oh yeah, that too!!! :P

var Player = {}
Player.yv = 0;
Player.x = 0;
Player.y = 0;
Player.stop = false;

Yumz = Player;

function Gravity()
{
	Yumz.y = GetPersonY("Yumz");
	Yumz.x = GetPersonX("Yumz");

	if (!IsPersonObstructed("Yumz", Yumz.x, Yumz.y+2) && !Yumz.stop)
	{
		if (Yumz.yv < 2) Yumz.yv += 0.15;
		else Yumz.yv = 2, Falling = true;
		SetPersonY("Yumz", Yumz.y+Yumz.yv);
	}
	else if (IsPersonObstructed("Yumz", Yumz.x, Yumz.y+2)) Jumped = false, Yumz.yv = 2, Hitting = false;
	
	if (IsPersonObstructed("Yumz", Yumz.x, Yumz.y-1))
	{
		Yumz.stop = true;
		SetPersonY("Yumz", Yumz.y+2);
		Yumz.yv = 2;
		var name = GetObstructingPerson("Yumz", Yumz.x, Yumz.y-1);
		if (name != "" && !Falling && !Hitting)
		{
			if (GetPersonValue(name, "type") == "block")
			{
				Hitting = true;
				Animate(name, "break", false);
				SetPersonScript(name, SCRIPT_COMMAND_GENERATOR,
					'if (IsCommandQueueEmpty("' + name + '")) DestroyPerson("' + name + '");');
			}
		}
	}
	else Yumz.stop = false;
	
	if (IsKeyPressed(KEY_UP) && !Jumped && Yumz.yv == 2)
	{
		if (!UpPressed)
		{
			SetPersonY("Yumz", Yumz.y-2);
			Yumz.yv = -4;
			Jumped = true;
			Falling = false;
		}
		UpPressed = true;
	}
	if (!IsKeyPressed(KEY_UP) && !Jumped) UpPressed = false;
	if (IsKeyPressed(KEY_SHIFT)) SetPersonSpeed("Yumz", 2);
	else SetPersonSpeed("Yumz", 1);
	if (Yumz.y > GetLayerHeight(0)*16+96) Die();
}

	Gravity.prototype.upSlope = function()
	{
	  if (IsPersonObstructed(this.input.name, this.input.x+1, this.input.y) && this.input.direction == "east")
	    { 
	       SetPersonX(this.input.name, this.input.x+1);
	       SetPersonY(this.input.name, this.input.y-1);
	    }
	}

//___Pulmonary Artery___

function game()
{
	 CreateSaveFile();
	Music.play(true);
  var title = LoadImage ("Title.png");
  var menu = new Menu();
  menu.addItem ("-PLAY-", HeartBeat);
  menu.addItem ("-LOAD-", LoadGameMenu);
  menu.addItem ("-EXIT-", Exit);
  while (1)
  {
    title.blit(0, 0);
    menu.execute (SW/2-90, SH/1-90, 180, 35);
  }
}

//___Ventricles____
function HeartBeat()
{
	CreatePerson("Yumz", "ghost.rss", false);
	Yumz = Player;
	SetPersonFrameRevert("Yumz", 1); 
	AttachInput("Yumz");
	AttachCamera("Yumz");
	BindKey(KEY_SPACE, "", 'QueuePersonScript("Yumz", "Eat()", false);');
	BindKey(KEY_ESCAPE, "", "DestroyPerson('Yumz'); ExitMapEngine();");
	BindKey(KEY_SHIFT, "", "SaveOrDelete(2, true, Psycho_Ghost)");
	QueuePersonScript("Yumz", 'SetPersonDirection("Yumz", "west")', true);
	QueuePersonScript("Yumz", "SetLayerRenderer(0, 'DrawBG();')", true);
	SetUpdateScript("Gravity(); CheckForGameOver(); MoveToPlayer(); MoveLeftRight(); ");
	SetRenderScript("Debug();");
	BindKey(KEY_UP, '', '');
	MapEngine("map7.rmp", 60);

}

function Eat()	
{
	var D2 = GetPersonDirection("Yumz"); 
					
	if (D2 == "south") Animate("Yumz","eatsouth",true);
	if (D2 == "north") Animate("Yumz","eatnorth",true);
	if (D2 == "east") Animate("Yumz","eateast",true);
	if (D2 == "west") Animate("Yumz","eatwest",true);
	ResetYumz();
}
	
function ResetYumz()
{
		var D2 = GetPersonDirection("Yumz"); 
		
		if (D2 == "eatsouth") Animate("Yumz","south",true);
		if (D2 == "eatnorth") Animate("Yumz","north",true);
		if (D2 == "eateast") Animate("Yumz","east",true);
		if (D2 == "eatwest") Animate("Yumz","west",true);
}


// This will become our enemy //
function CreateEnemy()
{
	var name = GetCurrentPerson();
	SetPersonValue(name, "type", "enemy");
	SetPersonValue(name, "cmd", COMMAND_MOVE_WEST);
	IgnorePersonObstructions(name, true);
	SetPersonY(name, GetPersonY(name)-5);
}


// This will become a breakable block //
function CreateBlock()
{
	var name = GetCurrentPerson();
	SetPersonValue(name, "type", "block");
}

function CheckForGameOver()
{
	// We grab this persons position //
	if (DoesPersonExist("Yumz"))
	{
		var x = GetPersonX("Yumz")>>4;
		var y = GetPersonY("Yumz")>>4;
	}
	var List = GetPersonList()
	for (var i = 0; i < List.length; ++i)
	{
		if (GetPersonValue(List[i], "type") == "enemy") var name = List[i];
		if (DoesPersonExist(name))
		{
			// We grab the swords position //
			var sx = GetPersonX(name)>>4;
			var sy = GetPersonY(name)>>4;
			// And if the enemy is within the sword, destroy him. //
			if (x == sx && sy == y) Animate("Yumz", "GameOver", true), Die();
		}
	}
}

function MoveToPlayer()
{
	for (var i = 0; i < 10; ++i)
	{
		var name = "FlyEnemy_" + i;
		if (DoesPersonExist(name))
		{
			// Here, we grab the players tile x and y values //
			if (DoesPersonExist("Yumz"))
			{
				var ptx = Math.floor(GetPersonX("Yumz")>>4);
				var pty = Math.floor(GetPersonY("Yumz")>>4);
			}
			
			SetPersonIgnoreList(name, ["Yumz"]);
			MoveToLocation(name, ptx, pty, 1);
		}
	}
}

function MoveLeftRight()
{
	for (var i = 0; i < 10; ++i)
	{
		var name = "Enemy_" + i;
		if (DoesPersonExist(name))
		{
			var x = GetPersonX(name);
			var y = GetPersonY(name);
			QueuePersonCommand(name, GetPersonValue(name, "cmd"), false);
			if (IsPersonObstructed(name, x+1, y)) SetPersonValue(name, "cmd", COMMAND_MOVE_WEST), SetPersonDirection(name, "west");
			if (IsPersonObstructed(name, x-1, y)) SetPersonValue(name, "cmd", COMMAND_MOVE_EAST), SetPersonDirection(name, "east");
		}
	}
}

function DoesPersonExist(name)
{
	var people = GetPersonList();
	for (var i = 0; i < people.length; ++i)
	{
		if (people[i] == name) return true;
	}
	return false;
}

function Menu()
{
  if (this instanceof Menu == false) {
    return new Menu();
  }

  // default properties
  this.font            = LoadFont("main.rfn")
  this.window_style    = LoadWindowStyle("main.rws")
  this.arrow           = LoadImage("pointer.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
Menu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
Menu.prototype.execute = function(x, y, w, h) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = font.getHeight();
    var shown_items = Math.floor(h / text_height);

    this.selection = 0;
    this.top_selection = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);

      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) {
          font.setColorMask(Black);
          font.drawText(x + 16 + 1, y + i * text_height + 1, items[i + top_selection].name);
          font.setColorMask(items[i + top_selection].color);
          font.drawText(x + 16,     y + i * text_height,     items[i + top_selection].name);
        }
      }

      // draw the selection arrow
      arrow.blit(x, y + (selection - top_selection) * text_height);


      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];
            item.callback();
            return;
          }

          case KEY_ESCAPE: {
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }

        }
      } // end handle input
    }

  } // end with
}

function FadeOut(msecs,color)
{
	var time = GetTime();
	var bg = GrabImage(0,0,640,480);
	while (time + msecs > GetTime())
	{
    Color.alpha = (GetTime() - time) * 255 / msecs;
    bg.blit(0,0);
    //ApplyColorMask(color);
    FlipScreen();
	}
}


function Delay(time)
{
  var until = GetTime() + time;
  while(GetTime() < until) { }
}


//_______INTRO_________


var introfont = LoadFont("main.rfn");
var Thnkyou = LoadImage("ThnksPage.PNG");
var SP = LoadImage("SpherePage.PNG");
var VP = LoadImage("VaultPage.PNG");

function Outro()
{
	ExitMapEngine();
	Text1();
	Text2();
	Image1();
}

function Text1()
{
	FlipScreen()
	FadeOut(2500)
	Thnkyou.blit(0,0);
	FadeIn(5000)
	FlipScreen()
 }
 
 function Text2()
{
	FadeOut(2500)  
	SP.blit(0,0);
  FadeIn(5000)
	FlipScreen()
}

function Image1()
{
	FadeOut(2500)  
	VP.blit(0,0);
  FadeIn(5000)
	FlipScreen()
	game();
}

//__________________________________Save/Load Menu_______________--

  function Save_Data(SaveFile)
  {
    var location = new Object();
    location.map = GetCurrentMap();
    location.x   = GetPersonX("Yumz");
    location.y   = GetPersonY("Yumz");
	
    WriteData(location, SaveFile);
    WriteData(Characters, SaveFile);
    WriteData(Enemies, SaveFile);
  }
  
    function Read_Data(SaveFile)
  {
    var data_array = new Array();
    data_array[0]  = ReadData(SaveFile);//note, you must call ReadData the same amount of tiems as WriteData was called in Save_Data
    data_array[1]  = ReadData(SaveFile);
    data_array[2]  = ReadData(SaveFile);
	
    return data_array;
  }
  
    function Set_Data(data_array)
  {
    Characters = data_array[1];
    Enemies    = data_array[2];
    return       data_array[0];
  }
  
function LoadGame(filename)
{
	var File = OpenFile(filename);
	Level = File.read("ghghghg", Level);
	StopMusic();
	File.close();
	CreateBall();
	if (!IsMapEngineRunning())
	{
		if (Level < 10) MapEngine("Level_0"+Level+".rmp",GameSpeed);
		else MapEngine("Level_"+Level+".rmp",GameSpeed);
	}
	else
	{
		if (Level < 10) ChangeMap("Level_0"+Level+".rmp");
		else ChangeMap("Level_"+Level+".rmp");
	}
}

function LoadGameMenu()
{ 
  var title = LoadImage ("Title.png");
  var font            = LoadFont("main.rfn")
  var window    = LoadWindowStyle("main.rws")
	var Files = GetFileList("./save");
	var FilesLength = Files.length;
	var Arrow = new MArrow('pointer.png',SW/2-80,(SH/2-10-(10*FilesLength))+4);
	var sel = 0;
	while (true)
	{
		title.blit( 0, 0);
		font.drawText(SW/2-80,(SH/2-10-(10*FilesLength))-30,"LOAD GAME");
		window.drawWindow(SW/2-80,SH/2-10-(10*FilesLength),160,20+20*FilesLength);
		Arrow.blit();
		for (var i = 0; i < FilesLength; ++i)
		{
			font.drawText(SW/2-64,SH/2-10-(10*FilesLength)+i*20,Files[i]);
		}
		font.drawText(SW/2-64,SH/2-10-(10*FilesLength)+i*20,"Cancel");
		FlipScreen();
		while(AreKeysLeft())
		{
			switch (GetKey())
			{
				case KEY_UP:
					if(sel > 0) { sel--; Arrow.newY-=20; }
				break;
				case KEY_DOWN:
					if(sel < FilesLength) { sel++; Arrow.newY+=20; }
				break;
				case KEY_ENTER:
				case KEY_CTRL:
					if(sel < FilesLength)   RestoreSaveSlot(2);
					else Menu();
					return;
				break;
			}
		}
	}
}

// Create an Arrow Object
function MArrow(img,x,y)
{
	this.img = LoadImage(img);
	this.x = x;
	this.y = y;
	this.newX = x;
	this.newY = y;
}

MArrow.prototype.blit = function()
{
	with(this)
	{
		var nx = newX - x;
		var ny = newY - y;
		update();
		Line(x+img.width/2,y+img.height/2,x+img.width/2+nx,y+img.height/2+ny,Blue);
		Line(x+img.width/2+1,y+img.height/2,x+img.width/2+nx+1,y+img.height/2+ny,Blue);
		img.blit(x,y);
	}
}

MArrow.prototype.update = function()
{
	with(this)
	{
		if (newX > x) x++;
		if (newY > y) y++;
		if (newX < x) x--;
		if (newY < y) y--;
	}
}


//_______Restart Level_____________


function RestartLevel()
{
	SetPersonFrameRevert("Yumz", 1); 
	AttachInput("Yumz");
	AttachCamera("Yumz");
	ChangeMap(GetCurrentMap());
	QueuePersonScript("Yumz", "SetLayerRenderer(0, 'DrawBG();')", true);
	SetFrameRate(0);
}

//______________________Defining of the save and load functions_______________ Rhuan's Save Script

  
//an array in which all SaveFile Names will be stored
var SaveFileNames  = new Array();
//this scripts other global variables, maybe I could avoid having them global by improving my code...
var Count          = 0;
var size_of_header = 0;

/*This function will create the save file,
  if it does not already exsist, if it does
  exsist, it will populate the SaveFileNames
  array by reading in the save files which are
  stored at the start of the file.*/
function CreateSaveFile()
{  
  var SaveCheck        = OpenFile("SaveCheck.dot")
  var save_file_exists = SaveCheck.read("does_save_file_exist", false);
  if (!save_file_exists)
  {
    var SaveFile = OpenRawFile("../Save/SaveFile.dot", true);
    var gap = CreateByteArray(5);
    SaveFile.write(gap);
    WriteData(SaveFileNames, SaveFile);
    var position = SaveFile.getPosition();
    SaveFile.setPosition(0);
    WriteInteger(position, SaveFile);
    SaveFile.close();
    SaveCheck.write("does_save_file_exist", true);
  }
  else
  {
    var SaveFile = OpenRawFile("../Save/SaveFile.dot");
    SaveFile.setPosition(5);
    SaveFileNames = ReadData(SaveFile);
    SaveFile.close();
  }
} 

//this function writes the save file header
function WriteSaveFileHeader(SaveFile)
{
  var gap = CreateByteArray(5);
  SaveFile.write(gap);
  WriteData(SaveFileNames, SaveFile);
  size_of_header = SaveFile.getPosition();
  SaveFile.setPosition(0);
  WriteInteger(size_of_header, SaveFile);
  SaveFile.setPosition(size_of_header);
}

/*This function either creates a save file or deletes one
  you have to provide it with the slot number for the save
  file. The second parameter must be set to true for saving
  and false for deleting. the function expects you to have
  already added the save file's name onto the SaveFileNames
  array for saving, but for deleting it will remove the name
  itself.*/
function SaveOrDelete(slot, save_not_delete, name)
{
  var SaveFile  = OpenRawFile("../Save/SaveFile.dot");
  var TempFile  = OpenRawFile("../Save/TempFile.dot", true);
  var size_of_save_file = SaveFile.getSize();
  var save_data = SaveFile.read(size_of_save_file);
  TempFile.write(save_data);
  TempFile.close();
  var temp;
  SaveFile.setPosition(0);
  var size_of_old_header = ReadInteger(SaveFile);
  SaveFile.setPosition(size_of_old_header);
  var current_position;
  for (var i = 0; i < slot; ++i)
  {
    current_position = SaveFile.getPosition();
    temp = ReadInteger(SaveFile);
    SaveFile.setPosition(current_position + temp);
  }
  var slot_position = SaveFile.getPosition();
  SaveFile.setPosition(size_of_old_header);
  var data_before_slot = SaveFile.read(slot_position - size_of_old_header);
  SaveFile.setPosition(slot_position);
  var End = false;
  if(slot_position != SaveFile.getSize())
  {
    temp = ReadInteger(SaveFile);
    SaveFile.setPosition(slot_position + temp);
    var length_to_end = (SaveFile.getSize() - SaveFile.getPosition());
    var data_after_slot = SaveFile.read(length_to_end);
  }
  else
  {
    End = true;
  }
  SaveFile.close();
  var SaveFile = OpenRawFile("../Save/SaveFile.dot", true);
  if(!save_not_delete)
  {
    SaveFileNames.splice(slot, 1);
  }
  else
  {
    SaveFileNames[slot] = name;
  }
  WriteSaveFileHeader(SaveFile);
  SaveFile.write(data_before_slot);
  if (save_not_delete)
  {
    slot_position = SaveFile.getPosition();
    Count = 0;
    var gap = CreateByteArray(5);
    SaveFile.write(gap);
    Save_Data(SaveFile);
    Count = - Count;
    WriteData(Count, SaveFile);
    var size_of_data = SaveFile.getPosition() - slot_position;
    SaveFile.setPosition(slot_position);
    WriteInteger(size_of_data, SaveFile);
    if (!End)
    {
      SaveFile.setPosition(slot_position + size_of_data);
      SaveFile.write(data_after_slot);
    }
  }
  else
  {
    if (!End)
    {
      SaveFile.write(data_after_slot);
    }
  }
  SaveFile.close();
}

/*This function restores the contents of the save slot
  slot. If the save slot has been tampered
  with it doesn't restore the data, it returns false, and
  deletes the save slot*/
function RestoreSaveSlot(slot)
{
  //don't make any changes untill after the next comment.
  var SaveFile = OpenRawFile("../Save/SaveFile.dot");
  var current_position;
  for (var i = -1; i < slot; ++i)
  {
    current_position = SaveFile.getPosition();
    temp = ReadInteger(SaveFile);
    SaveFile.setPosition(current_position + temp);
  }
  SaveFile.setPosition(SaveFile.getPosition() + 5);
  Count         = 0;
  var temp_data = Read_Data(SaveFile)
  var compare   = ReadData(SaveFile);
  if(Count != 0)
  {
    SaveFile.close();
    SaveOrDelete(slot, false);
    return false;
  }
  return Set_Data(temp_data);
}

//type codes, these (with one exception) are the hex ascii values of the first letter of the type

var Saved_Object    = 0x6F;
var Custom_Save     = 0x63;
var Saved_Array     = 0x61;
var Saved_String    = 0x73;
var Saved_Integer   = 0x69;
var Saved_Float     = 0x66;
var Saved_Boolean   = 0x62;
var Saved_Undefined = 0x75;
var Saved_Function  = 0x70;//see if you can guess what this value come from
var Saved_Image     = 0x6D;//I is used for integers, so, m for image

/*This function is called to write data to the file,
  you have to provide the Data and the SaveFile*/
function WriteData(Data, SaveFile)
{
  //Firstly the type of the data needs to be determined
  var type_of_data = typeof(Data);
	
  if (Data instanceof Array)//arrays would otherwise appear as objects
  {
    type_of_data = "array";
  }
  else  if (Data instanceof String)//it is possible to make a string appear to be an object through defining it in a non-standard way
  {
    type_of_data = "string";
  }
  else if (Data instanceof Number)//numbers can also be thrown up as objects if they were defined in a non standard way
  {
    type_of_data = "number";
  }
  else if (typeof(Data) == "object")
  {
    if (typeof(Data.blit) == "function")
    {
      type_of_data = "image";
    }
  }
	
  switch (type_of_data)//the type of data is known, now to save it appropriately
  {
    case ("object")://an object can contain multiple pieces of data, and has no length property
	  {
      if (Data.Write instanceof Function &&
	        Data.Read  instanceof Function   )
      {
        WriteType(Custom_Save, SaveFile);//This object has custom read and write functions
        WriteData(Data.constructor.name, SaveFile);//Save the name of the class of which this object is an instance
        Data.Write(SaveFile);//Call the custom write function
      }
      else
      {
        if (typeof(Data.blit) != "function")
        {
          WriteType(Saved_Object, SaveFile);//save type
          WriteObject(Data, SaveFile);//call function to walk through the object, determining length and saving the contents
        }
      }
      break;
    }
    case ("array")://an array can contain multiple pieces of data
    {
      WriteType(Saved_Array, SaveFile);//save type
      WriteInteger(Data.length, SaveFile);//save number of entries in the array
      WriteArray(Data, SaveFile);//call function to loop through entries saving them
      break;
    }
    case ("string")://a string can be of any length and can contain almost any type of data type
    {
      WriteType(Saved_String, SaveFile);//save type
      WriteInteger(Data.length, SaveFile);//save length
      var string_to_save = CreateByteArrayFromString(Data);
      for (var i = 0; i < string_to_save.length; ++i)
      {
        Count += string_to_save[i];
        string_to_save[i] += 1;
      }
      SaveFile.write(string_to_save);//save data
      break;
    }
    case ("number"):
    {
      if (Math.floor(Data) == Data && Data < Math.pow(2, 32))//if a number does not have a decimal point, we can save it as an integer, this allows a far bigger number to be saved in the same amount of space
      {
        Count += Data;
        WriteType(Saved_Integer, SaveFile);
        WriteInteger(Data, SaveFile);
      }
      else//if it's not an integer we have to turn it into a string
      {
        WriteType(Saved_Float, SaveFile)
        WriteInteger(new String(Data).length, SaveFile);
        var float_to_save = CreateByteArrayFromString(Data)
        for (var i = 0; i < float_to_save.length; ++i)
        {
          Count += float_to_save[i];
        }
        SaveFile.write(float_to_save);
      }
      break;
    }
    case ("boolean")://a boolean can have two different values
    {
      WriteType(Saved_Boolean, SaveFile);//save type
      var byte_array_of_booloean = CreateByteArray(1)
      if (Data)//determine value
      {
        Count += 1;
        byte_array_of_booloean[0] = 1;
      }
      else
      {
        byte_array_of_booloean[0] = 0;
      }
      SaveFile.write(byte_array_of_booloean);//save data
      break;
    }
    case ("undefined")://data of type undefined can only have one possible value
    {
      WriteType(Saved_Undefined, SaveFile);//save type
      break;
    }
    case ("function"):
    {
      WriteType(Saved_Function, SaveFile);//save type
      var string_of_function = new String (Data);
      var i;
      var j = 0;
      while (i != "(")
      {
        i = string_of_function[j];
        ++j;
      }
      --j;

      var function_to_save = string_of_function.slice(j);
      WriteInteger(function_to_save.length, SaveFile);//save length
      var string_to_save = CreateByteArrayFromString(function_to_save);
      for (var i = 0; i < string_to_save.length; ++i)
      {
        Count += string_to_save[i];
        string_to_save[i] += 1;
      }
      SaveFile.write(string_to_save);//save data
      break;
    }
    case ("image"):
    {
      WriteType(Saved_Image, SaveFile);//save type
      Data.createSurface().save("../save/temp.png");
      var Temporary_File = OpenRawFile("../save/temp.png");
      Data = Temporary_File.read(Temporary_File.getSize());
      Temporary_File.close();
      WriteInteger(Data.length, SaveFile);
      SaveFile.write(Data);
      break;
    }
    default:
    {
      Abort("I am sorry, you have supplied my save\nscript with an unidentified data type.\n~Rhuan\n");
    }
  }
}

function WriteType (Type, SaveFile)//save the type of data
{
  var type = CreateByteArray(1)
  type[0] = Type;
  SaveFile.write(type);
}

function WriteArray(array, SaveFile)
{
  for (var i = 0; i < array.length; ++i)//loop through the array saving the data
  {
    WriteData(array[i], SaveFile);
  }
}

function WriteObject(object, SaveFile)
{  
  var length_of_object = 0;
  for (var i in object)//walk through the object to determine it's length
  {
    ++length_of_object;
  }
  WriteInteger(length_of_object, SaveFile);//save the length
  for (i in object)//walk through the object saving the entries and their names
  {
    WriteData(i, SaveFile);
    WriteData(object[i], SaveFile);
  }
}

function WriteInteger(Integer, SaveFile)//this function makes a number into a hex integer and saves it
{
  var array_of_integer      = new Array();
  array_of_integer[0]       = (Integer & 0xff000000) >> 24;
  array_of_integer[1]       = (Integer & 0x00ff0000) >> 16;
  array_of_integer[2]       = (Integer & 0x0000ff00) >> 8;
  array_of_integer[3]       = (Integer & 0x000000ff);
  var byte_array_of_integer = CreateByteArray(4);
  byte_array_of_integer[0]  = array_of_integer[0];
  byte_array_of_integer[1]  = array_of_integer[1];
  byte_array_of_integer[2]  = array_of_integer[2];
  byte_array_of_integer[3]  = array_of_integer[3];
  SaveFile.write(byte_array_of_integer);
}

/*This function is called to read data from the file
you need to set the right location in the file before
you call it, you have to supply it with the SaveFile object.*/
function ReadData(SaveFile)
{
  var type_of_data = SaveFile.read(1)[0];//lets read the type
  switch (type_of_data)
  {
    case (Saved_Object)://Objects contain multiple data fields, so a sepperate function is called to walk through them loading the data
    {
      return ReadObject(SaveFile);
    }
    case (Custom_Save)://An object with custom read and write functions
    {
      var name_of_class = ReadData(SaveFile);//read in the name of the class that the object was an isntance of
      return name_of_class.Read(SaveFile);//call the custom reading function 
    }
    case (Saved_Array)://Arrays contain multiple data fields, so a sepperate function is called to walk through them loading the data
    {
      return ReadArray(SaveFile);
    }
    case (Saved_String)://Strings can be of any length
    {
      var length_of_string = ReadInteger(SaveFile);//Read in the length
      var Data = SaveFile.read(length_of_string);//Read in the data
      for (var i = 0; i < length_of_string; ++i)
      {
        Data[i] -= 1;
        Count   += Data[i];
      }
      return CreateStringFromByteArray(Data);//Turn the data into a string
    }
    case (Saved_Integer)://As the code for loading an integer is called repeatedly it is in a sepperate function
    {
      var integer = ReadInteger(SaveFile);
      Count += integer;
      return integer;
    }
    case (Saved_Float)://A floating point number is treated just like a string
    {
      var length_of_float = ReadInteger(SaveFile);
      var Data = SaveFile.read(length_of_float);
      for(var i = 0; i < Data.length; ++i)
      {
        Count += Data[i];
      }
      return new Number(CreateStringFromByteArray(Data));
    }
    case (Saved_Boolean)://A boolean can have two different values
    {
      var Data = SaveFile.read(1)[0];//read in the data
      if (Data == 1)//now, is it true or false...
      {
        Count += 1;
        return true;
      }
      else
      {
        return false;
      }
    }
    case (Saved_Undefined)://Variables of type undefined can only have one value so...
    {
      return undefined;
    }
    case (Saved_Function):
    {
      var length_of_function = ReadInteger(SaveFile);//Read in the length
      var Data = SaveFile.read(length_of_function);//Read in the data
      for (var i = 0; i < length_of_function; ++i)
      {
        Data[i] -= 1;
        Count   += Data[i];
      }
      eval ("function function_data " + CreateStringFromByteArray(Data));
      return function_data;
    }
    case (Saved_Image):
    {
      var length_of_image = ReadInteger(SaveFile);
      var Data = SaveFile.read(length_of_image);
      var temp_file = OpenRawFile("../save/temp.png", true);
      temp_file.write(Data);
      temp_file.close()
      return LoadImage("../save/temp.png");
    }
    default:
    {
      Abort("Unrecognised data type identifier, either\nthe position to read from is not correct\nthis is a corrupt save file, or it was \nnot created with my SaveSystem\n ~Rhuan\n");
    }
  }
}

function ReadInteger(SaveFile)//Read in an integer
{
  var integer = 0;
  var byte_array_of_integer = SaveFile.read(4);
  integer += byte_array_of_integer[0] << 24;
  integer += byte_array_of_integer[1] << 16;
  integer += byte_array_of_integer[2] << 8;
  integer += byte_array_of_integer[3];
  return integer;
}

function ReadArray(SaveFile)//Read in an array
{
  var length_of_array = ReadInteger(SaveFile);//Find out how long the array is
  var array = new Array();
  for(var i = 0; i < length_of_array; ++i)//Loop through the array loading the data
  {
    array[i] = ReadData(SaveFile);
  }
  return array;
}

function ReadObject(SaveFile)//Read in an Object
{
  var length_of_object = ReadInteger(SaveFile);//determine how long the object is
  var object = new Object();
  for (var i = 0; i < length_of_object; ++i)//Walk throught the object loading the data
  {
    var name_of_entry     = ReadData(SaveFile);
    object[name_of_entry] = ReadData(SaveFile);
  }
  return object;
}
