/* Main */

const LINEAR = 0;
const SW = GetScreenWidth();
const SH = GetScreenHeight();

const ANIMATE = COMMAND_ANIMATE;
const NORTH = COMMAND_MOVE_NORTH;
const SOUTH = COMMAND_MOVE_SOUTH;
const EAST = COMMAND_MOVE_EAST;
const WEST = COMMAND_MOVE_WEST;
const WAIT = COMMAND_WAIT;

const HERO_NORMAL = LoadSpriteset("dp_hero.rss");
const HERO_RUN = LoadSpriteset("dp_hero_running.rss");

RequireScript('MoveSys.js');
RequireScript('Rad_Sound.js');

var TMS = new MoveSys();
TMS.setTileSize(16);

TMS.onHit = function() {
	QueuePersonCommand(this.input, ANIMATE, true);
	// play that damned hit bleep //
}

var Audio = new SoundEngine();

var Hero = {};

function game()
{
	Audio.play("Sundale Town.it");
	CreatePerson("main", "dp_hero.rss", false);
	TMS.attachInput("main");
	AttachCamera("main");
	SetPersonScript("main", SCRIPT_ON_TILE_ENTER, 'CreateGrass("main");');

	SetUpdateScript('TMS.update(); Controls();');
	SetRenderScript('LocationBar.renderArea();');
	LocationBar.setArea("Stepping Stone Beach");
	MapEngine("Town.rmp", 60);
}

function Controls()
{
	if (IsKeyPressed(KEY_SHIFT) && !Hero.running && IsCommandQueueEmpty("main")) {
		Hero.running = true;
		SetPersonSpriteset("main", HERO_RUN);
		SetPersonSpeed("main", 2);
	}
	else if (!IsKeyPressed(KEY_SHIFT) && IsCommandQueueEmpty("main")) {
		Hero.running = false;
		SetPersonSpriteset("main", HERO_NORMAL);
		SetPersonSpeed("main", 1);
	}
}

function CreateGrass(name)
{
	var x = GetPersonX(name);
	var y = GetPersonY(name);
	if (GetTileName(GetTile(x/16, y/16, 1)) != "Grass") return false;
	var name = "Grass" + x + y;
	if (DoesPersonExist(name)) return false;
	CreatePerson(name, "Grass.rss", true);
	IgnorePersonObstructions(name, true);
	SetPersonX(name, x);
	SetPersonY(name, y);
	for (var f = 0; f < 30; ++f) QueuePersonCommand(name, ANIMATE, false);
	SetPersonScript(name, SCRIPT_COMMAND_GENERATOR, 'DestroyAtEnd();');
}

function DestroyAtEnd()
{
	var me = GetCurrentPerson();
	if (IsCommandQueueEmpty(me)) DestroyPerson(me);
}

function DoesPersonExist(name)
{
	var people = GetPersonList();
	for (var i = 0; i < people.length; ++i)
	{
		if (people[i] == name) return true;
	}
	return false;
}

var LocationBar = ({
	window: LoadWindowStyle("menu.rws"),
	font: LoadFont("talkfont.rfn"),
	time: 0,
	alpha: 0,
	step: 3,
	color: CreateColor(255, 255, 255, 0),
	name: "",
	
	setArea: function(areaname) {
		this.name = areaname;
		this.time = GetTime();
		this.step = 0;
	},
	
	renderArea: function() {
		switch(this.step) {
			case 0:
				this.window.drawWindow(8, 8, 120, 12);
				this.font.drawText(8, 8, this.name);
				if (this.time + 500 > GetTime()) {
					this.color.alpha = (GetTime() - this.time) * 255 / 500;
				} else {
					this.color.alpha = 255;
					this.time = GetTime();
					this.step++;
				}
				this.window.setColorMask(this.color);
			break;
			case 1:
				this.window.drawWindow(8, 8, 120, 12);
				this.font.drawText(8, 8, this.name);
				if (this.time + 500 < GetTime()) {
					this.time = GetTime();
					this.step++;
				}
			break;
			case 2:
				this.window.drawWindow(8, 8, 120, 12);
				this.font.drawText(8, 8, this.name);
				if (this.time + 500 > GetTime()) {
					this.color.alpha = 255 - (GetTime() - this.time) * 255 / 500;
				} else {
					this.color.alpha = 0;
					this.time = GetTime();
					this.step++;
				}
				this.window.setColorMask(this.color);
			break;
		}
	}
});