// Pokedex game script by Feek.
// a startup program that looks like a pokedex!
//------=== GAME VARIABLES ===------//
// looks best with the font set to courier size 10.
var bg        = LoadImage("Background.png")
var selbar1   = LoadImage("Selectbar.png");
var selbar2   = LoadImage("Selectbar2.png");
var selector1 = LoadImage("Selector.png");
var selector2 = LoadImage("Selector2.png");
var font      = LoadFont("Font1.rfn");
font.setColorMask(CreateColor(0,0,0));
var g_list    = GetGameList();
var sw        = GetScreenWidth();
var sh        = GetScreenHeight();
var pokeball  = LoadImage("Pokeball.png");

//------=== MAIN GAME LOOP ===------//
function game()
{
var selection = 0;
var rotate    = 0;
while(true)
{
	Rectangle(0,0,sw,sh,CreateColor(239,243,157))
	if (IsWindowDoubled() == false) // low-res:
	{
		selbar1.blit(157,112);
		for (var i = 0; i < g_list.length; ++i)
		{
			if (g_list[i].name.toLowerCase().indexOf("pokemon")> -1||g_list[i].name.toLowerCase().indexOf("pokmon")> -1)
			{ // thanks tunginobi!
				Rectangle(160,113-(selection*16)+i*16,130,14,CreateColor(255,255,125));
			}
			font.drawText(160,116-(selection*16)+i*16,(i+1) + ". " + g_list[i].name);
		}
		bg.blit(0,0);
		font.drawTextBox(32,88,109,64,0,g_list[selection].name + "\nBy:\n" + g_list[selection].author);
		selector1.blit(293,55+selection*(128/g_list.length));
	}
	else // hi-res:
	{
		pokeball.rotateBlit(420,200,rotate);
		selbar2.blit(314,234);
		for (var i = 0; i < g_list.length; ++i)
		{
			if (g_list[i].name.toLowerCase().indexOf("pokemon")> -1||g_list[i].name.toLowerCase().indexOf("pokmon")> -1)
			{ // thanks tunginobi!
				Rectangle(320,235-(selection*16)+i*16,260,14,CreateColor(255,255,125));
			}
			font.drawTextBox(320,238-(selection*16)+i*16,260,14,0,(i+1) + ". " + g_list[i].name)
		}
		bg.zoomBlit(0,0,2);
		Rectangle(64,212,218,92,CreateColor(225,225,225));
		font.drawTextBox(64,176,218,128,0,g_list[selection].name + "\nBy: " + g_list[selection].author + "\nPath: "
																		+ g_list[selection].directory +"\nDescription:\n" +
		/*ternary operator*/	((g_list[selection].description != "") ? g_list[selection].description : "None."));
		selector2.blit(588,110+selection*(256/g_list.length));
	}
	FlipScreen();
	while(AreKeysLeft())
	{
		switch(GetKey())
		{
		case KEY_UP:
		if (selection > 0)
		{
			selection--;
			rotate+=Math.PI/8;
		}
		break;
		case KEY_DOWN:
		if (selection < g_list.length - 1)
		{
			selection++;
			rotate-=Math.PI/8;
		}
		break;
		case KEY_ENTER:
		ExecuteGame(g_list[selection].directory)
		break;
		case KEY_ESCAPE:
		Exit();
		return;
		break;
		case KEY_PAGEDOWN:
		if (IsWindowDoubled() == false)
		{
			if (selection > g_list.length - 4 && selection < g_list.length - 1)
			{
				selection = g_list.length - 1;
			}
			if (selection < g_list.length - 1)
			{
				selection+=4;
			}
		}
		else
		{
			if (selection > g_list.length - 8 && selection < g_list.length - 1)
			{
				selection = g_list.length - 1;
				rotate = (Math.PI/8)*(g_list.length+3);
			}
			if (selection < g_list.length - 1)
			{
				selection+=8;
				rotate+=(Math.PI/8)*8
			}
		}
		break;
		case KEY_PAGEUP:
		if (IsWindowDoubled() == false)
		{
			if (selection > 0 && selection < 4)
			{
				selection=0;
			}
			if (selection > 0)
			{
				selection-=4;
			}
		}
		else
		{
			if (selection > 0 && selection < 8)
			{
				selection=0;
				rotate=0
			}
			if (selection > 0)
			{
				selection-=8;
				rotate-=(Math.PI/8)*8
			}
		}
		break;
		case KEY_F1:
		if (IsWindowDoubled() == false)
		{
			Resolution(640,480);
		}
		else
		{
			Resolution(320,240);
		}
		break;
		case KEY_END:
			selection = g_list.length-1;
			rotate = (Math.PI/8)*(g_list.length+3);
		break
		case KEY_HOME:
			selection = 0;
			rotate=0;
		break;
		}
	}
}
}
function IsWindowDoubled()
{
	if (sw == 640|| sh == 480) return true;
	else return false;
}
function Resolution(width, height)
{
	var thisfile = OpenFile("../game.sgm");
	thisfile.write("screen_height", height);
	thisfile.write("screen_width", width);
	thisfile.flush();
	thisfile.close();
	RestartGame();
	return;
}
/*function DefaultDriver(driver)// this will make it run in standard32 if your experiencing problems
{// with other drivers and this software.
	var editor = OpenFile(".../editor.ini");
	editor.write("[Video]Driver=", driver);
	editor.flush();
	editor.close();
	RestartGame();
	return;
} */